/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;

public class ValidationUtil {
    private static final Pattern REGEX_USER_NAME = Pattern.compile("^[^<>^!#&()/\\|\"?,:{}= ~`*%$]*$");
    private static final Pattern REGEX_FIRST_LAST_NAME = Pattern.compile("^[\\p{L}]++(?:[' -][\\p{L}]++)*+\\.?$");
    private static final Pattern REGEX_EMAIL = Pattern.compile("^[_A-Za-z0-9-\\+']+(\\.[_A-Za-z0-9-']+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private static final Pattern REGEX_ORGANISATION_NAME = Pattern.compile("^[^<>^*@%$]*$");
    private static final Pattern REGEX_PASSWORD_UPPER_CASE = Pattern.compile("[A-Z]");
    private static final Pattern REGEX_PASSWORD_LOWER_CASE = Pattern.compile("[a-z]");
    private static final Pattern REGEX_PASSWORD_NUMERICS = Pattern.compile("\\d");
    private static final Pattern REGEX_PASSWORD_SYMBOLS = Pattern.compile("[`~!@#$%^&*\\(\\)_\\-+={}\\[\\]\\\\|:\\;\\\"\\'\\<\\>,.?\\/]");
    private static final Pattern REGEX_PASSWORD_CHARATERS_ALLOWED = Pattern.compile("^[A-Za-z0-9\\d`~!@#$%^&*\\(\\)_\\-+={}\\[\\]\\\\|:\\;\\\"\\'\\<\\>,.?\\/]*$");

    public static boolean isUserNameValid(String userName) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_USERNAME);
        if (isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_USER_NAME, userName);
        }
        return true;
    }

    public static boolean isFirstLastNameValid(String name) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_FIRST_LAST_NAME);
        if (isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_FIRST_LAST_NAME, name);
        }
        return true;
    }

    public static boolean isPasswordValueValid(String password, String password2) {
        boolean isUpperCase;
        boolean isLowerCase;
        boolean isNumerics;
        boolean isSymbols;
        if (password == null || password2 == null || !password.equals(password2)) {
            return false;
        }
        boolean isCharactersAllowed = ValidationUtil.isRegexMatches(REGEX_PASSWORD_CHARATERS_ALLOWED, password);
        if (!isCharactersAllowed) {
            return false;
        }
        int isValidationRequiredMinLength = Configuration.getAsInt(ConfigurationKeys.PASSWORD_POLICY_MINIMUM_CHARACTERS);
        if (password.length() < isValidationRequiredMinLength) {
            return false;
        }
        boolean isValidationRequiredSymbols = Configuration.getAsBoolean(ConfigurationKeys.PASSWORD_POLICY_SYMBOLS);
        if (isValidationRequiredSymbols && !(isSymbols = ValidationUtil.isRegexFound(REGEX_PASSWORD_SYMBOLS, password))) {
            return false;
        }
        boolean isValidationRequiredNumerics = Configuration.getAsBoolean(ConfigurationKeys.PASSWORD_POLICY_NUMERICS);
        if (isValidationRequiredNumerics && !(isNumerics = ValidationUtil.isRegexFound(REGEX_PASSWORD_NUMERICS, password))) {
            return false;
        }
        boolean isValidationRequiredLowerCase = Configuration.getAsBoolean(ConfigurationKeys.PASSWORD_POLICY_LOWERCASE);
        if (isValidationRequiredLowerCase && !(isLowerCase = ValidationUtil.isRegexFound(REGEX_PASSWORD_LOWER_CASE, password))) {
            return false;
        }
        boolean isValidationRequiredUpperCase = Configuration.getAsBoolean(ConfigurationKeys.PASSWORD_POLICY_UPPERCASE);
        return !isValidationRequiredUpperCase || (isUpperCase = ValidationUtil.isRegexFound(REGEX_PASSWORD_UPPER_CASE, password));
    }

    public static boolean isEmailValid(String email) {
        return ValidationUtil.isEmailValid(email, true);
    }

    public static boolean isEmailValid(String email, boolean checkConfiguration) {
        boolean isValidationRequired = Configuration.getAsBoolean(ConfigurationKeys.USER_VALIDATION_REQUIRED_EMAIL);
        if (!checkConfiguration || checkConfiguration && isValidationRequired) {
            return ValidationUtil.isRegexMatches(REGEX_EMAIL, email);
        }
        return true;
    }

    public static boolean isOrgNameValid(String orgName) {
        boolean isOrgNameValid = ValidationUtil.isRegexMatches(REGEX_ORGANISATION_NAME, orgName);
        return isOrgNameValid;
    }

    private static boolean isRegexMatches(Pattern pattern, String input) {
        if (input == null) {
            return true;
        }
        Matcher m = pattern.matcher(input.trim());
        return m.matches();
    }

    private static boolean isRegexFound(Pattern pattern, String input) {
        if (input == null) {
            return true;
        }
        Matcher m = pattern.matcher(input.trim());
        return m.find();
    }

    public static boolean isMinWordsLimitReached(String text, int minWordsLimit, boolean isDerivedFromCKEditor) {
        String cleanedString;
        if (minWordsLimit <= 0) {
            return true;
        }
        if (StringUtils.isBlank((String)text)) {
            return false;
        }
        text = isDerivedFromCKEditor ? WebUtil.removeHTMLtags(text) : text.replaceAll("(?:<BR>)", " ");
        int wordCount = 0;
        if (text.length() > 0 && (wordCount = (cleanedString = text.replaceAll("['\";:,\\.\\?\\-!]+", "").trim()).split("\\S+").length) == 0 && cleanedString.length() > 0) {
            wordCount = 1;
        }
        return wordCount >= minWordsLimit;
    }
}

