/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.util;

import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForward;

public class TokenProcessor {
    public static String TRANSACTION_TOKEN_KEY = "org.lamsfoundation.lams.action.TOKEN";
    public static String TOKEN_KEY = "lams_token";
    public static String TRANSACTION_FORWARDS = "org.lamsfoundation.lams.action.FORWARD";
    private long previous;
    private static TokenProcessor instance = new TokenProcessor();
    private static org.apache.struts.util.TokenProcessor strutsTokenProcessor = org.apache.struts.util.TokenProcessor.getInstance();

    public static TokenProcessor getInstance() {
        return instance;
    }

    protected TokenProcessor() {
    }

    private HashMap getTokens(HttpSession session) {
        HashMap tokens = (HashMap)session.getAttribute(TRANSACTION_TOKEN_KEY);
        return tokens;
    }

    private void setTokens(HttpSession session, HashMap tokens) {
        session.setAttribute(TRANSACTION_TOKEN_KEY, (Object)tokens);
    }

    private String getTokenFromRequest(HttpServletRequest request) {
        String token = request.getParameter(TOKEN_KEY);
        return token;
    }

    private void setTokenInRequest(HttpServletRequest request, String token) {
        request.setAttribute(TOKEN_KEY, (Object)token);
    }

    private HashMap getForwards(HttpSession session) {
        HashMap forwards = (HashMap)session.getAttribute(TRANSACTION_FORWARDS);
        return forwards;
    }

    private void setForwards(HttpSession session, HashMap forwards) {
        session.setAttribute(TRANSACTION_FORWARDS, (Object)forwards);
    }

    public synchronized boolean isTokenValid(HttpServletRequest request) {
        return this.isTokenValid(request, false);
    }

    public synchronized boolean isTokenValid(HttpServletRequest request, boolean reset) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        HashMap tokens = this.getTokens(session);
        if (tokens == null) {
            return false;
        }
        String token = this.getTokenFromRequest(request);
        if (token == null) {
            return false;
        }
        Long timestamp = (Long)tokens.get(token);
        if (reset) {
            this.resetToken(request);
        }
        return timestamp != null;
    }

    public synchronized void resetToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        HashMap tokens = this.getTokens(session);
        if (tokens == null) {
            return;
        }
        String token = this.getTokenFromRequest(request);
        if (token == null) {
            return;
        }
        tokens.remove(token);
    }

    public synchronized void saveToken(HttpServletRequest request) {
        String token;
        HttpSession session = request.getSession(true);
        HashMap<String, Long> tokens = this.getTokens(session);
        if (tokens == null) {
            tokens = new HashMap<String, Long>();
        }
        if ((token = this.generateToken(request)) != null) {
            Long timestamp = new Long(new Date().getTime());
            tokens.put(token, timestamp);
            this.setTokens(session, tokens);
            this.setTokenInRequest(request, token);
        }
    }

    public synchronized String generateToken(HttpServletRequest request) {
        return strutsTokenProcessor.generateToken(request);
    }

    public synchronized void saveForward(HttpServletRequest request, ActionForward actionForward) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        String token = this.getTokenFromRequest(request);
        if (token == null) {
            return;
        }
        HashMap<String, Forward> forwards = this.getForwards(session);
        if (forwards == null) {
            forwards = new HashMap<String, Forward>();
        }
        Long timestamp = new Long(new Date().getTime());
        Forward forward = new Forward();
        forward.setActionForward(actionForward);
        forward.setTimestamp(timestamp);
        forwards.put(token, forward);
        this.setForwards(session, forwards);
    }

    public synchronized ActionForward getForward(HttpServletRequest request) {
        return this.getForward(request, false);
    }

    public synchronized ActionForward getForward(HttpServletRequest request, boolean reset) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String token = this.getTokenFromRequest(request);
        if (token == null) {
            return null;
        }
        HashMap forwards = this.getForwards(session);
        if (forwards == null) {
            return null;
        }
        Forward forward = (Forward)forwards.get(token);
        if (forward == null) {
            return null;
        }
        if (reset) {
            forwards.remove(forward);
        }
        return forward.getActionForward();
    }

    private class Forward {
        private ActionForward actionForward;
        private Long timestamp;

        private Forward() {
        }

        public ActionForward getActionForward() {
            return this.actionForward;
        }

        public void setActionForward(ActionForward actionForward) {
            this.actionForward = actionForward;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

