/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDeliveryMethod {
    protected final String signature;
    protected final String description;
    protected final short id;
    protected long sendTimeout = Long.MAX_VALUE;

    protected AbstractDeliveryMethod(short id, String signature, String description) throws InvalidParameterException {
        if (StringUtils.isEmpty((String)signature)) {
            throw new InvalidParameterException("Signature can not be blank.");
        }
        this.signature = signature;
        this.description = description;
        this.id = id;
    }

    protected abstract String send(Long var1, String var2, String var3) throws InvalidParameterException;

    public String getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractDeliveryMethod && ((AbstractDeliveryMethod)o).signature.equalsIgnoreCase(this.signature);
    }

    public short getId() {
        return this.id;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }
}

