/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.EventNotificationService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.Emailer;

public class DeliveryMethodMail
extends AbstractDeliveryMethod {
    private static DeliveryMethodMail instance;

    protected DeliveryMethodMail() {
        super((short)1, "MAIL", "Messages will be send by Mail");
    }

    public String send(Long userId, String subject, String message) throws InvalidParameterException {
        if (userId == null) {
            return "User ID should not be null.";
        }
        try {
            User user = (User)EventNotificationService.getInstance().getUserManagementService().findById(User.class, Integer.valueOf(userId.intValue()));
            if (user == null) {
                return "User with the provided ID was not found.";
            }
            String email = user.getEmail();
            if (StringUtils.isBlank((String)email)) {
                return "User's e-mail address is blank.";
            }
            this.sendFromSupportEmail(subject, email, message);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static DeliveryMethodMail getInstance() {
        if (instance == null) {
            instance = new DeliveryMethodMail();
        }
        return instance;
    }

    public void sendFromSupportEmail(String subject, String to, String body) throws AddressException, MessagingException {
        Emailer.sendFromSupportEmail((String)subject, (String)to, (String)body);
    }

    void notifyAdmin(String subject, String body) throws AddressException, MessagingException {
        String adminEmail = Configuration.get("LamsSupportEmail");
        if (!StringUtils.isEmpty((String)adminEmail)) {
            this.sendFromSupportEmail(subject, adminEmail, body);
        }
    }
}

