/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.gradebook.GradebookUserActivity;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.dao.IGradebookDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradebookDAO
extends BaseDAO
implements IGradebookDAO {
    private static final String GET_GRADEBOOK_USER_ACTIVITY = "from GradebookUserActivity gact where gact.learner.userId=:userID and gact.activity.activityId=:activityID";
    private static final String GET_GRADEBOOK_USER_LESSON = "from GradebookUserLesson gles where gles.learner.userId=:userID and gles.lesson.lessonId=:lessonID";
    private static final String GET_GRADEBOOK_ACTIVITIES_FROM_LESSON_SUM = "select sum(gact.mark) from GradebookUserActivity gact, ToolSession tses where gact.learner.userId=:userID and tses.toolActivity=gact.activity and tses.lesson.lessonId=:lessonID";
    private static final String GET_GRADEBOOK_USER_ACTIVITIES_FOR_ACTIVITY = "from GradebookUserActivity gact where gact.activity.activityId=:activityID";
    private static final String GET_AVERAGE_MARK_FOR_LESSON = "select avg(gles.mark) from GradebookUserLesson gles where gles.lesson.lessonId=:lessonID";
    private static final String GET_AVERAGE_COMPLETION_TIME = "select prog.finishDate, prog.startDate from LearnerProgress prog where prog.lesson.lessonId=:lessonID";
    private static final String GET_AVERAGE_COMPLETION_TIME_ACTIVITY = "select compProg.finishDate, compProg.startDate from CompletedActivityProgress compProg, Activity act where compProg.activity.activityId=:activityID";
    private static final String GET_AVERAGE_MARK_FOR_ACTIVTY = "select avg(gact.mark) from GradebookUserActivity gact where gact.activity.activityId=:activityID";
    private static final String GET_AVERAGE_MARK_FOR_GROUPED_ACTIVTY = "select avg(gact.mark) from GradebookUserActivity gact, GroupUser gu, Group grp where gact.activity.activityId=:activityID and grp.groupId=:groupID and gu.user=gact.learner and gu.group=grp";
    private static final String GET_AVERAGE_COMPLETION_TIME_GROUPED_ACTIVITY = "select compProg.finishDate, compProg.startDate from CompletedActivityProgress compProg, Activity act, Group grp, GroupUser gu where compProg.activity.activityId=:activityID and grp.groupId=:groupID and gu.user=compProg.learnerProgress.user and gu.group=grp";

    @Override
    public GradebookUserActivity getGradebookUserDataForActivity(Long activityID, Integer userID) {
        List result = this.getSession().createQuery(GET_GRADEBOOK_USER_ACTIVITY).setInteger("userID", userID.intValue()).setLong("activityID", activityID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (GradebookUserActivity)result.get(0);
        }
        return null;
    }

    @Override
    public GradebookUserLesson getGradebookUserDataForLesson(Long lessonID, Integer userID) {
        List result = this.getSession().createQuery(GET_GRADEBOOK_USER_LESSON).setInteger("userID", userID.intValue()).setLong("lessonID", lessonID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (GradebookUserLesson)result.get(0);
        }
        return null;
    }

    @Override
    public Double getGradebookUserActivityMarkSum(Long lessonID, Integer userID) {
        List result = this.getSession().createQuery(GET_GRADEBOOK_ACTIVITIES_FROM_LESSON_SUM).setInteger("userID", userID.intValue()).setLong("lessonID", lessonID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (Double)result.get(0);
        }
        return 0.0;
    }

    @Override
    public List<GradebookUserActivity> getAllGradebookUserActivitiesForActivity(Long activityID) {
        List result = this.getSession().createQuery(GET_GRADEBOOK_USER_ACTIVITIES_FOR_ACTIVITY).setLong("activityID", activityID.longValue()).list();
        return result;
    }

    @Override
    public Double getAverageMarkForLesson(Long lessonID) {
        List result = this.getSession().createQuery(GET_AVERAGE_MARK_FOR_LESSON).setLong("lessonID", lessonID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (Double)result.get(0);
        }
        return 0.0;
    }

    @Override
    public long getAverageDurationLesson(Long lessonID) {
        List result = this.getSession().createQuery(GET_AVERAGE_COMPLETION_TIME).setLong("lessonID", lessonID.longValue()).list();
        if (result != null && result.size() > 0) {
            long sum = 0L;
            long count = 0L;
            for (Object[] dateObjs : result) {
                if (dateObjs == null || dateObjs.length != 2) continue;
                Date finishDate = (Date)dateObjs[0];
                Date startDate = (Date)dateObjs[1];
                if (startDate == null || finishDate == null) continue;
                sum += finishDate.getTime() - startDate.getTime();
                ++count;
            }
            if (count > 0L) {
                return sum / count;
            }
        }
        return 0L;
    }

    @Override
    public long getAverageDurationForActivity(Long activityID) {
        List result = this.getSession().createQuery(GET_AVERAGE_COMPLETION_TIME_ACTIVITY).setLong("activityID", activityID.longValue()).list();
        if (result != null && result.size() > 0) {
            long sum = 0L;
            long count = 0L;
            for (Object[] dateObjs : result) {
                if (dateObjs == null || dateObjs.length != 2) continue;
                Date finishDate = (Date)dateObjs[0];
                Date startDate = (Date)dateObjs[1];
                if (startDate == null || finishDate == null) continue;
                sum += finishDate.getTime() - startDate.getTime();
                ++count;
            }
            if (count > 0L) {
                return sum / count;
            }
        }
        return 0L;
    }

    @Override
    public Double getAverageMarkForActivity(Long activityID) {
        List result = this.getSession().createQuery(GET_AVERAGE_MARK_FOR_ACTIVTY).setLong("activityID", activityID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (Double)result.get(0);
        }
        return 0.0;
    }

    @Override
    public Double getAverageMarkForGroupedActivity(Long activityID, Long groupID) {
        List result = this.getSession().createQuery(GET_AVERAGE_MARK_FOR_GROUPED_ACTIVTY).setLong("activityID", activityID.longValue()).setLong("groupID", groupID.longValue()).list();
        if (result != null && result.size() > 0) {
            return (Double)result.get(0);
        }
        return 0.0;
    }

    @Override
    public long getAverageDurationForGroupedActivity(Long activityID, Long groupID) {
        List result = this.getSession().createQuery(GET_AVERAGE_COMPLETION_TIME_GROUPED_ACTIVITY).setLong("activityID", activityID.longValue()).setLong("groupID", groupID.longValue()).list();
        if (result != null && result.size() > 0) {
            long sum = 0L;
            long count = 0L;
            for (Object[] dateObjs : result) {
                if (dateObjs == null || dateObjs.length != 2) continue;
                Date finishDate = (Date)dateObjs[0];
                Date startDate = (Date)dateObjs[1];
                if (startDate == null || finishDate == null) continue;
                sum += finishDate.getTime() - startDate.getTime();
                ++count;
            }
            if (count > 0L) {
                return sum / count;
            }
        }
        return 0L;
    }
}

