/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.TextSearchConditionDTO;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.web.TextSearchActionForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSearchCondition
extends BranchCondition
implements Cloneable {
    protected String allWords;
    protected String phrase;
    protected String anyWords;
    protected String excludedWords;
    protected static final String NON_WORD_DELIMITER_REGEX = "(?:\\W|$|^)+";
    protected static final String WHITESPACE_DELIMITER_REGEX = "(?:\\s|$|^)+";
    protected static final int PATTERN_MATCHING_OPTIONS = 74;
    private static Logger log = Logger.getLogger(TextSearchCondition.class);
    protected boolean conditionsParsed = false;
    protected List<String> allWordsCondition = new ArrayList<String>();
    protected List<String> phraseCondition;
    protected List<String> anyWordsCondition = new ArrayList<String>();
    protected List<String> excludedWordsCondition = new ArrayList<String>();

    public TextSearchCondition() {
    }

    public TextSearchCondition(TextSearchConditionDTO conditionDTO) {
        super(conditionDTO);
        this.allWords = conditionDTO.getAllWords();
        this.phrase = conditionDTO.getPhrase();
        this.anyWords = conditionDTO.getAnyWords();
        this.excludedWords = conditionDTO.getExcludedWords();
    }

    public TextSearchCondition(Long conditionId, Integer conditionUIID, Integer orderId, String name, String displayName, String type, String startValue, String endValue, String exactMatchValue, String allWords, String phrase, String anyWords, String excludedWords) {
        super(conditionId, conditionUIID, orderId, name, displayName, type, startValue, endValue, exactMatchValue);
        this.allWords = allWords;
        this.phrase = phrase;
        this.anyWords = anyWords;
        this.excludedWords = excludedWords;
    }

    @Override
    public TextSearchCondition clone(int uiidOffset) {
        Integer newConditionUIID = LearningDesign.addOffset(this.conditionUIID, uiidOffset);
        return new TextSearchCondition(null, newConditionUIID, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue, this.allWords, this.phrase, this.anyWords, this.excludedWords);
    }

    @Override
    public Object clone() {
        return new TextSearchCondition(null, null, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue, this.allWords, this.phrase, this.anyWords, this.excludedWords);
    }

    public String getAllWords() {
        return this.allWords;
    }

    public List<String> getAllWordsCondition() {
        return this.allWordsCondition;
    }

    public String getAnyWords() {
        return this.anyWords;
    }

    public List<String> getAnyWordsCondition() {
        return this.anyWordsCondition;
    }

    public String getExcludedWords() {
        return this.excludedWords;
    }

    public List<String> getExcludedWordsCondition() {
        return this.excludedWordsCondition;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public List<String> getPhraseCondition() {
        return this.phraseCondition;
    }

    @Override
    public boolean isMet(ToolOutput output) {
        return output != null && this.matches(output.getValue().getString());
    }

    public boolean matches(String text) {
        if (!this.conditionsParsed) {
            this.parseConditionStrings();
        }
        if (text == null) {
            return this.getAllWordsCondition() == null && this.getAnyWordsCondition() == null && this.getPhraseCondition() == null;
        }
        Pattern regexPattern = null;
        StringBuilder stringPattern = null;
        Matcher matcher = null;
        if (this.getExcludedWordsCondition() != null) {
            stringPattern = new StringBuilder();
            for (String excludedWord : this.getExcludedWordsCondition()) {
                stringPattern.append("(?:").append(NON_WORD_DELIMITER_REGEX).append(Pattern.quote(excludedWord)).append(NON_WORD_DELIMITER_REGEX).append(")|");
            }
            stringPattern.deleteCharAt(stringPattern.length() - 1);
            regexPattern = Pattern.compile(stringPattern.toString(), 74);
            matcher = regexPattern.matcher(text);
            if (matcher.find()) {
                return false;
            }
        }
        if (this.getAnyWordsCondition() != null) {
            stringPattern = new StringBuilder();
            for (String word : this.getAnyWordsCondition()) {
                stringPattern.append("(?:").append(NON_WORD_DELIMITER_REGEX).append(Pattern.quote(word)).append(NON_WORD_DELIMITER_REGEX).append(")|");
            }
            stringPattern.deleteCharAt(stringPattern.length() - 1);
            regexPattern = Pattern.compile(stringPattern.toString(), 74);
            matcher = regexPattern.matcher(text);
            if (!matcher.find()) {
                return false;
            }
        }
        if (this.getPhraseCondition() != null) {
            stringPattern = new StringBuilder(WHITESPACE_DELIMITER_REGEX);
            for (String word : this.getPhraseCondition()) {
                stringPattern.append(Pattern.quote(word)).append(WHITESPACE_DELIMITER_REGEX);
            }
            regexPattern = Pattern.compile(stringPattern.toString(), 74);
            matcher = regexPattern.matcher(text);
            if (!matcher.find()) {
                return false;
            }
        }
        if (this.getAllWordsCondition() != null) {
            for (String word : this.getAllWordsCondition()) {
                stringPattern = new StringBuilder(NON_WORD_DELIMITER_REGEX).append(Pattern.quote(word)).append(NON_WORD_DELIMITER_REGEX);
                regexPattern = Pattern.compile(stringPattern.toString(), 74);
                matcher = regexPattern.matcher(text);
                if (matcher.find()) continue;
                return false;
            }
        }
        return true;
    }

    public void parseConditionStrings() {
        this.parseConditionStrings(this.getAllWords(), this.getPhrase(), this.getAnyWords(), this.getExcludedWords());
    }

    public void parseConditionStrings(String allWordsString, String phraseString, String anyWordsString, String excludedWordsString) {
        this.conditionsParsed = true;
        this.setAllWordsCondition(this.splitSentence(allWordsString, NON_WORD_DELIMITER_REGEX));
        this.setPhraseCondition(this.splitSentence(phraseString, WHITESPACE_DELIMITER_REGEX));
        this.setAnyWordsCondition(this.splitSentence(anyWordsString, NON_WORD_DELIMITER_REGEX));
        this.setExcludedWordsCondition(this.splitSentence(excludedWordsString, NON_WORD_DELIMITER_REGEX));
    }

    public void parseConditionStrings(TextSearchActionForm textSearchActionForm) {
        this.parseConditionStrings(textSearchActionForm.getAllWords(), textSearchActionForm.getPhrase(), textSearchActionForm.getAnyWords(), textSearchActionForm.getExcludedWords());
    }

    public void setAllWords(String allWords) {
        this.allWords = allWords;
        this.conditionsParsed = false;
    }

    public void setAnyWords(String anyWords) {
        this.anyWords = anyWords;
        this.conditionsParsed = false;
    }

    public void setExcludedWords(String excludedWords) {
        this.excludedWords = excludedWords;
        this.conditionsParsed = false;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
        this.conditionsParsed = false;
    }

    public void setPhraseCondition(List<String> phraseCondition) {
        this.phraseCondition = phraseCondition;
    }

    @Override
    protected boolean isValid() {
        return true;
    }

    protected void setAllWordsCondition(List<String> allWordsCondition) {
        this.allWordsCondition = allWordsCondition;
    }

    protected void setAnyWordsCondition(List<String> anyWordsCondition) {
        this.anyWordsCondition = anyWordsCondition;
    }

    protected void setExcludedWordsCondition(List<String> excludedWordsCondition) {
        this.excludedWordsCondition = excludedWordsCondition;
    }

    private List<String> splitSentence(String sentence, String regex) {
        ArrayList<String> list = null;
        if (!StringUtils.isEmpty((String)sentence)) {
            String[] splitted = sentence.trim().split(regex);
            list = new ArrayList<String>(splitted.length);
            for (String word : splitted) {
                if (StringUtils.isEmpty((String)word)) continue;
                list.add(word);
            }
            if (list.isEmpty()) {
                list = null;
            }
        }
        return list;
    }

    @Override
    public TextSearchConditionDTO getBranchConditionDTO(Integer toolActivityUIID) {
        return new TextSearchConditionDTO(this, toolActivityUIID);
    }
}

