/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.gradebook.GradebookUserActivity;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.strategy.ToolActivityStrategy;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.usermanagement.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolActivity
extends SimpleActivity
implements Serializable {
    private static Logger log = Logger.getLogger(ToolActivity.class);
    private Long toolContentId;
    private Tool tool;
    private Set toolSessions;
    private Set<CompetenceMapping> competenceMappings;
    private Set<ActivityEvaluation> activityEvaluations;
    private Set<GradebookUserActivity> gradebookUserActivities;

    public ToolActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Tool tool, Long toolContentId, Set branchActivityEntries, Set<CompetenceMapping> competenceMappings, Set<ActivityEvaluation> activityEvaluations, Set<GradebookUserActivity> gradebookUserActivities) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, branchActivityEntries);
        this.tool = tool;
        this.toolContentId = toolContentId;
        this.competenceMappings = competenceMappings;
        this.activityEvaluations = activityEvaluations;
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
        this.gradebookUserActivities = gradebookUserActivities;
    }

    public ToolActivity() {
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
    }

    public ToolActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Tool tool, Long toolContentId) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.tool = tool;
        this.toolContentId = toolContentId;
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
    }

    @Override
    public Activity createCopy(int uiidOffset) {
        ToolActivity newToolActivity = new ToolActivity();
        this.copyToNewActivity(newToolActivity, uiidOffset);
        newToolActivity.setTool(this.getTool());
        newToolActivity.setToolContentId(this.getToolContentId());
        HashSet<CompetenceMapping> newCompetenceMappings = new HashSet<CompetenceMapping>();
        if (this.competenceMappings != null) {
            for (CompetenceMapping compMap : this.competenceMappings) {
                CompetenceMapping newComp = new CompetenceMapping();
                newComp.setCompetence(compMap.getCompetence());
                newComp.setToolActivity(compMap.getToolActivity());
                newCompetenceMappings.add(compMap);
            }
        }
        newToolActivity.setCompetenceMappings(newCompetenceMappings);
        HashSet<ActivityEvaluation> newEvaluations = new HashSet<ActivityEvaluation>();
        if (this.activityEvaluations != null) {
            for (ActivityEvaluation evaluation : this.activityEvaluations) {
                ActivityEvaluation newEvaluation = new ActivityEvaluation();
                newEvaluation.setActivity(newToolActivity);
                newEvaluation.setToolOutputDefinition(evaluation.getToolOutputDefinition());
                newEvaluations.add(newEvaluation);
            }
        }
        newToolActivity.setActivityEvaluations(newEvaluations);
        HashSet<GradebookUserActivity> newGradebookUserActivities = new HashSet<GradebookUserActivity>();
        if (this.gradebookUserActivities != null) {
            for (GradebookUserActivity gradebookAct : this.gradebookUserActivities) {
                GradebookUserActivity newGradebookAct = new GradebookUserActivity();
                newGradebookAct.setActivity(newToolActivity);
                newGradebookAct.setLearner(gradebookAct.getLearner());
                newGradebookAct.setMark(gradebookAct.getMark());
            }
        }
        newToolActivity.setGradebookUserActivities(newGradebookUserActivities);
        return newToolActivity;
    }

    public ToolSession createToolSessionForActivity(User learner, Lesson lesson) {
        Date now = new Date(System.currentTimeMillis());
        Integer supportType = this.getGroupingSupportType();
        ToolSession session = null;
        if (supportType != null && (supportType == 3 || supportType == 2)) {
            Group learners = null;
            if (this.getApplyGrouping().booleanValue()) {
                learners = this.getGroupFor(learner);
            }
            if (supportType == 3 && learners == null) {
                log.error((Object)("Activity " + this.getActivityId() + " requires grouping (groupingSupportType=GROUPING_SUPPORT_REQUIRED) but no grouping was available. " + " applyGrouping = " + this.getApplyGrouping() + " grouping = " + this.getGrouping() + ". Falling back to a class grouping."));
            }
            if (learners == null || learners.isNull()) {
                LessonClass lessonClass = lesson.getLessonClass();
                learners = this.getGroupFor(learner, lessonClass);
            }
            if (learners != null && !learners.isNull()) {
                session = new GroupedToolSession(this, now, 1, learners, lesson);
            } else {
                log.error((Object)("Unable to get the group for a new tool session for Activity " + this.getActivityId() + " Falling back to one learner per session." + " Learner " + learner + ", lesson is " + lesson));
            }
        }
        if (session == null) {
            session = new NonGroupedToolSession(this, now, 1, learner, lesson);
        }
        return session;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Set getToolSessions() {
        if (this.toolSessions == null) {
            this.setToolSessions(new TreeSet(new ActivityOrderComparator()));
        }
        return this.toolSessions;
    }

    public void setToolSessions(Set toolSessions) {
        this.toolSessions = toolSessions;
    }

    public Set<CompetenceMapping> getCompetenceMappings() {
        return this.competenceMappings;
    }

    public void setCompetenceMappings(Set<CompetenceMapping> competenceMappings) {
        this.competenceMappings = competenceMappings;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    protected void getToolActivitiesInActivity(SortedSet toolActivities) {
        toolActivities.add(this);
    }

    public Set<ActivityEvaluation> getActivityEvaluations() {
        return this.activityEvaluations;
    }

    public void setActivityEvaluations(Set<ActivityEvaluation> activityEvaluations) {
        this.activityEvaluations = activityEvaluations;
    }

    public Set<GradebookUserActivity> getGradebookUserActivities() {
        return this.gradebookUserActivities;
    }

    public void setGradebookUserActivities(Set<GradebookUserActivity> gradebookUserActivities) {
        this.gradebookUserActivities = gradebookUserActivities;
    }
}

