/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class ToolBranchingActivity
extends BranchingActivity
implements Serializable {
    private static final long serialVersionUID = 8343443197068061495L;

    public ToolBranchingActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Integer startXcoord, Integer startYcoord, Integer endXcoord, Integer endYcoord, Boolean stopAfterActivity, Set inputActivities, Set activities, Activity defaultActivity, SystemTool systemTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, startXcoord, startYcoord, endXcoord, endYcoord, stopAfterActivity, inputActivities, activities, defaultActivity, systemTool, branchActivityEntries);
    }

    public ToolBranchingActivity() {
    }

    public ToolBranchingActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Set activities) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, activities);
    }

    public Activity createCopy(int uiidOffset) {
        ToolBranchingActivity newBranchingActivity = new ToolBranchingActivity();
        this.copyBranchingFields(newBranchingActivity);
        this.copyToNewComplexActivity(newBranchingActivity, uiidOffset);
        newBranchingActivity.setGrouping(null);
        newBranchingActivity.setGroupingUIID(null);
        newBranchingActivity.setApplyGrouping(false);
        return newBranchingActivity;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.getDefaultActivity() == null) {
            listOfValidationErrors.add(new ValidationErrorDTO("BDB", messageService.getMessage("validation.error.toolBranchingMustHaveDefaultBranch"), this.getActivityUIID()));
        }
        if (this.getInputActivities() == null || this.getInputActivities().size() == 0) {
            listOfValidationErrors.add(new ValidationErrorDTO("BTI", messageService.getMessage("validation.error.toolBranchingMustHaveAnInputToolActivity"), this.getActivityUIID()));
        }
        if (this.getActivities() == null || this.getActivities().size() == 0) {
            listOfValidationErrors.add(new ValidationErrorDTO("BB", messageService.getMessage("validation.error.branching.must.have.a.branch"), this.getActivityUIID()));
        } else {
            boolean conditionsExist = false;
            for (SequenceActivity branch : this.getActivities()) {
                if (branch.getBranchEntries() == null) continue;
                for (BranchActivityEntry entry : branch.getBranchEntries()) {
                    BranchCondition condition = entry.getCondition();
                    if (condition == null) {
                        listOfValidationErrors.add(new ValidationErrorDTO("BCOND", messageService.getMessage("validation.error.toolBranchingConditionInvalid"), this.getActivityUIID()));
                        continue;
                    }
                    conditionsExist = true;
                    if (condition.isValid()) continue;
                    listOfValidationErrors.add(new ValidationErrorDTO("BCOND", messageService.getMessage("validation.error.toolBranchingConditionInvalid"), this.getActivityUIID()));
                }
            }
            if (!conditionsExist) {
                listOfValidationErrors.add(new ValidationErrorDTO("BTC", messageService.getMessage("validation.error.toolBranchingMustHaveACondition"), this.getActivityUIID()));
            }
        }
        return listOfValidationErrors;
    }
}

