/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dao.hibernate;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedagogicalPlannerDAOHibernate
extends HibernateDaoSupport
implements PedagogicalPlannerDAO {
    private static final String FIND_ROOT_NODE = "FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.parent=NULL";
    private static final String FIND_PARENT_TITLE = "SELECT n.parent.uid, n.title FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.uid=?";
    private static final String FIND_MAX_ORDER_ID = "SELECT MAX(n.order) FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.parent.uid=?";
    private static final String FIND_NEIGHBOUR_NODE = "FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE ((? IS NULL AND n.parent=NULL) OR  n.parent.uid=?) AND n.order=?";

    @Override
    public PedagogicalPlannerSequenceNode getByUid(Long uid) {
        return (PedagogicalPlannerSequenceNode)this.getHibernateTemplate().get(PedagogicalPlannerSequenceNode.class, (Serializable)uid);
    }

    @Override
    public PedagogicalPlannerSequenceNode getRootNode() {
        List subnodeList = this.getHibernateTemplate().find(FIND_ROOT_NODE);
        PedagogicalPlannerSequenceNode rootNode = new PedagogicalPlannerSequenceNode();
        rootNode.setLocked(true);
        LinkedHashSet<PedagogicalPlannerSequenceNode> subnodeSet = new LinkedHashSet<PedagogicalPlannerSequenceNode>(subnodeList);
        rootNode.setSubnodes(subnodeSet);
        return rootNode;
    }

    @Override
    public List<String[]> getTitlePath(Long nodeUid) {
        Long currentUid = nodeUid;
        LinkedList<String[]> titlePath = new LinkedList<String[]>();
        while (currentUid != null) {
            List result = this.getHibernateTemplate().find(FIND_PARENT_TITLE, (Object)currentUid);
            if (result.size() > 0) {
                Object[] row = (Object[])result.get(0);
                if (!currentUid.equals(nodeUid)) {
                    String title = (String)row[1];
                    titlePath.addFirst(new String[]{currentUid.toString(), title});
                }
                currentUid = (Long)row[0];
                continue;
            }
            return null;
        }
        return titlePath;
    }

    @Override
    public void removeNode(PedagogicalPlannerSequenceNode node) {
        this.getHibernateTemplate().delete((Object)node);
        this.getHibernateTemplate().flush();
    }

    @Override
    public void saveOrUpdateNode(PedagogicalPlannerSequenceNode node) {
        this.getHibernateTemplate().saveOrUpdate((Object)node);
        this.getHibernateTemplate().flush();
    }

    @Override
    public Integer getNextOrderId(Long parentUid) {
        Integer maxOrderId = (Integer)this.getHibernateTemplate().find(FIND_MAX_ORDER_ID, (Object)parentUid).get(0);
        if (maxOrderId == null) {
            maxOrderId = 0;
        }
        return maxOrderId + 1;
    }

    @Override
    public PedagogicalPlannerSequenceNode getNeighbourNode(PedagogicalPlannerSequenceNode node, Integer orderDelta) {
        Integer order = node.getOrder() + orderDelta;
        Long parentUid = node.getParent() == null ? null : node.getParent().getUid();
        return (PedagogicalPlannerSequenceNode)this.getHibernateTemplate().find(FIND_NEIGHBOUR_NODE, new Object[]{parentUid, parentUid, order}).get(0);
    }
}

