/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedagogicalPlannerSequenceNodeDTO {
    private Long uid;
    private List<String[]> titlePath;
    private String title;
    private String briefDescription;
    private String fullDescription;
    private String fileName;
    private Boolean locked;
    private List<PedagogicalPlannerSequenceNodeDTO> subnodes;
    private Long parentUid;
    private Boolean edit = false;
    private Boolean createSubnode = false;
    private Boolean isSysAdmin = true;
    private Boolean importNode = false;
    private static final String FULL_DESCRIPTION_NOT_EMPTY = "FULL";

    public PedagogicalPlannerSequenceNodeDTO() {
    }

    public PedagogicalPlannerSequenceNodeDTO(PedagogicalPlannerSequenceNode node, Set<PedagogicalPlannerSequenceNode> subnodes) {
        this.uid = node.getUid();
        this.title = node.getTitle();
        this.briefDescription = node.getBriefDescription();
        this.fullDescription = node.getFullDescription();
        this.fileName = node.getFileName();
        this.locked = node.getLocked();
        if (node.getParent() != null) {
            this.parentUid = node.getParent().getUid();
        }
        this.subnodes = new LinkedList<PedagogicalPlannerSequenceNodeDTO>();
        if (subnodes != null) {
            for (PedagogicalPlannerSequenceNode subnode : subnodes) {
                PedagogicalPlannerSequenceNodeDTO subnodeDTO = new PedagogicalPlannerSequenceNodeDTO();
                subnodeDTO.setTitle(subnode.getTitle());
                subnodeDTO.setBriefDescription(subnode.getBriefDescription());
                if (!StringUtils.isEmpty((String)subnode.getFullDescription())) {
                    subnodeDTO.setFullDescription(FULL_DESCRIPTION_NOT_EMPTY);
                }
                subnodeDTO.setLocked(subnode.getLocked());
                subnodeDTO.setFileName(subnode.getFileName());
                subnodeDTO.setUid(subnode.getUid());
                this.subnodes.add(subnodeDTO);
            }
        }
    }

    public List<String[]> getTitlePath() {
        return this.titlePath;
    }

    public void setTitlePath(List<String[]> titlePath) {
        this.titlePath = titlePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getFullDescription() {
        return this.fullDescription;
    }

    public void setFullDescription(String fullDescription) {
        this.fullDescription = fullDescription;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<PedagogicalPlannerSequenceNodeDTO> getSubnodes() {
        return this.subnodes;
    }

    public void setSubnodes(List<PedagogicalPlannerSequenceNodeDTO> subnodes) {
        this.subnodes = subnodes;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Long getParentUid() {
        return this.parentUid;
    }

    public void setParentUid(Long parentUid) {
        this.parentUid = parentUid;
    }

    public Boolean getEdit() {
        return this.edit;
    }

    public void setEdit(Boolean edit) {
        this.edit = edit;
    }

    public Boolean getCreateSubnode() {
        return this.createSubnode;
    }

    public void setCreateSubnode(Boolean createSubnode) {
        this.createSubnode = createSubnode;
    }

    public Boolean getIsSysAdmin() {
        return this.isSysAdmin;
    }

    public void setIsSysAdmin(Boolean isSysAdmin) {
        this.isSysAdmin = isSysAdmin;
    }

    public Boolean getImportNode() {
        return this.importNode;
    }

    public void setImportNode(Boolean importNode) {
        this.importNode = importNode;
    }
}

