/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.presence.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.presence.dao.IPresenceChatMessageDAO;
import org.lamsfoundation.lams.presence.model.PresenceChatMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceChatMessageDAO
extends BaseDAO
implements IPresenceChatMessageDAO {
    private static final String BY_MESSAGE_ID = "from " + PresenceChatMessage.class.getName() + " msg" + " where msg.uid=? order by msg.dateSent desc";
    private static final String BY_CONVERSATION = "from " + PresenceChatMessage.class.getName() + " msg" + " where (msg.from=:from and msg.to=:to) or (msg.from=:to and msg.to=:from) and msg.roomName=:roomName order by msg.dateSent asc";
    private static final String BY_ROOM_NAME = "from " + PresenceChatMessage.class.getName() + " msg" + " where msg.roomName=? and msg.to is null order by msg.dateSent asc";

    @Override
    public void saveOrUpdate(PresenceChatMessage presenceChatMessage) {
        this.getHibernateTemplate().saveOrUpdate((Object)presenceChatMessage);
        this.getHibernateTemplate().flush();
    }

    @Override
    public PresenceChatMessage getMessageById(Long id) {
        List list = this.getHibernateTemplate().find(BY_CONVERSATION, new Object[]{id});
        if (!list.isEmpty()) {
            return (PresenceChatMessage)list.get(0);
        }
        return null;
    }

    @Override
    public List<PresenceChatMessage> getMessagesByConversation(String from, String to, String roomName) {
        return this.getHibernateTemplate().findByNamedParam(BY_CONVERSATION, new String[]{"from", "to", "roomName"}, new Object[]{from, to, roomName});
    }

    @Override
    public List<PresenceChatMessage> getMessagesByRoomName(String roomName) {
        return this.getHibernateTemplate().find(BY_ROOM_NAME, new Object[]{roomName});
    }
}

