/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.config.ConfigurationItem;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.config.dao.hibernate.ConfigurationDAO;
import org.lamsfoundation.lams.config.dao.hibernate.RegistrationDAO;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.springframework.beans.factory.InitializingBean;

public class Configuration
implements InitializingBean {
    protected Logger log = Logger.getLogger(Configuration.class);
    public static String CONFIGURATION_HELP_PAGE = "LAMS+Configuration";
    private static Map items = null;
    protected ConfigurationDAO configurationDAO;
    protected static RegistrationDAO registrationDAO;

    public void setConfigurationDAO(ConfigurationDAO configurationDAO) {
        this.configurationDAO = configurationDAO;
    }

    public void afterPropertiesSet() {
        if (items != null) {
            return;
        }
        Map<String, ConfigurationItem> itemsmap = Collections.synchronizedMap(new LinkedHashMap());
        try {
            List mapitems = this.getAllItems();
            if (mapitems.size() > 0) {
                for (ConfigurationItem item : mapitems) {
                    if (StringUtils.equals((String)item.getKey(), (String)ConfigurationKeys.TRUSTSTORE_PATH)) {
                        this.setSystemProperty(item.getKey(), item.getValue());
                    } else if (StringUtils.equals((String)item.getKey(), (String)ConfigurationKeys.TRUSTSTORE_PASSWORD)) {
                        this.setSystemProperty(item.getKey(), item.getValue());
                    }
                    itemsmap.put(item.getKey(), item);
                }
            }
            items = itemsmap;
        }
        catch (Exception e) {
            this.log.error((Object)"Exception has occurred: ", (Throwable)e);
        }
    }

    public List getAllItems() {
        return this.configurationDAO.getAllItems();
    }

    public static Map getAll() {
        return items;
    }

    public ConfigurationItem getConfigItemByKey(String key) {
        if (items != null && items.get(key) != null && items.get(key) != null) {
            return (ConfigurationItem)items.get(key);
        }
        return null;
    }

    public static String getItemValue(Object obj) {
        ConfigurationItem item = (ConfigurationItem)obj;
        if (item.getValue() != null) {
            return item.getValue();
        }
        return null;
    }

    public static void setItemValue(Object obj, String value) {
        ConfigurationItem item = (ConfigurationItem)obj;
        item.setValue(value);
    }

    public static String get(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return Configuration.getItemValue(items.get(key));
        }
        return null;
    }

    public static int getAsInt(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Integer(Configuration.getItemValue(items.get(key)));
        }
        return -1;
    }

    public static boolean getAsBoolean(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Boolean(Configuration.getItemValue(items.get(key)));
        }
        return false;
    }

    public static void updateItem(String key, String value) {
        if (items.containsKey(key)) {
            Configuration.setItemValue(items.get(key), value);
        }
    }

    public void persistUpdate() {
        this.setSystemProperty(ConfigurationKeys.TRUSTSTORE_PATH, Configuration.get(ConfigurationKeys.TRUSTSTORE_PATH));
        this.setSystemProperty(ConfigurationKeys.TRUSTSTORE_PASSWORD, Configuration.get(ConfigurationKeys.TRUSTSTORE_PASSWORD));
        this.configurationDAO.insertOrUpdateAll(items.values());
    }

    public String toString() {
        return "Configuration items:" + (items != null ? items.toString() : "none");
    }

    private void setSystemProperty(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public static void saveOrUpdateRegistration(Registration reg) {
        registrationDAO.saveOrUpdate(reg);
    }

    public static Registration getRegistration() {
        return registrationDAO.get();
    }

    public RegistrationDAO getRegistrationDAO() {
        return registrationDAO;
    }

    public void setRegistrationDAO(RegistrationDAO registrationDAO) {
        Configuration.registrationDAO = registrationDAO;
    }
}

