/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.springframework.stereotype.Repository;

@Repository
public class GroupDAO
extends LAMSBaseDAO
implements IGroupDAO {
    private static final String NUM_GROUPS = "select count(*) from " + Group.class.getName() + " g join g.users u" + " where u.userId = :userID";

    @Override
    public Group getGroupById(Long groupID) {
        return (Group)super.find(Group.class, groupID);
    }

    @Override
    public void saveGroup(Group group) {
        this.getSession().save((Object)group);
    }

    @Override
    public void deleteGroup(Group group) {
        this.getSession().delete((Object)group);
    }

    @Override
    public Integer getCountGroupsForUser(Integer userID) {
        Query query = this.getSession().createQuery(NUM_GROUPS);
        query.setInteger("userID", userID.intValue());
        Object value = query.uniqueResult();
        return new Integer(((Number)value).intValue());
    }
}

