/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.springframework.stereotype.Repository;

@Repository
public class TransitionDAO
extends LAMSBaseDAO
implements ITransitionDAO {
    private static final String TABLENAME = "lams_learning_transition";
    private static final String FIND_BY_TO_ACTIVITY = "from lams_learning_transition in class " + Transition.class.getName() + " where to_activity_id =?";
    private static final String FIND_BY_FROM_ACTIVITY = "from lams_learning_transition in class " + Transition.class.getName() + " where from_activity_id =?";
    private static final String FIND_BY_LEARNING_DESIGN_ID = "from lams_learning_transition in class " + Transition.class.getName() + " where learning_design_id=?";
    private static final String FIND_BY_UI_ID = "from lams_learning_transition in class " + Transition.class.getName() + " where transition_ui_id=?" + " AND " + " learning_design_id=?";

    @Override
    public Transition getTransitionByTransitionID(Long transitionID) {
        return (Transition)this.getSession().get(Transition.class, (Serializable)transitionID);
    }

    @Override
    public Transition getTransitionByToActivityID(Long toActivityID) {
        if (toActivityID != null) {
            Query query = this.getSessionFactory().getCurrentSession().createQuery(FIND_BY_TO_ACTIVITY);
            query.setLong(0, toActivityID.longValue());
            return (Transition)query.uniqueResult();
        }
        return null;
    }

    @Override
    public Transition getTransitionByfromActivityID(Long fromActivityID) {
        if (fromActivityID != null) {
            return (Transition)this.getSessionFactory().getCurrentSession().createQuery(FIND_BY_FROM_ACTIVITY).setLong(0, fromActivityID.longValue()).uniqueResult();
        }
        return null;
    }

    @Override
    public List getTransitionsByLearningDesignID(Long learningDesignID) {
        if (learningDesignID != null) {
            return this.getSessionFactory().getCurrentSession().createQuery(FIND_BY_LEARNING_DESIGN_ID).setLong(0, learningDesignID.longValue()).list();
        }
        return null;
    }

    @Override
    public Activity getNextActivity(Long fromActivityID) {
        Transition transition = this.getTransitionByfromActivityID(fromActivityID);
        if (transition != null) {
            return transition.getToActivity();
        }
        return null;
    }

    @Override
    public Transition getTransitionByUUID(Integer transitionUUID, LearningDesign learningDesign) {
        if (transitionUUID != null && learningDesign != null) {
            Long designID = learningDesign.getLearningDesignId();
            Query query = this.getSessionFactory().getCurrentSession().createQuery(FIND_BY_UI_ID);
            query.setInteger(0, transitionUUID.intValue());
            query.setLong(1, designID.longValue());
            return (Transition)query.uniqueResult();
        }
        return null;
    }
}

