/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.stereotype.Repository;

@Repository
public class LessonDAO
extends LAMSBaseDAO
implements ILessonDAO {
    private static final String FIND_LESSON_BY_CREATOR = "from " + Lesson.class.getName() + " lesson where lesson.user.userId=? and lesson.lessonStateId <= 6 and " + " lesson.learningDesign.copyTypeID=" + 2;
    private static final String FIND_PREVIEW_BEFORE_START_DATE = "from " + Lesson.class.getName() + " lesson where lesson.learningDesign.copyTypeID=" + 3 + "and lesson.startDateTime is not null and lesson.startDateTime < ?";
    private static final String COUNT_ACTIVE_LEARNERS = "select count(distinct progress.user.id) from " + LearnerProgress.class.getName() + " progress" + " where progress.lesson.id = :lessonId";
    private static final String LOAD_ACTIVE_LEARNERS = "select distinct progress.user from " + LearnerProgress.class.getName() + " progress where progress.lesson.id = :lessonId";
    private static final String FIND_LESSON_FOR_ACTIVITY = "select lesson from " + Lesson.class.getName() + " lesson, " + Activity.class.getName() + " activity " + " where activity.activityId=:activityId and activity.learningDesign=lesson.learningDesign";
    private static final String LESSONS_WITH_ORIGINAL_LEARNING_DESIGN = "select l from " + Lesson.class.getName() + " l " + "where l.learningDesign.originalLearningDesign.learningDesignId = ? " + "and l.learningDesign.copyTypeID != " + 3 + " " + "and l.lessonStateId = " + Lesson.STARTED_STATE + " " + "and l.organisation.organisationId = ? " + " order by l.lessonName";
    private static final String LESSONS_BY_GROUP = "from " + Lesson.class.getName() + " where organisation.organisationId=? and lessonStateId <= 6";
    private static final String LOAD_LEARNERS_BY_LESSON = "FROM Lesson AS lesson INNER JOIN lesson.lessonClass AS lessonClass INNER JOIN lessonClass.groups AS groups INNER JOIN groups.users AS users WHERE lesson.id = :lessonId AND lessonClass.staffGroup != groups";
    private static final String LOAD_USERS_WITH_LESSON_PARTICIPATION = "SELECT users.*, ug.user_id IS NOT NULL AS participant FROM lams_lesson AS l JOIN lams_user_organisation AS uo ON l.lesson_id = :lessonId AND l.organisation_id = uo.organisation_id JOIN lams_user_organisation_role AS r ON r.role_id = :roleId AND r.user_organisation_id = uo.user_organisation_id JOIN lams_user AS users ON uo.user_id = users.user_id JOIN lams_grouping AS ging ON l.class_grouping_id = ging.grouping_id JOIN lams_group AS g ON g.group_id <IS_STAFF> ging.staff_group_id AND g.grouping_id = ging.grouping_id LEFT JOIN lams_user_group AS ug ON ug.group_id = g.group_id AND users.user_id = ug.user_id";

    @Override
    public Lesson getLesson(Long lessonId) {
        Lesson lesson = (Lesson)this.getSession().get(Lesson.class, (Serializable)lessonId);
        return lesson;
    }

    @Override
    public Lesson getLessonWithJoinFetchedProgress(Long lessonId) {
        return (Lesson)this.getSession().createCriteria(Lesson.class).add((Criterion)Restrictions.like((String)"lessonId", (Object)lessonId)).setFetchMode("learnerProgresses", FetchMode.JOIN).uniqueResult();
    }

    @Override
    public List getActiveLessonsForLearner(User learner) {
        Query query = this.getSession().getNamedQuery("activeLessonsAllOrganisations");
        query.setInteger("userId", learner.getUserId().intValue());
        List result = query.list();
        return result;
    }

    @Override
    public List<User> getActiveLearnerByLesson(long lessonId) {
        return this.getSession().createQuery(LOAD_ACTIVE_LEARNERS).setLong("lessonId", lessonId).list();
    }

    @Override
    public Integer getCountActiveLearnerByLesson(long lessonId) {
        Query query = this.getSession().createQuery(COUNT_ACTIVE_LEARNERS);
        query.setLong("lessonId", lessonId);
        Object value = query.uniqueResult();
        return new Integer(((Number)value).intValue());
    }

    @Override
    public List<User> getLearnersByLesson(Long lessonId, String searchPhrase, Integer limit, Integer offset, boolean orderAscending) {
        StringBuilder queryTextBuilder = new StringBuilder("SELECT users ").append(LOAD_LEARNERS_BY_LESSON);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryTextBuilder.append(" AND (users.firstName LIKE '%").append(token).append("%' OR users.lastName LIKE '%").append(token).append("%' OR users.login LIKE '%").append(token).append("%')");
            }
        }
        String order = orderAscending ? "ASC" : "DESC";
        queryTextBuilder.append(" ORDER BY users.firstName ").append(order).append(", users.lastName ").append(order).append(", users.login ").append(order);
        Query query = this.getSession().createQuery(queryTextBuilder.toString()).setLong("lessonId", lessonId.longValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        return query.list();
    }

    @Override
    public Integer getCountLearnersByLesson(long lessonId, String searchPhrase) {
        StringBuilder queryTextBuilder = new StringBuilder("SELECT COUNT(*) ").append(LOAD_LEARNERS_BY_LESSON);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryTextBuilder.append(" AND (users.firstName LIKE '%").append(token).append("%' OR users.lastName LIKE '%").append(token).append("%' OR users.login LIKE '%").append(token).append("%')");
            }
        }
        Query query = this.getSession().createQuery(queryTextBuilder.toString()).setLong("lessonId", lessonId);
        Object value = query.uniqueResult();
        return ((Number)value).intValue();
    }

    @Override
    public void saveLesson(Lesson lesson) {
        this.getSession().save((Object)lesson);
    }

    @Override
    public void deleteLesson(Lesson lesson) {
        this.getSession().delete((Object)lesson);
    }

    @Override
    public void updateLesson(Lesson lesson) {
        this.getSession().update((Object)lesson);
    }

    @Override
    public List getLessonsCreatedByUser(Integer userID) {
        List<?> lessons = this.doFind(FIND_LESSON_BY_CREATOR, userID);
        return lessons;
    }

    @Override
    public List getPreviewLessonsBeforeDate(Date startDate) {
        List<?> lessons = this.doFind(FIND_PREVIEW_BEFORE_START_DATE, startDate);
        return lessons;
    }

    @Override
    public Lesson getLessonForActivity(long activityId) {
        Query query = this.getSession().createQuery(FIND_LESSON_FOR_ACTIVITY);
        query.setLong("activityId", activityId);
        return (Lesson)query.uniqueResult();
    }

    @Override
    public List getLessonsByOrgAndUserWithCompletedFlag(Integer userId, Integer orgId, Integer userRole) {
        String queryName = Role.ROLE_MONITOR.equals(userRole) ? "staffLessonsByOrgAndUserWithCompletedFlag" : (Role.ROLE_LEARNER.equals(userRole) ? "learnerLessonsByOrgAndUserWithCompletedFlag" : "allLessonsByOrgAndUserWithCompletedFlag");
        Query query = this.getSession().getNamedQuery(queryName);
        query.setInteger("userId", userId.intValue());
        query.setInteger("orgId", orgId.intValue());
        List result = query.list();
        return result;
    }

    @Override
    public List getLessonsByGroupAndUser(Integer userId, Integer orgId) {
        Query query = this.getSession().getNamedQuery("lessonsByOrgAndUserWithChildOrgs");
        query.setInteger("userId", userId.intValue());
        query.setInteger("orgId", orgId.intValue());
        List result = query.list();
        return result;
    }

    @Override
    public List getLessonsByGroup(Integer orgId) {
        return this.doFind(LESSONS_BY_GROUP, orgId);
    }

    @Override
    public List getLessonsByOriginalLearningDesign(Long ldId, Integer orgId) {
        Object[] args = new Object[]{(long)ldId, (int)orgId};
        List<?> lessons = this.doFind(LESSONS_WITH_ORIGINAL_LEARNING_DESIGN, args);
        return lessons;
    }

    @Override
    public List<User> getMonitorsByToolSessionId(Long sessionId) {
        return this.doFindByNamedQueryAndNamedParam("monitorsByToolSessionId", "sessionId", sessionId);
    }

    @Override
    public Map<User, Boolean> getUsersWithLessonParticipation(Long lessonId, String role, String searchPhrase, Integer limit, Integer offset, boolean orderAscending) {
        String queryTextBase = LOAD_USERS_WITH_LESSON_PARTICIPATION;
        queryTextBase = queryTextBase.replace("<IS_STAFF>", role.equals("MONITOR") ? "=" : "<>");
        StringBuilder queryTextBuilder = new StringBuilder(queryTextBase);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            queryTextBuilder.append(" WHERE");
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryTextBuilder.append(" (users.first_name LIKE '%").append(token).append("%' OR users.last_name LIKE '%").append(token).append("%' OR users.login LIKE '%").append(token).append("%') AND");
            }
            queryTextBuilder.delete(queryTextBuilder.length() - 4, queryTextBuilder.length());
        }
        String order = orderAscending ? "ASC" : "DESC";
        queryTextBuilder.append(" ORDER BY users.first_name ").append(order).append(", users.last_name ").append(order).append(", users.login ").append(order);
        Query query = this.getSession().createSQLQuery(queryTextBuilder.toString()).addEntity(User.class).addScalar("participant").setLong("lessonId", lessonId.longValue()).setInteger("roleId", (role.equals("MONITOR") ? Role.ROLE_MONITOR : Role.ROLE_LEARNER).intValue());
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        List resultQuery = query.list();
        LinkedHashMap<User, Boolean> result = new LinkedHashMap<User, Boolean>();
        for (Object[] entry : resultQuery) {
            result.put((User)entry[0], ((Integer)entry[1]).equals(1));
        }
        return result;
    }
}

