/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.notebook.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.notebook.dao.INotebookEntryDAO;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.springframework.stereotype.Repository;

@Repository
public class NotebookEntryDAO
extends LAMSBaseDAO
implements INotebookEntryDAO {
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and external_signature=? and user_id=?" + " order by create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG_ALL = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and external_signature=?" + " order by user_id asc, create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and user_id=?" + " order by create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_USER_ID = "from " + NotebookEntry.class.getName() + " where user_id=?";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_TYPE = "from " + NotebookEntry.class.getName() + " where user_id=? and external_id_type=?" + " order by external_signature desc, create_date desc";

    @Override
    public void saveOrUpdate(NotebookEntry notebookEntry) {
        this.insertOrUpdate(notebookEntry);
        this.getSession().flush();
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, String signature, Integer userID) {
        return this.doFind(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG, id, idType, signature, userID);
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, String signature) {
        return this.doFind(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG_ALL, id, idType, signature);
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, Integer userID) {
        return this.doFind(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID, id, idType, userID);
    }

    @Override
    public NotebookEntry get(Long uid) {
        if (uid != null) {
            Object o = this.getSession().get(NotebookEntry.class, (Serializable)uid);
            return (NotebookEntry)o;
        }
        return null;
    }

    @Override
    public List<NotebookEntry> get(Integer userID) {
        return this.doFind(SQL_QUERY_FIND_ENTRY_BY_USER_ID, userID);
    }

    @Override
    public List<NotebookEntry> get(Integer userID, Integer idType) {
        return this.doFind(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_TYPE, userID, idType);
    }

    @Override
    public List<NotebookEntry> get(Integer userID, Long lessonID) {
        return null;
    }

    @Override
    public void delete(NotebookEntry notebookEntry) {
        this.getSession().delete((Object)notebookEntry);
    }
}

