/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.notebook.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.notebook.dao.INotebookEntryDAO;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;

public class CoreNotebookService
implements ICoreNotebookService {
    private static Logger log = Logger.getLogger(CoreNotebookService.class);
    private INotebookEntryDAO notebookEntryDAO;
    private IBaseDAO baseDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String title, String entry) {
        User user = (User)this.getUserManagementService().findById(User.class, userID);
        NotebookEntry notebookEntry = new NotebookEntry(id, idType, signature, user, title, entry, new Date());
        this.saveOrUpdateNotebookEntry(notebookEntry);
        return notebookEntry.getUid();
    }

    @Override
    public TreeMap<Long, List<NotebookEntry>> getEntryByLesson(Integer userID, Integer idType) {
        TreeMap<Long, List<NotebookEntry>> entryMap = new TreeMap<Long, List<NotebookEntry>>();
        List<NotebookEntry> list = this.getEntry(userID, idType);
        for (NotebookEntry entry : list) {
            if (entryMap.containsKey(entry.getExternalID())) {
                String lessonName = entryMap.get(entry.getExternalID()).get(0).getLessonName();
                entry.setLessonName(lessonName);
                entryMap.get(entry.getExternalID()).add(entry);
                continue;
            }
            Lesson lesson = (Lesson)this.baseDAO.find(Lesson.class, entry.getExternalID());
            ArrayList<NotebookEntry> newEntryList = new ArrayList<NotebookEntry>();
            entry.setLessonName(lesson.getLessonName());
            newEntryList.add(entry);
            entryMap.put(entry.getExternalID(), newEntryList);
        }
        return entryMap;
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, String signature, Integer userID) {
        return this.notebookEntryDAO.get(id, idType, signature, userID);
    }

    @Override
    public String[] getNotebookEntrySQLStrings(String sessionIdString, String toolSignature, String userIdString, boolean includeDates) {
        StringBuilder buf = new StringBuilder(" LEFT JOIN lams_notebook_entry entry ON entry.external_id=");
        buf.append(sessionIdString);
        buf.append(" AND entry.external_id_type=");
        buf.append(CoreNotebookConstants.NOTEBOOK_TOOL);
        buf.append(" AND entry.external_signature=\"");
        buf.append(toolSignature);
        buf.append("\" AND entry.user_id=");
        buf.append(userIdString);
        String[] retValue = new String[]{includeDates ? ", entry.entry notebookEntry, (CASE WHEN entry.last_modified IS NULL THEN entry.create_date ELSE entry.last_modified END) notebookModifiedDate " : ", entry.entry notebookEntry ", buf.toString()};
        return retValue;
    }

    @Override
    public String[] getNotebookEntrySQLStrings(String sessionIdString, String toolSignature, String userIdString) {
        return this.getNotebookEntrySQLStrings(sessionIdString, toolSignature, userIdString, false);
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, String signature) {
        return this.notebookEntryDAO.get(id, idType, signature);
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, Integer userID) {
        return this.notebookEntryDAO.get(id, idType, userID);
    }

    @Override
    public List<NotebookEntry> getEntry(Integer userID, Integer idType) {
        return this.notebookEntryDAO.get(userID, idType);
    }

    @Override
    public NotebookEntry getEntry(Long uid) {
        return this.notebookEntryDAO.get(uid);
    }

    @Override
    public void updateEntry(Long uid, String title, String entry) {
        NotebookEntry ne = this.getEntry(uid);
        if (ne != null) {
            ne.setTitle(title);
            ne.setEntry(entry);
            ne.setLastModified(new Date());
            this.saveOrUpdateNotebookEntry(ne);
        } else {
            log.debug((Object)("updateEntry: uid " + uid + "does not exist"));
        }
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        notebookEntry.setLastModified(new Date());
        this.saveOrUpdateNotebookEntry(notebookEntry);
    }

    @Override
    public void saveOrUpdateNotebookEntry(NotebookEntry notebookEntry) {
        this.notebookEntryDAO.saveOrUpdate(notebookEntry);
    }

    @Override
    public void deleteEntry(NotebookEntry notebookEntry) {
        this.notebookEntryDAO.delete(notebookEntry);
    }

    public void setNotebookEntryDAO(INotebookEntryDAO notebookEntryDAO) {
        this.notebookEntryDAO = notebookEntryDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    @Override
    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }
}

