/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.questions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.questions.Answer;
import org.lamsfoundation.lams.questions.Question;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QuestionExporter {
    private static final Logger log = Logger.getLogger(QuestionExporter.class);
    private static final Pattern IMAGE_PATTERN = Pattern.compile("<img.*?src=['\"]/+lams/+www/+([\\w\\.\\/]+).+?>", 10);
    private static final String IMAGE_MARKER = "[matimage]";
    private static final String EXPORT_TEMP_FOLDER_SUFFIX = "qti";
    private static final String EAR_IMAGE_FOLDER = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war";
    private static final File MANIFEST_TEMPLATE_FILE = new File(Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-central.war" + File.separator + "questions" + File.separator + "imsmanifest_template.xml");
    private String packageTitle = null;
    private Question[] questions = null;
    private Document doc = null;
    private Integer itemId = null;
    private Map<String, File> images = new TreeMap<String, File>();

    public QuestionExporter(String title, Question[] questions) {
        this.packageTitle = StringUtils.isBlank((String)title) ? "export" : FileUtil.stripInvalidChars(title).replaceAll(" ", "_");
        this.questions = questions;
    }

    public void exportQTIPackage(HttpServletRequest request, HttpServletResponse response) {
        String packagePath = this.exportQTIPackage();
        File packageFile = new File(packagePath);
        try {
            String fileName = FileUtil.getFileName(packagePath);
            fileName = FileUtil.encodeFilenameForDownload(request, fileName);
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            FileUtils.copyFile((File)packageFile, (OutputStream)response.getOutputStream());
            FileUtils.deleteDirectory((File)packageFile.getParentFile());
        }
        catch (IOException e) {
            log.error((Object)"Error while exporti QTI package", (Throwable)e);
        }
    }

    public String exportQTIPackage() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting QTI ZIP package \"" + this.packageTitle + "\""));
        }
        try {
            String rootDir = FileUtil.createTempDirectory(EXPORT_TEMP_FOLDER_SUFFIX);
            File dir = new File(rootDir, "content");
            String xmlFileName = this.packageTitle + ".xml";
            File xmlFile = new File(dir, xmlFileName);
            String xmlFileContent = this.exportQTIFile();
            FileUtils.writeStringToFile((File)xmlFile, (String)xmlFileContent, (String)"UTF-8");
            File manifestFile = new File(dir, "imsmanifest.xml");
            String manifestContent = this.createManifest();
            FileUtils.writeStringToFile((File)manifestFile, (String)manifestContent, (String)"UTF-8");
            for (String imageName : this.images.keySet()) {
                File imageFile = new File(dir, imageName);
                FileUtils.copyFile((File)this.images.get(imageName), (File)imageFile);
            }
            String targetZipFileName = "lams_qti_" + this.packageTitle + ".zip";
            String zipPath = ZipFileUtil.createZipFile(targetZipFileName, dir.getAbsolutePath(), rootDir);
            FileUtils.deleteDirectory((File)dir);
            return zipPath;
        }
        catch (Exception e) {
            log.error((Object)"Error while exporti QTI package", (Throwable)e);
            return null;
        }
    }

    public String exportQTIFile() {
        this.itemId = 1000;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while instantinating Document Builder", (Throwable)e);
            return null;
        }
        Element rootElem = (Element)this.doc.appendChild(this.doc.createElement("questestinterop"));
        Element assessmentElem = (Element)rootElem.appendChild(this.doc.createElement("assessment"));
        assessmentElem.setAttribute("title", this.packageTitle);
        assessmentElem.setAttribute("ident", "A1001");
        Element sectionElem = (Element)assessmentElem.appendChild(this.doc.createElement("section"));
        sectionElem.setAttribute("title", "Main");
        sectionElem.setAttribute("ident", "S1002");
        for (Question question : this.questions) {
            Element itemElem = null;
            if ("mc".equals(question.getType()) || "tf".equals(question.getType()) || "mr".equals(question.getType())) {
                itemElem = this.exportMultipleChoiceQuestion(question);
            } else if ("fb".equals(question.getType())) {
                itemElem = this.exportFillInBlankQuestion(question);
            } else if ("mt".equals(question.getType())) {
                itemElem = this.exportMatchingPairsQuestion(question);
            } else if ("es".equals(question.getType())) {
                itemElem = this.exportEssayQuestion(question);
            }
            if (itemElem == null) {
                log.warn((Object)("Unknow type \"" + question.getType() + "\" of question \"" + question.getTitle() + "\""));
                continue;
            }
            sectionElem.appendChild(itemElem);
        }
        return FileUtil.writeXMLtoString(this.doc);
    }

    private Element exportMultipleChoiceQuestion(Question question) {
        Object feedbackElem;
        Object materialElem;
        Element itemElem = this.doc.createElement("item");
        itemElem.setAttribute("title", question.getTitle());
        Integer n = this.itemId;
        Integer n2 = this.itemId = Integer.valueOf(this.itemId + 1);
        itemElem.setAttribute("ident", "QUE_" + this.itemId);
        Element presentationElem = (Element)itemElem.appendChild(this.doc.createElement("presentation"));
        if (!StringUtils.isBlank((String)question.getText())) {
            materialElem = (Element)presentationElem.appendChild(this.doc.createElement("material"));
            this.appendMaterialElements((Element)materialElem, question.getText());
        }
        materialElem = this.itemId;
        Integer n3 = this.itemId = Integer.valueOf(this.itemId + 1);
        String responseLidIdentifier = "QUE_" + this.itemId + "_RL";
        Element responseLidElem = (Element)presentationElem.appendChild(this.doc.createElement("response_lid"));
        responseLidElem.setAttribute("ident", responseLidIdentifier);
        responseLidElem.setAttribute("rcardinality", "mr".equals(question.getType()) ? "Multiple" : "Single");
        responseLidElem.setAttribute("rtiming", "No");
        ArrayList<Object> feedbackList = new ArrayList<Object>();
        String correctFeedbackLabel = null;
        String incorrectFeedbackLabel = null;
        Element overallFeedbackElem = null;
        if (!StringUtils.isBlank((String)question.getFeedback())) {
            overallFeedbackElem = this.createFeedbackElem("_ALL", question.getFeedback(), "All");
            feedbackList.add(overallFeedbackElem);
        }
        Element renderChoiceElem = (Element)responseLidElem.appendChild(this.doc.createElement("render_choice"));
        int answerId = 0;
        ArrayList<Element> respconditionList = new ArrayList<Element>(question.getAnswers().size());
        for (Answer answer : question.getAnswers()) {
            boolean isCorrect;
            boolean bl = isCorrect = answer.getScore().floatValue() > 0.0f;
            if (StringUtils.isBlank((String)answer.getFeedback())) continue;
            if (!isCorrect && incorrectFeedbackLabel == null) {
                feedbackElem = this.createFeedbackElem("_IC", answer.getFeedback(), "Candidate");
                feedbackList.add(feedbackElem);
                incorrectFeedbackLabel = feedbackElem.getAttribute("ident");
                continue;
            }
            if (!isCorrect || correctFeedbackLabel != null) continue;
            feedbackElem = this.createFeedbackElem("_C", answer.getFeedback(), "Candidate");
            feedbackList.add(feedbackElem);
            correctFeedbackLabel = feedbackElem.getAttribute("ident");
        }
        for (Answer answer : question.getAnswers()) {
            Element displayfeedbackElem;
            Element responseLabelElem = (Element)renderChoiceElem.appendChild(this.doc.createElement("response_label"));
            feedbackElem = this.itemId;
            Integer n4 = this.itemId = Integer.valueOf(this.itemId + 1);
            answerId = (short)(answerId + 1);
            String answerLabel = "QUE_" + this.itemId + "_A" + answerId;
            responseLabelElem.setAttribute("ident", answerLabel);
            if (!StringUtils.isBlank((String)answer.getText())) {
                Element element = (Element)responseLabelElem.appendChild(this.doc.createElement("material"));
                this.appendMaterialElements(element, answer.getText());
            }
            Element n42 = this.doc.createElement("respcondition");
            Element conditionvarElem = (Element)n42.appendChild(this.doc.createElement("conditionvar"));
            Element varequalElem = (Element)conditionvarElem.appendChild(this.doc.createElement("varequal"));
            varequalElem.setAttribute("respident", responseLidIdentifier);
            varequalElem.setTextContent(answerLabel);
            boolean isCorrect = answer.getScore().floatValue() > 0.0f;
            Element setvarElem = (Element)n42.appendChild(this.doc.createElement("setvar"));
            setvarElem.setAttribute("varname", "que_score");
            setvarElem.setAttribute("action", isCorrect && !"mr".equals(question.getType()) ? "Set" : "Add");
            setvarElem.setTextContent(String.valueOf(answer.getScore()));
            if (isCorrect) {
                displayfeedbackElem = (Element)n42.appendChild(this.doc.createElement("displayfeedback"));
                displayfeedbackElem.setAttribute("feedbacktype", "Response");
                displayfeedbackElem.setAttribute("linkrefid", correctFeedbackLabel);
            } else {
                displayfeedbackElem = (Element)n42.appendChild(this.doc.createElement("displayfeedback"));
                displayfeedbackElem.setAttribute("feedbacktype", "Response");
                displayfeedbackElem.setAttribute("linkrefid", incorrectFeedbackLabel);
            }
            if (overallFeedbackElem != null) {
                displayfeedbackElem = (Element)n42.appendChild(this.doc.createElement("displayfeedback"));
                displayfeedbackElem.setAttribute("feedbacktype", "Response");
                displayfeedbackElem.setAttribute("linkrefid", overallFeedbackElem.getAttribute("ident"));
            }
            respconditionList.add(n42);
        }
        if (overallFeedbackElem != null) {
            Element respconditionElem = this.doc.createElement("respcondition");
            Element conditionvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("conditionvar"));
            conditionvarElem.appendChild(this.doc.createElement("other"));
            Element displayfeedbackElem = (Element)respconditionElem.appendChild(this.doc.createElement("displayfeedback"));
            displayfeedbackElem.setAttribute("feedbacktype", "Response");
            displayfeedbackElem.setAttribute("linkrefid", overallFeedbackElem.getAttribute("ident"));
            respconditionList.add(respconditionElem);
        }
        Element resprocessingElem = (Element)itemElem.appendChild(this.doc.createElement("resprocessing"));
        Element outcomesElem = (Element)resprocessingElem.appendChild(this.doc.createElement("outcomes"));
        Element decvarElem = (Element)outcomesElem.appendChild(this.doc.createElement("decvar"));
        decvarElem.setAttribute("vartype", "decimal");
        decvarElem.setAttribute("defaultval", "0");
        decvarElem.setAttribute("varname", "que_score");
        for (Element element : respconditionList) {
            resprocessingElem.appendChild(element);
        }
        for (Element element : feedbackList) {
            itemElem.appendChild(element);
        }
        return itemElem;
    }

    private Element exportMatchingPairsQuestion(Question question) {
        Element itemElem = this.doc.createElement("item");
        itemElem.setAttribute("title", question.getTitle());
        Integer n = this.itemId;
        Integer n2 = this.itemId = Integer.valueOf(this.itemId + 1);
        itemElem.setAttribute("ident", "QUE_" + this.itemId);
        Element itemmetadataElem = (Element)itemElem.appendChild(this.doc.createElement("itemmetadata"));
        Element itemtypeElem = (Element)itemmetadataElem.appendChild(this.doc.createElement("qmd_itemtype"));
        itemtypeElem.setTextContent("Matching");
        Element presentationElem = (Element)itemElem.appendChild(this.doc.createElement("presentation"));
        if (!StringUtils.isBlank((String)question.getText())) {
            Element materialElem = (Element)presentationElem.appendChild(this.doc.createElement("material"));
            this.appendMaterialElements(materialElem, question.getText());
        }
        int answerIndex = 0;
        ArrayList<String> matchAnswerIdents = new ArrayList<String>(question.getAnswers().size());
        ArrayList<Element> respconditionElems = new ArrayList<Element>(question.getAnswers().size());
        for (Answer answer : question.getAnswers()) {
            Integer n3 = this.itemId;
            Integer n4 = this.itemId = Integer.valueOf(this.itemId + 1);
            String responseLidIdentifier = "QUE_" + this.itemId + "_RL";
            Element responseLidElem = (Element)presentationElem.appendChild(this.doc.createElement("response_lid"));
            responseLidElem.setAttribute("ident", responseLidIdentifier);
            Element materialElem = (Element)responseLidElem.appendChild(this.doc.createElement("material"));
            this.appendMaterialElements(materialElem, answer.getText());
            Element renderchoiceElem = (Element)responseLidElem.appendChild(this.doc.createElement("render_choice"));
            renderchoiceElem.setAttribute("shuffle", "No");
            int matchAnswerIndex = 0;
            for (Answer matchAnswer : question.getMatchAnswers()) {
                Element responselabelElem = (Element)renderchoiceElem.appendChild(this.doc.createElement("response_label"));
                String matchAnswerIdent = null;
                if (matchAnswerIdents.size() > matchAnswerIndex) {
                    matchAnswerIdent = (String)matchAnswerIdents.get(matchAnswerIndex);
                } else {
                    Integer n5 = this.itemId;
                    Integer n6 = this.itemId = Integer.valueOf(this.itemId + 1);
                    matchAnswerIdent = "QUE_" + this.itemId + "_A" + (matchAnswerIndex + 1);
                    matchAnswerIdents.add(matchAnswerIdent);
                }
                responselabelElem.setAttribute("ident", matchAnswerIdent);
                materialElem = (Element)responselabelElem.appendChild(this.doc.createElement("material"));
                this.appendMaterialElements(materialElem, matchAnswer.getText());
                if (matchAnswerIndex == question.getMatchMap().get(answerIndex)) {
                    Element respconditionElem = this.doc.createElement("respcondition");
                    respconditionElem.setAttribute("title", "Matching " + responseLidIdentifier + " Resp Condition 1");
                    Element conditionvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("conditionvar"));
                    Element varequalElem = (Element)conditionvarElem.appendChild(this.doc.createElement("varequal"));
                    varequalElem.setAttribute("respident", responseLidIdentifier);
                    varequalElem.setTextContent(matchAnswerIdent);
                    Element setvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("setvar"));
                    setvarElem.setAttribute("varname", "que_score");
                    setvarElem.setAttribute("action", "Add");
                    setvarElem.setTextContent(String.valueOf(answer.getScore()));
                    respconditionElems.add(respconditionElem);
                }
                ++matchAnswerIndex;
            }
            ++answerIndex;
        }
        Element resprocessingElem = (Element)itemElem.appendChild(this.doc.createElement("resprocessing"));
        Element outcomesElem = (Element)resprocessingElem.appendChild(this.doc.createElement("outcomes"));
        Element decvarElem = (Element)outcomesElem.appendChild(this.doc.createElement("decvar"));
        decvarElem.setAttribute("vartype", "decimal");
        decvarElem.setAttribute("defaultval", "0");
        decvarElem.setAttribute("varname", "que_score");
        for (Element respconditionElem : respconditionElems) {
            resprocessingElem.appendChild(respconditionElem);
        }
        if (!StringUtils.isBlank((String)question.getFeedback())) {
            Element respconditionElem;
            Element overallFeedbackElem = this.createFeedbackElem("_ALL", question.getFeedback(), "All");
            respconditionElem = (Element)resprocessingElem.appendChild(this.doc.createElement("respcondition"));
            Element conditionvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("conditionvar"));
            conditionvarElem.appendChild(this.doc.createElement("other"));
            Element displayfeedbackElem = (Element)respconditionElem.appendChild(this.doc.createElement("displayfeedback"));
            displayfeedbackElem.setAttribute("feedbacktype", "Response");
            displayfeedbackElem.setAttribute("linkrefid", overallFeedbackElem.getAttribute("ident"));
            itemElem.appendChild(overallFeedbackElem);
        }
        return itemElem;
    }

    private Element exportEssayQuestion(Question question) {
        Object materialElem;
        Element itemElem = this.doc.createElement("item");
        itemElem.setAttribute("title", question.getTitle());
        Integer n = this.itemId;
        Integer n2 = this.itemId = Integer.valueOf(this.itemId + 1);
        itemElem.setAttribute("ident", "QUE_" + this.itemId);
        Element presentationElem = (Element)itemElem.appendChild(this.doc.createElement("presentation"));
        if (!StringUtils.isBlank((String)question.getText())) {
            materialElem = (Element)presentationElem.appendChild(this.doc.createElement("material"));
            this.appendMaterialElements((Element)materialElem, question.getText());
        }
        materialElem = this.itemId;
        Integer n3 = this.itemId = Integer.valueOf(this.itemId + 1);
        Element responseStrElem = (Element)presentationElem.appendChild(this.doc.createElement("response_str"));
        responseStrElem.setAttribute("ident", "QUE_" + this.itemId + "_RS");
        Element renderFibElem = (Element)responseStrElem.appendChild(this.doc.createElement("render_fib"));
        renderFibElem.setAttribute("fibtype", "String");
        renderFibElem.setAttribute("prompt", "Box");
        renderFibElem.setAttribute("rows", "5");
        renderFibElem.setAttribute("columns", "50");
        Integer n4 = this.itemId;
        Integer n5 = this.itemId = Integer.valueOf(this.itemId + 1);
        Element responseLabelElem = (Element)renderFibElem.appendChild(this.doc.createElement("response_label"));
        responseLabelElem.setAttribute("ident", "QUE_" + this.itemId + "_ANS");
        if (!StringUtils.isBlank((String)question.getFeedback())) {
            Element overallFeedbackElem = this.createFeedbackElem("_ALL", question.getFeedback(), "All");
            Element resprocessingElem = (Element)itemElem.appendChild(this.doc.createElement("resprocessing"));
            Element respconditionElem = (Element)resprocessingElem.appendChild(this.doc.createElement("respcondition"));
            Element conditionvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("conditionvar"));
            conditionvarElem.appendChild(this.doc.createElement("other"));
            Element displayfeedbackElem = (Element)respconditionElem.appendChild(this.doc.createElement("displayfeedback"));
            displayfeedbackElem.setAttribute("feedbacktype", "Response");
            displayfeedbackElem.setAttribute("linkrefid", overallFeedbackElem.getAttribute("ident"));
            itemElem.appendChild(overallFeedbackElem);
        }
        return itemElem;
    }

    private Element exportFillInBlankQuestion(Question question) {
        Object materialElem;
        Element itemElem = this.doc.createElement("item");
        itemElem.setAttribute("title", question.getTitle());
        Integer n = this.itemId;
        Integer n2 = this.itemId = Integer.valueOf(this.itemId + 1);
        itemElem.setAttribute("ident", "QUE_" + this.itemId);
        Element presentationElem = (Element)itemElem.appendChild(this.doc.createElement("presentation"));
        if (!StringUtils.isBlank((String)question.getText())) {
            materialElem = (Element)presentationElem.appendChild(this.doc.createElement("material"));
            this.appendMaterialElements((Element)materialElem, question.getText());
        }
        materialElem = this.itemId;
        Integer n3 = this.itemId = Integer.valueOf(this.itemId + 1);
        Element responseStrElem = (Element)presentationElem.appendChild(this.doc.createElement("response_str"));
        responseStrElem.setAttribute("ident", "QUE_" + this.itemId + "_RS");
        Element renderFibElem = (Element)responseStrElem.appendChild(this.doc.createElement("render_fib"));
        renderFibElem.setAttribute("fibtype", "String");
        renderFibElem.setAttribute("prompt", "Box");
        Integer n4 = this.itemId;
        Integer n5 = this.itemId = Integer.valueOf(this.itemId + 1);
        Element responseLabelElem = (Element)renderFibElem.appendChild(this.doc.createElement("response_label"));
        responseLabelElem.setAttribute("ident", "QUE_" + this.itemId + "_ANS");
        Element overallFeedbackElem = null;
        if (!StringUtils.isBlank((String)question.getFeedback())) {
            overallFeedbackElem = this.createFeedbackElem("_ALL", question.getFeedback(), "All");
        }
        Element resprocessingElem = (Element)itemElem.appendChild(this.doc.createElement("resprocessing"));
        Element outcomesElem = (Element)resprocessingElem.appendChild(this.doc.createElement("outcomes"));
        Element decvarElem = (Element)outcomesElem.appendChild(this.doc.createElement("decvar"));
        decvarElem.setAttribute("vartype", "decimal");
        decvarElem.setAttribute("defaultval", "0");
        decvarElem.setAttribute("varname", "que_score");
        for (Answer answer : question.getAnswers()) {
            Element respconditionElem = (Element)resprocessingElem.appendChild(this.doc.createElement("respcondition"));
            Element conditionvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("conditionvar"));
            Element varequalElem = (Element)conditionvarElem.appendChild(this.doc.createElement("varequal"));
            varequalElem.setAttribute("respident", responseStrElem.getAttribute("ident"));
            varequalElem.setTextContent(answer.getText());
            Element setvarElem = (Element)respconditionElem.appendChild(this.doc.createElement("setvar"));
            setvarElem.setAttribute("varname", "que_score");
            setvarElem.setAttribute("action", "Add");
            setvarElem.setTextContent(String.valueOf(answer.getScore()));
            if (overallFeedbackElem == null) continue;
            Element displayfeedbackElem = (Element)respconditionElem.appendChild(this.doc.createElement("displayfeedback"));
            displayfeedbackElem.setAttribute("feedbacktype", "Response");
            displayfeedbackElem.setAttribute("linkrefid", overallFeedbackElem.getAttribute("ident"));
        }
        if (overallFeedbackElem != null) {
            itemElem.appendChild(overallFeedbackElem);
        }
        return itemElem;
    }

    private Element createFeedbackElem(String labelSuffix, String feedback, String type) {
        Integer n = this.itemId;
        Integer n2 = this.itemId = Integer.valueOf(this.itemId + 1);
        String label = "QUE_" + this.itemId + labelSuffix;
        Element feedbackElem = this.doc.createElement("itemfeedback");
        feedbackElem.setAttribute("ident", label);
        feedbackElem.setAttribute("view", type);
        Element materialElem = (Element)feedbackElem.appendChild(this.doc.createElement("material"));
        this.appendMaterialElements(materialElem, feedback);
        return feedbackElem;
    }

    private String[] parseImages(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        Matcher matcher = IMAGE_PATTERN.matcher(text);
        while (matcher.find()) {
            result.add(text.substring(index, matcher.start()));
            index = matcher.end();
            String relativePath = matcher.group(1);
            File image = new File(EAR_IMAGE_FOLDER, relativePath);
            if (!image.isFile() || !image.canRead()) {
                log.warn((Object)("Image could not be parsed: " + matcher.group()));
                continue;
            }
            String imageName = null;
            for (String key : this.images.keySet()) {
                if (!image.equals(this.images.get(key))) continue;
                imageName = key;
                break;
            }
            if (imageName == null) {
                String baseImageName;
                imageName = baseImageName = FileUtil.getFileName(relativePath);
                int prefix = 1;
                while (this.images.containsKey(imageName)) {
                    imageName = prefix + "_" + baseImageName;
                    prefix = (short)(prefix + 1);
                }
                this.images.put(imageName, image);
            }
            result.add(IMAGE_MARKER + imageName);
        }
        if (index < text.length()) {
            result.add(text.substring(index));
        }
        return result.toArray(new String[0]);
    }

    private void appendMaterialElements(Element materialElem, String text) {
        String[] answerParts;
        for (String answerPart : answerParts = this.parseImages(text)) {
            if (answerPart.startsWith(IMAGE_MARKER)) {
                String imageName = answerPart.substring(IMAGE_MARKER.length());
                String imageType = "image/" + FileUtil.getFileExtension(imageName);
                Element matimageElem = (Element)materialElem.appendChild(this.doc.createElement("matimage"));
                matimageElem.setAttribute("imagtype", imageType);
                matimageElem.setAttribute("uri", imageName);
                continue;
            }
            Element mattextElem = (Element)materialElem.appendChild(this.doc.createElement("mattext"));
            mattextElem.setAttribute("texttype", "text/html");
            mattextElem.appendChild(this.doc.createCDATASection(answerPart));
        }
    }

    private String createManifest() throws IOException {
        String id = UUID.randomUUID().toString();
        String fileName = this.packageTitle + ".xml";
        StringBuilder resourceEntries = new StringBuilder("<file href=\"").append(fileName).append("\" />\n");
        for (String imageName : this.images.keySet()) {
            resourceEntries.append("<file href=\"").append(imageName).append("\" />").append("\n");
        }
        String manifest = FileUtils.readFileToString((File)MANIFEST_TEMPLATE_FILE);
        manifest = manifest.replace("[ID]", id).replace("[TITLE]", this.packageTitle).replace("[FILE_NAME]", fileName).replace("[FILE_LIST]", resourceEntries);
        return manifest;
    }
}

