/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.questions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.questions.Answer;
import org.lamsfoundation.lams.questions.Question;
import org.lamsfoundation.lams.util.UploadFileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class QuestionParser {
    private static Logger log = Logger.getLogger(QuestionParser.class);
    private static final String TEMP_PACKAGE_NAME_PREFIX = "QTI_PACKAGE_";
    private static final Pattern IMAGE_PATTERN = Pattern.compile("\\[IMAGE: (.*)\\]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Question[] parseQTIPackage(InputStream packageFileStream, Set<String> limitType) throws SAXParseException, IOException, SAXException, ParserConfigurationException, ZipFileUtilException {
        ArrayList result;
        block11: {
            result = new ArrayList();
            String tempPackageName = TEMP_PACKAGE_NAME_PREFIX + System.currentTimeMillis();
            String tempPackageDirPath = ZipFileUtil.expandZip(packageFileStream, tempPackageName);
            try {
                List<File> resourceFiles = QuestionParser.getQTIResourceFiles(tempPackageDirPath);
                if (resourceFiles.isEmpty()) {
                    log.warn((Object)"No resource files found in QTI package");
                    break block11;
                }
                for (File resourceFile : resourceFiles) {
                    Question[] fileQuestions = null;
                    try (FileInputStream xmlFileStream = new FileInputStream(resourceFile);){
                        fileQuestions = QuestionParser.parseQTIFile(xmlFileStream, tempPackageDirPath, limitType);
                    }
                    if (fileQuestions == null) continue;
                    Collections.addAll(result, fileQuestions);
                }
            }
            finally {
                packageFileStream.close();
                boolean tempFolderStillNeeded = false;
                if (result != null) {
                    for (Question question : result) {
                        if (StringUtils.isBlank((String)question.getResourcesFolderPath())) continue;
                        tempFolderStillNeeded = true;
                        break;
                    }
                }
                if (!tempFolderStillNeeded) {
                    ZipFileUtil.deleteDirectory(tempPackageDirPath);
                }
            }
        }
        return result.toArray(Question.QUESTION_ARRAY_TYPE);
    }

    public static Question[] parseQTIFile(InputStream xmlFileStream, String resourcesFolderPath, Set<String> limitType) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<Question> result = new ArrayList<Question>();
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(xmlFileStream);
        NodeList questionItems = doc.getElementsByTagName("item");
        block0: for (int questionItemIndex = 0; questionItemIndex < questionItems.getLength(); ++questionItemIndex) {
            Answer answer;
            Element questionItem = (Element)questionItems.item(questionItemIndex);
            NodeList questionItemTypes = questionItem.getElementsByTagName("qmd_itemtype");
            String questionItemType = questionItemTypes.getLength() > 0 ? ((Text)questionItemTypes.item(0).getChildNodes().item(0)).getData() : null;
            Question question = new Question();
            if ("Matching".equalsIgnoreCase(questionItemType) && !QuestionParser.isQuestionTypeAcceptable("mt", limitType, question)) continue;
            String questionTitle = questionItem.getAttribute("title");
            question.setTitle(questionTitle);
            TreeMap<String, Answer> answerMap = new TreeMap<String, Answer>();
            TreeMap<String, Answer> matchAnswerMap = null;
            boolean textBasedQuestion = false;
            Element presentation = (Element)questionItem.getElementsByTagName("presentation").item(0);
            NodeList presentationChildrenList = presentation.getChildNodes();
            for (int presentationChildIndex = 0; presentationChildIndex < presentationChildrenList.getLength(); ++presentationChildIndex) {
                Node presentationChild = presentationChildrenList.item(presentationChildIndex);
                if ("material".equals(presentationChild.getNodeName())) {
                    String questionText = QuestionParser.parseMaterialElement(presentationChild, question, resourcesFolderPath);
                    if (questionText.trim().startsWith("<!--")) continue block0;
                    question.setText(questionText);
                    continue;
                }
                if ("response_lid".equals(presentationChild.getNodeName())) {
                    if (question.getAnswers() == null) {
                        boolean multipleAnswersAllowed = "multiple".equalsIgnoreCase(((Element)presentationChild).getAttribute("rcardinality"));
                        NodeList answerList = ((Element)presentationChild).getElementsByTagName("response_label");
                        for (int answerIndex = 0; answerIndex < answerList.getLength(); ++answerIndex) {
                            Element answerElement = (Element)answerList.item(answerIndex);
                            Element materialElement = (Element)answerElement.getElementsByTagName("material").item(0);
                            String answerText = QuestionParser.parseMaterialElement(materialElement, question, resourcesFolderPath);
                            if (question.getType() == null && !"true".equalsIgnoreCase(answerText) && !"false".equalsIgnoreCase(answerText) && !QuestionParser.isQuestionTypeAcceptable(multipleAnswersAllowed ? "mr" : "mc", limitType, question)) continue block0;
                            Answer answer2 = new Answer();
                            answer2.setText(answerText);
                            if (question.getAnswers() == null) {
                                question.setAnswers(new ArrayList<Answer>());
                            }
                            question.getAnswers().add(answer2);
                            String answerId = answerElement.getAttribute("ident");
                            answerMap.put(answerId, answer2);
                        }
                        if (question.getType() == null && question.getAnswers() != null && question.getAnswers().size() == 2 && !multipleAnswersAllowed && !QuestionParser.isQuestionTypeAcceptable("tf", limitType, question)) continue block0;
                    }
                    if (!"mt".equals(question.getType())) continue;
                    if (question.getMatchAnswers() == null) {
                        question.setMatchAnswers(question.getAnswers());
                        question.setAnswers(new ArrayList<Answer>());
                        matchAnswerMap = answerMap;
                        answerMap = new TreeMap();
                    }
                    NodeList responseLidChildrenList = presentationChild.getChildNodes();
                    for (int responseLidChildIndex = 0; responseLidChildIndex < responseLidChildrenList.getLength(); ++responseLidChildIndex) {
                        Node responseLidChild = responseLidChildrenList.item(responseLidChildIndex);
                        if (!"material".equals(responseLidChild.getNodeName())) continue;
                        String answerText = QuestionParser.parseMaterialElement(responseLidChild, question, resourcesFolderPath);
                        answer = new Answer();
                        answer.setText(answerText);
                        question.getAnswers().add(answer);
                        String answerId = ((Element)presentationChild).getAttribute("ident");
                        answerMap.put(answerId, answer);
                    }
                    continue;
                }
                if (!"response_str".equals(presentationChild.getNodeName())) continue;
                textBasedQuestion = true;
            }
            TreeMap<String, String> feedbackMap = new TreeMap<String, String>();
            if (textBasedQuestion || !answerMap.isEmpty()) {
                NodeList answerMetadatas = questionItem.getElementsByTagName("respcondition");
                if (answerMetadatas.getLength() == 0 && question.getType() == null && textBasedQuestion && !QuestionParser.isQuestionTypeAcceptable("es", limitType, question)) continue;
                for (int answerMetadataIndex = 0; answerMetadataIndex < answerMetadatas.getLength(); ++answerMetadataIndex) {
                    Element setVarElement;
                    String score;
                    String answerId;
                    Element answerMetadata = (Element)answerMetadatas.item(answerMetadataIndex);
                    NodeList scoreReference = answerMetadata.getElementsByTagName("varequal");
                    String string = answerId = scoreReference.getLength() > 0 ? ((Text)scoreReference.item(0).getChildNodes().item(0)).getData() : null;
                    if (answerId == null) {
                        if (question.getType() != null || !textBasedQuestion || QuestionParser.isQuestionTypeAcceptable("es", limitType, question)) continue;
                        continue block0;
                    }
                    if (question.getType() == null && textBasedQuestion && !QuestionParser.isQuestionTypeAcceptable("fb", limitType, question)) continue block0;
                    answer = null;
                    if (textBasedQuestion) {
                        answer = new Answer();
                        answer.setText(answerId);
                        if (question.getAnswers() == null) {
                            question.setAnswers(new ArrayList<Answer>());
                        }
                        question.getAnswers().add(answer);
                    }
                    if (!StringUtils.isBlank((String)(score = ((Text)(setVarElement = (Element)answerMetadata.getElementsByTagName("setvar").item(0)).getChildNodes().item(0)).getData()))) {
                        if ("mt".equals(question.getType())) {
                            if (setVarElement.getAttribute("varname").endsWith("_Correct")) {
                                Answer matchAnswer = (Answer)matchAnswerMap.get(answerId);
                                answerId = ((Element)scoreReference.item(0)).getAttribute("respident");
                                answer = (Answer)answerMap.get(answerId);
                                answer.setScore(Float.valueOf(Float.parseFloat(score)));
                                if (question.getMatchMap() == null) {
                                    question.setMatchMap(new TreeMap<Integer, Integer>());
                                }
                                Integer answerIndex = question.getAnswers().indexOf(answer);
                                Integer matchAnswerIndex = question.getMatchAnswers().indexOf(matchAnswer);
                                question.getMatchMap().put(answerIndex, matchAnswerIndex);
                            }
                        } else {
                            if (answer == null) {
                                answer = (Answer)answerMap.get(answerId);
                            }
                            answer.setScore(Float.valueOf(Float.parseFloat(score)));
                        }
                    }
                    NodeList feedbacks = answerMetadata.getElementsByTagName("displayfeedback");
                    for (int feedbackIndex = 0; feedbackIndex < feedbacks.getLength(); ++feedbackIndex) {
                        Element feedbackElement = (Element)feedbacks.item(feedbackIndex);
                        String feedbackId = feedbackElement.getAttribute("linkrefid");
                        if (feedbackId.endsWith("_ALL")) continue;
                        feedbackMap.put(feedbackId, answerId);
                    }
                }
            }
            NodeList feedbacks = questionItem.getElementsByTagName("itemfeedback");
            for (int feedbackIndex = 0; feedbackIndex < feedbacks.getLength(); ++feedbackIndex) {
                Answer answer3;
                Element feedbackElement = (Element)feedbacks.item(feedbackIndex);
                Node materialElement = feedbackElement.getElementsByTagName("material").item(0);
                String feedbackText = QuestionParser.parseMaterialElement(materialElement, question, resourcesFolderPath);
                if (StringUtils.isBlank((String)feedbackText)) continue;
                String feedbackType = feedbackElement.getAttribute("view");
                if ("All".equalsIgnoreCase(feedbackType)) {
                    question.setFeedback(feedbackText);
                    continue;
                }
                String feedbackId = feedbackElement.getAttribute("ident");
                String answerId = (String)feedbackMap.get(feedbackId);
                if (answerId == null || (answer3 = (Answer)answerMap.get(answerId)) == null) continue;
                answer3.setFeedback(feedbackText);
            }
            result.add(question);
        }
        return result.toArray(Question.QUESTION_ARRAY_TYPE);
    }

    public static Question[] parseQuestionChoiceForm(HttpServletRequest request) throws UnsupportedEncodingException {
        ArrayList<Question> result = new ArrayList<Question>();
        int questionCount = WebUtil.readIntParam(request, "questionCount");
        for (int questionIndex = 0; questionIndex < questionCount; ++questionIndex) {
            int answerCount;
            String questionResourcesFolderPath;
            String questionFeedback;
            String questionText;
            Question question;
            String questionType = request.getParameter("question" + questionIndex + "type");
            if (!QuestionParser.isQuestionTypeAcceptable(questionType, null, question = new Question())) continue;
            String questionTitle = request.getParameter("question" + questionIndex);
            if (!StringUtils.isBlank((String)questionTitle)) {
                question.setTitle(questionTitle);
            }
            if (!StringUtils.isBlank((String)(questionText = request.getParameter("question" + questionIndex + "text")))) {
                question.setText(questionText);
            }
            if (!StringUtils.isBlank((String)(questionFeedback = request.getParameter("question" + questionIndex + "feedback")))) {
                question.setFeedback(questionFeedback);
            }
            if (!StringUtils.isBlank((String)(questionResourcesFolderPath = request.getParameter("question" + questionIndex + "resourcesFolder")))) {
                question.setResourcesFolderPath(questionResourcesFolderPath);
            }
            boolean isMatching = "mt".equals(question.getType());
            String answerCountParam = request.getParameter("answerCount" + questionIndex);
            int n = answerCount = answerCountParam == null ? 0 : Integer.parseInt(answerCountParam);
            if (answerCount > 0) {
                question.setAnswers(new ArrayList<Answer>());
                for (int answerIndex = 0; answerIndex < answerCount; ++answerIndex) {
                    String matchAnswerIndex;
                    String answerFeedback;
                    String answerId = "question" + questionIndex + "answer" + answerIndex;
                    String answerText = request.getParameter(answerId);
                    String answerScore = request.getParameter(answerId + "score");
                    if (StringUtils.isBlank((String)answerText)) continue;
                    Answer answer = new Answer();
                    answer.setText(answerText);
                    if (!StringUtils.isBlank((String)answerScore)) {
                        answer.setScore(Float.valueOf(Float.parseFloat(answerScore)));
                    }
                    if (!StringUtils.isBlank((String)(answerFeedback = request.getParameter(answerId + "feedback")))) {
                        answer.setFeedback(answerFeedback);
                    }
                    question.getAnswers().add(answer);
                    if (!isMatching || StringUtils.isBlank((String)(matchAnswerIndex = request.getParameter("question" + questionIndex + "match" + answerIndex)))) continue;
                    if (question.getMatchMap() == null) {
                        question.setMatchMap(new TreeMap<Integer, Integer>());
                    }
                    question.getMatchMap().put(answerIndex, Integer.valueOf(matchAnswerIndex));
                }
            }
            if (isMatching) {
                int matchAnswerCount;
                String matchAnswerCountParam = request.getParameter("matchAnswerCount" + questionIndex);
                int n2 = matchAnswerCount = matchAnswerCountParam == null ? 0 : Integer.parseInt(matchAnswerCountParam);
                if (matchAnswerCount > 0) {
                    question.setMatchAnswers(new ArrayList<Answer>());
                    for (int matchAnswerIndex = 0; matchAnswerIndex < matchAnswerCount; ++matchAnswerIndex) {
                        String matchAnswerId = "question" + questionIndex + "matchAnswer" + matchAnswerIndex;
                        String matchAnswerText = request.getParameter(matchAnswerId);
                        if (StringUtils.isBlank((String)matchAnswerText)) continue;
                        Answer matchAnswer = new Answer();
                        matchAnswer.setText(matchAnswerText);
                        question.getMatchAnswers().add(matchAnswer);
                    }
                }
            }
            result.add(question);
        }
        return result.toArray(Question.QUESTION_ARRAY_TYPE);
    }

    public static String processHTMLField(String fieldText, boolean forcePlainText, String contentFolderID, String resourcesFolderPath) {
        String result;
        String string = result = forcePlainText ? WebUtil.removeHTMLtags(fieldText) : fieldText;
        if (!StringUtils.isBlank((String)result)) {
            Matcher imageMatcher = IMAGE_PATTERN.matcher(result);
            StringBuffer resultBuilder = new StringBuffer();
            while (imageMatcher.find()) {
                String fileName = imageMatcher.group(1);
                String replacement = "";
                if (!forcePlainText) {
                    if (resourcesFolderPath == null) {
                        log.warn((Object)("Image " + fileName + " declaration found but its location is unknown."));
                    } else {
                        File sourceFile = new File(resourcesFolderPath, fileName);
                        if (sourceFile.canRead()) {
                            File uploadDir = UploadFileUtil.getUploadDir(contentFolderID, "Image");
                            String destinationFileName = UploadFileUtil.getUploadFileName(uploadDir, fileName);
                            File destinationFile = new File(uploadDir, destinationFileName);
                            String uploadWebPath = UploadFileUtil.getUploadWebPath(contentFolderID, "Image") + '/' + fileName;
                            try {
                                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                                replacement = "<img src=\"" + uploadWebPath + "\" />";
                            }
                            catch (IOException e) {
                                log.error((Object)("Could not store image " + fileName));
                            }
                        } else {
                            log.warn((Object)("Image " + fileName + " declaration found but it can not be read."));
                        }
                    }
                }
                imageMatcher.appendReplacement(resultBuilder, replacement);
            }
            imageMatcher.appendTail(resultBuilder);
            result = resultBuilder.toString();
        }
        return StringUtils.isBlank((String)result) ? null : result;
    }

    private static List<File> getQTIResourceFiles(String packageDirPath) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream inputStream = new FileInputStream(new File(packageDirPath, "imsmanifest.xml"));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document manifest = docBuilder.parse(inputStream);
        NodeList resourcesList = manifest.getElementsByTagName("resources");
        LinkedList<File> resourceFiles = new LinkedList<File>();
        if (resourcesList.getLength() > 0) {
            Element resources = (Element)resourcesList.item(0);
            NodeList resourceList = resources.getElementsByTagName("resource");
            for (int resourceIndex = 0; resourceIndex < resourceList.getLength(); ++resourceIndex) {
                Element resource = (Element)resourceList.item(resourceIndex);
                String resourceFileName = resource.getAttribute("href");
                if (!resourceFileName.endsWith(".xml")) continue;
                File resourceFile = new File(packageDirPath, resourceFileName);
                if (!resourceFile.isFile() || !resourceFile.canRead()) {
                    log.warn((Object)("XML resource file specified in IMS manifest can not be read: " + resourceFileName));
                    continue;
                }
                resourceFiles.add(resourceFile);
            }
        }
        return resourceFiles;
    }

    private static boolean isQuestionTypeAcceptable(String type, Set<String> limitType, Question question) {
        if (type == null || !Question.QUESTION_TYPES.contains(type)) {
            return false;
        }
        question.setType(type);
        return limitType == null || limitType.isEmpty() || limitType.contains(type);
    }

    private static String parseMaterialElement(Node materialElement, Question question, String resourcesFolderPath) {
        StringBuilder result = new StringBuilder();
        NodeList questionElements = materialElement.getChildNodes();
        for (int questionElementIndex = 0; questionElementIndex < questionElements.getLength(); ++questionElementIndex) {
            Node questionElement = questionElements.item(questionElementIndex);
            String elementName = questionElement.getNodeName();
            if ("mattext".equalsIgnoreCase(elementName)) {
                String questionTextPart = ((CDATASection)questionElement.getChildNodes().item(0)).getData();
                result.append(questionTextPart);
                continue;
            }
            if (!"matimage".equalsIgnoreCase(elementName)) continue;
            String fileName = ((Element)questionElement).getAttribute("uri");
            if (resourcesFolderPath == null) {
                log.warn((Object)("Image " + fileName + " declaration found but its location is unknown"));
                continue;
            }
            if (question.getResourcesFolderPath() == null) {
                question.setResourcesFolderPath(resourcesFolderPath);
            }
            result.append("[IMAGE: ").append(fileName).append("]");
        }
        return result.toString();
    }
}

