/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class OutputFactory {
    protected Logger log = Logger.getLogger(OutputFactory.class);
    private MessageService toolMessageService;
    private ILoadedMessageSourceService loadedMessageSourceService;
    private String languageFilename;
    private MessageSource msgSource = null;
    protected final String KEY_PREFIX = "output.desc.";
    protected final String CONDITION_NAME_SEPARATOR = "#";

    public abstract SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object var1, int var2) throws ToolException;

    private MessageService getToolMessageService() {
        return this.toolMessageService;
    }

    public void setToolMessageService(MessageService toolMessageService) {
        this.toolMessageService = toolMessageService;
    }

    private ILoadedMessageSourceService getLoadedMessageSourceService() {
        return this.loadedMessageSourceService;
    }

    public void setLoadedMessageSourceService(ILoadedMessageSourceService loadedMessageSourceService) {
        this.loadedMessageSourceService = loadedMessageSourceService;
    }

    public String getLanguageFilename() {
        return this.languageFilename;
    }

    public void setLanguageFilename(String languageFilename) {
        this.languageFilename = languageFilename;
    }

    protected String getI18NText(String key, boolean addPrefix) {
        String translatedText = null;
        MessageSource tmpMsgSource = this.getMsgSource();
        if (tmpMsgSource != null) {
            if (addPrefix) {
                key = "output.desc." + key;
            }
            Locale locale = LocaleContextHolder.getLocale();
            try {
                translatedText = tmpMsgSource.getMessage(key, null, locale);
            }
            catch (NoSuchMessageException e) {
                this.log.warn((Object)("Unable to internationalise the text for key " + key + " as no matching key found in the msgSource"));
            }
        } else {
            this.log.warn((Object)("Unable to internationalise the text for key " + key + " as no matching key found in the msgSource. The tool's OutputDefinition factory needs to set either (a) messageSource or (b) loadedMessageSourceService and languageFilename."));
        }
        if (translatedText == null || translatedText.length() == 0) {
            translatedText = key.replace('.', ' ');
        }
        return translatedText;
    }

    private MessageSource getMsgSource() {
        if (this.msgSource == null) {
            if (this.getToolMessageService() != null) {
                this.msgSource = this.getToolMessageService().getMessageSource();
            }
            if (this.msgSource == null && this.getLoadedMessageSourceService() != null && this.getLanguageFilename() != null) {
                this.msgSource = this.getLoadedMessageSourceService().getMessageService(this.getLanguageFilename());
            }
        }
        return this.msgSource;
    }

    protected ToolOutputDefinition buildDefinition(String definitionName, OutputType type, Object startValue, Object endValue, Object complexValue, Boolean showConditionNameOnly, Class valueClass) {
        ToolOutputDefinition definition = new ToolOutputDefinition();
        definition.setName(definitionName);
        definition.setDescription(this.getI18NText(definitionName, true));
        definition.setType(type);
        definition.setStartValue(startValue);
        definition.setEndValue(endValue);
        definition.setComplexDefinition(complexValue);
        definition.setShowConditionNameOnly(showConditionNameOnly);
        definition.setValueClass(valueClass);
        return definition;
    }

    protected ToolOutputDefinition buildDefinition(String definitionName, OutputType type, Object startValue, Object endValue, Object complexValue, Boolean showConditionNameOnly, Boolean isDefaultGradebookMark, Class valueClass) {
        ToolOutputDefinition definition = this.buildDefinition(definitionName, type, startValue, endValue, complexValue, showConditionNameOnly, valueClass);
        definition.setIsDefaultGradebookMark(isDefaultGradebookMark);
        return definition;
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, Long startValue, Long endValue) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_LONG, startValue, endValue, null, Boolean.FALSE, Long.class);
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, String startValue, String endValue) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_STRING, startValue, endValue, null, Boolean.FALSE, String.class);
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, Long startValue, Long endValue, Boolean isDefaultGradebookMark) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_LONG, startValue, endValue, null, Boolean.FALSE, isDefaultGradebookMark, String.class);
    }

    protected ToolOutputDefinition buildRangeDefinition(String definitionName, String startValue, String endValue, Boolean isDefaultGradebookMark) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_STRING, startValue, endValue, null, Boolean.FALSE, isDefaultGradebookMark, String.class);
    }

    protected ToolOutputDefinition buildLongOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_LONG, null, null, null, Boolean.FALSE, Long.class);
    }

    protected ToolOutputDefinition buildDoubleOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_DOUBLE, null, null, null, Boolean.FALSE, Double.class);
    }

    protected ToolOutputDefinition buildBooleanOutputDefinition(String definitionName) {
        ToolOutputDefinition definition = this.buildDefinition(definitionName, OutputType.OUTPUT_BOOLEAN, null, null, null, Boolean.FALSE, Boolean.class);
        ArrayList<BranchCondition> defaultConditions = new ArrayList<BranchCondition>();
        defaultConditions.add(new BranchCondition(null, null, new Integer(1), definitionName, this.getI18NText(definitionName + ".true", true), OutputType.OUTPUT_BOOLEAN.toString(), null, null, Boolean.TRUE.toString()));
        defaultConditions.add(new BranchCondition(null, null, new Integer(2), definitionName, this.getI18NText(definitionName + ".false", true), OutputType.OUTPUT_BOOLEAN.toString(), null, null, Boolean.FALSE.toString()));
        definition.setDefaultConditions(defaultConditions);
        return definition;
    }

    protected ToolOutputDefinition buildBooleanSetOutputDefinition(String definitionName) {
        ToolOutputDefinition definition = this.buildDefinition(definitionName, OutputType.OUTPUT_SET_BOOLEAN, null, null, null, Boolean.TRUE, new HashSet().getClass());
        ArrayList<BranchCondition> defaultConditions = new ArrayList<BranchCondition>();
        definition.setDefaultConditions(defaultConditions);
        return definition;
    }

    protected ToolOutputDefinition buildStringOutputDefinition(String definitionName) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_STRING, null, null, null, Boolean.FALSE, String.class);
    }

    protected ToolOutputDefinition buildComplexOutputDefinition(String definitionName, Class valueClass) {
        return this.buildDefinition(definitionName, OutputType.OUTPUT_COMPLEX, null, null, null, Boolean.FALSE, valueClass);
    }

    protected String buildConditionName(String definitionName, String uniquePart) {
        return uniquePart != null && uniquePart.length() > 0 ? definitionName + "#" + uniquePart : definitionName;
    }

    protected String[] splitConditionName(String conditionName) {
        int index = conditionName.indexOf("#");
        if (index > -1) {
            if (index + 1 < conditionName.length()) {
                return new String[]{conditionName.substring(0, index), conditionName.substring(index + 1)};
            }
            return new String[]{conditionName.substring(0, index), ""};
        }
        return new String[]{conditionName, ""};
    }

    public Class[] getSupportedDefinitionClasses(int definitionType) {
        return null;
    }
}

