/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.stereotype.Repository;

@Repository
public class ToolSessionDAO
extends LAMSBaseDAO
implements IToolSessionDAO {
    private static final String LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER = "from NonGroupedToolSession s where s.user = :learner and s.toolActivity = :activity";
    private static final String LOAD_GROUPED_TOOL_SESSION_BY_GROUP2 = "select s from GroupedToolSession as s inner join s.sessionGroup as sg inner join sg.users as u  where :learner = u and s.toolActivity = :activity";
    private static final String LOAD_TOOL_SESSION_BY_ACTIVITY = "from ToolSession s where s.toolActivity = :activity";
    private static final String LOAD_TOOL_SESSION_BY_LESSON = "from ToolSession s where s.lesson = :lesson";

    @Override
    public ToolSession getToolSession(Long toolSessionId) {
        ToolSession session = (ToolSession)this.getSession().get(ToolSession.class, (Serializable)toolSessionId);
        return session;
    }

    @Override
    public ToolSession getToolSessionByLearner(User learner, Activity activity) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(LOAD_GROUPED_TOOL_SESSION_BY_GROUP2);
        query.setParameter("learner", (Object)learner);
        query.setParameter("activity", (Object)activity);
        GroupedToolSession groupedToolSession = (GroupedToolSession)query.uniqueResult();
        if (groupedToolSession != null) {
            return groupedToolSession;
        }
        query = this.getSessionFactory().getCurrentSession().createQuery(LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER);
        query.setParameter("learner", (Object)learner);
        query.setParameter("activity", (Object)activity);
        NonGroupedToolSession nonGroupedSession = (NonGroupedToolSession)query.uniqueResult();
        return nonGroupedSession;
    }

    @Override
    public List getToolSessionByActivity(Activity activity) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(LOAD_TOOL_SESSION_BY_ACTIVITY);
        query.setParameter("activity", (Object)activity);
        return query.list();
    }

    @Override
    public void saveToolSession(ToolSession toolSession) {
        this.getSession().save((Object)toolSession);
    }

    @Override
    public void removeToolSession(ToolSession toolSession) {
        this.getSession().delete((Object)toolSession);
    }

    @Override
    public List getToolSessionsByLesson(Lesson lesson) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(LOAD_TOOL_SESSION_BY_LESSON);
        query.setParameter("lesson", (Object)lesson);
        return query.list();
    }

    @Override
    public void updateToolSession(ToolSession toolSession) {
        this.getSession().update((Object)toolSession);
    }
}

