/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.usermanagement.IUserDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class UserDAO
extends LAMSBaseDAO
implements IUserDAO {
    @Override
    public List<UserDTO> getAllUsersPaged(int page, int size, String sortBy, String sortOrder, String searchPhrase) {
        StringBuilder queryBuilder = new StringBuilder("SELECT user.userId, user.login, user.firstName, user.lastName, user.email FROM User user WHERE user.disabledFlag=0 ");
        UserDAO.addNameSearch(queryBuilder, "user", searchPhrase);
        queryBuilder.append(" ORDER BY CASE WHEN :sortBy='userId' THEN user.userId WHEN :sortBy='login' THEN user.login WHEN :sortBy='firstName' THEN user.firstName  WHEN :sortBy='lastName' THEN user.lastName WHEN :sortBy='email' THEN user.email END ").append(sortOrder);
        Query query = this.getSession().createQuery(queryBuilder.toString());
        query.setString("sortBy", sortBy);
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        List list = query.list();
        ArrayList<UserDTO> userDtos = new ArrayList<UserDTO>();
        for (Object[] element : list) {
            Integer userId = ((Number)element[0]).intValue();
            String login = (String)element[1];
            String firstName = (String)element[2];
            String lastName = (String)element[3];
            String email = (String)element[4];
            UserDTO userDto = new UserDTO(userId, firstName, lastName, login, null, null, null, email, null, null, null, null, null, null, true, null, false);
            userDtos.add(userDto);
        }
        return userDtos;
    }

    @Override
    public int getCountUsers(String searchPhrase) {
        StringBuilder queryBuilder = new StringBuilder("SELECT count(*) FROM User user WHERE user.disabledFlag=0 ");
        UserDAO.addNameSearch(queryBuilder, "user", searchPhrase);
        Query query = this.getSession().createQuery(queryBuilder.toString());
        Number count = (Number)query.uniqueResult();
        return count == null ? 0 : count.intValue();
    }

    @Override
    public List<User> findUsers(String searchPhrase) {
        StringBuilder queryBuilder = new StringBuilder("SELECT u FROM User u WHERE u.disabledFlag=0 ");
        UserDAO.addNameSearch(queryBuilder, "u", searchPhrase);
        queryBuilder.append(" ORDER BY u.login");
        return this.find(queryBuilder.toString());
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer filteredOrgId) {
        StringBuilder queryBuilder = new StringBuilder("SELECT u FROM User u WHERE u.disabledFlag=0 AND u.userId NOT IN (SELECT uo.user.userId FROM UserOrganisation uo WHERE uo.organisation.organisationId=").append(filteredOrgId).append(")");
        UserDAO.addNameSearch(queryBuilder, "u", searchPhrase);
        queryBuilder.append(" ORDER BY u.login");
        return this.find(queryBuilder.toString());
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer orgId, Integer filteredOrgId) {
        StringBuilder queryBuilder = new StringBuilder("SELECT uo.user FROM UserOrganisation uo WHERE uo.user.disabledFlag=0 AND uo.organisation.organisationId=").append(orgId).append(" AND uo.user.userId NOT IN (SELECT uo.user.userId FROM UserOrganisation uo WHERE uo.organisation.organisationId=").append(filteredOrgId).append(")");
        UserDAO.addNameSearch(queryBuilder, "uo.user", searchPhrase);
        queryBuilder.append(" ORDER BY uo.user.login");
        return this.find(queryBuilder.toString());
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer orgId, boolean includeChildOrgs) {
        StringBuilder queryBuilder = new StringBuilder("SELECT u FROM User u WHERE u.disabledFlag=0 AND u.userId IN (SELECT uo.user.userId FROM UserOrganisation uo WHERE uo.organisation.organisationId=").append(orgId);
        if (includeChildOrgs) {
            queryBuilder.append(" OR uo.organisation.parentOrganisation.organisationId=").append(orgId);
        }
        queryBuilder.append(")");
        UserDAO.addNameSearch(queryBuilder, "u", searchPhrase);
        queryBuilder.append(" ORDER BY u.login");
        return this.find(queryBuilder.toString());
    }

    @Override
    public List<User> getAllUsers() {
        return this.find("FROM User u WHERE u.disabledFlag=0 ORDER BY u.login");
    }

    @Override
    public List<User> findUsers(Integer filteredOrgId) {
        return this.find("FROM User u WHERE u.disabledFlag=0 AND u.userId NOT IN (SELECT uo.user.userId FROM UserOrganisation uo WHERE uo.organisation.organisationId=" + filteredOrgId + ") ORDER BY u.login");
    }

    @Override
    public List<User> findUsersWithEmail(String email) {
        return this.find("FROM User u WHERE u.email='" + StringEscapeUtils.escapeSql((String)email) + "' ORDER BY u.login");
    }

    private static void addNameSearch(StringBuilder queryBuilder, String entityName, String searchPhrase) {
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = StringEscapeUtils.escapeSql((String)searchPhrase).trim().split("\\s+")) {
                String escToken = StringEscapeUtils.escapeSql((String)token);
                queryBuilder.append(" AND (").append(entityName).append(".firstName LIKE '%").append(escToken).append("%' OR ").append(entityName).append(".lastName LIKE '%").append(escToken).append("%' OR ").append(entityName).append(".login LIKE '%").append(escToken).append("%' OR ").append(entityName).append(".email LIKE '%").append(escToken).append("%')");
            }
        }
    }
}

