/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.hibernate;

import java.util.Arrays;
import java.util.List;
import javax.transaction.Synchronization;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.springframework.orm.hibernate4.SpringSessionContext;
import org.springframework.transaction.jta.JtaAfterCompletionSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareSessionContext
implements CurrentSessionContext {
    private static final Logger logger = Logger.getLogger(TransactionAwareSessionContext.class);
    private static final long serialVersionUID = -4213662197614198364L;
    private final SessionFactoryImplementor sessionFactory;
    private final SpringSessionContext defaultSessionContext;
    private final ManagedSessionContext localSessionContext;

    public TransactionAwareSessionContext(SessionFactoryImplementor theSessionFactory) {
        Validate.notNull((Object)theSessionFactory, (String)"The session factory cannot be null.");
        this.defaultSessionContext = new SpringSessionContext(theSessionFactory);
        this.localSessionContext = new ManagedSessionContext(theSessionFactory);
        this.sessionFactory = theSessionFactory;
    }

    public Session currentSession() {
        try {
            Session s = this.defaultSessionContext.currentSession();
            return s;
        }
        catch (HibernateException cause) {
            FlushMode flushMode;
            if (ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
                return this.localSessionContext.currentSession();
            }
            Session session = this.sessionFactory.openSession();
            logger.warn((Object)("No Session bound to current Thread. Opened new Session [" + session + "]. Transaction: " + session.getTransaction()));
            if (this.registerSynchronization(session) && FlushMode.isManualFlushMode((FlushMode)(flushMode = session.getFlushMode())) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.AUTO);
            }
            ManagedSessionContext.bind((Session)session);
            return session;
        }
    }

    private boolean registerSynchronization(Session session) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.createTransactionSynchronization(session));
            return true;
        }
        JtaPlatform jtaPlatform = (JtaPlatform)this.sessionFactory.getServiceRegistry().getService(JtaPlatform.class);
        if (jtaPlatform.canRegisterSynchronization()) {
            List<TransactionSynchronization> synchronizations = Arrays.asList(this.createTransactionSynchronization(session));
            JtaAfterCompletionSynchronization jtaSync = new JtaAfterCompletionSynchronization(synchronizations);
            jtaPlatform.registerSynchronization((Synchronization)jtaSync);
            return true;
        }
        return false;
    }

    private TransactionSynchronization createTransactionSynchronization(final Session session) {
        return new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                session.close();
                ManagedSessionContext.unbind((SessionFactory)TransactionAwareSessionContext.this.sessionFactory);
            }
        };
    }
}

