/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.tool.Tool;

public class LibraryActivityDTO
extends BaseDTO {
    private Integer activityTypeID;
    private Long activityID;
    private Integer activityCategoryID;
    private Integer activityUIID;
    private Long learningLibraryID;
    private Long learningDesignID;
    private Long libraryActivityID;
    private Long parentActivityID;
    private Integer parentUIID;
    private Integer orderID;
    private Long groupingID;
    private Integer groupingUIID;
    private String description;
    private String title;
    private String helpText;
    private Integer xCoord;
    private Integer yCoord;
    private String libraryActivityUIImage;
    private Boolean applyGrouping;
    private Boolean runOffline;
    private Boolean defineLater;
    private Date createDateTime;
    private Integer groupingSupportType;
    private Long toolID;
    private Long toolContentID;
    private String toolDisplayName;
    private Boolean supportsDefineLater;
    private Boolean supportsRunOffline;
    private Boolean supportsModeration;
    private Boolean supportsContribute;
    private String authoringURL;
    private Integer maxOptions;
    private Integer minOptions;
    private String optionsInstructions;
    private Integer gateActivityLevelID;
    private Boolean gateOpen;
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;

    public LibraryActivityDTO(Activity activity) {
        this.activityTypeID = activity.getActivityTypeId();
        this.activityID = activity.getActivityId();
        this.activityCategoryID = activity.getActivityCategoryID();
        this.activityUIID = activity.getActivityUIID();
        this.learningLibraryID = activity.getLearningLibrary() != null ? activity.getLearningLibrary().getLearningLibraryId() : null;
        this.learningDesignID = activity.getLearningDesign() != null ? activity.getLearningDesign().getLearningDesignId() : null;
        this.libraryActivityID = activity.getLibraryActivity() != null ? activity.getLibraryActivity().getActivityId() : null;
        this.parentActivityID = activity.getParentActivity() != null ? activity.getParentActivity().getActivityId() : null;
        this.parentUIID = activity.getParentUIID();
        this.orderID = activity.getOrderId();
        this.groupingID = activity.getGrouping() != null ? activity.getGrouping().getGroupingId() : null;
        this.groupingUIID = activity.getGroupingUIID();
        this.description = activity.getDescription();
        this.title = activity.getTitle();
        this.helpText = activity.getHelpText();
        this.xCoord = activity.getXcoord();
        this.yCoord = activity.getYcoord();
        this.libraryActivityUIImage = activity.getLibraryActivityUiImage();
        this.applyGrouping = activity.getApplyGrouping();
        this.runOffline = activity.getRunOffline();
        this.defineLater = activity.getDefineLater();
        this.createDateTime = activity.getCreateDateTime();
        this.groupingSupportType = activity.getGroupingSupportType();
        this.processActivityType(activity);
    }

    private void processActivityType(Activity activity) {
        if (activity.isGroupingActivity()) {
            this.addGroupingActivityAttributes((GroupingActivity)activity);
        } else if (activity.isToolActivity()) {
            this.addToolActivityAttributes((ToolActivity)activity);
        } else if (activity.isGateActivity()) {
            this.addGateActivityAttributes(activity);
        } else {
            this.addComplexActivityAttributes(activity);
        }
    }

    private void addComplexActivityAttributes(Activity activity) {
        if (activity.isOptionsActivity()) {
            this.addOptionsActivityAttributes((OptionsActivity)activity);
        } else if (activity.isParallelActivity()) {
            this.addParallelActivityAttributes((ParallelActivity)activity);
        } else {
            this.addSequenceActivityAttributes((SequenceActivity)activity);
        }
    }

    private void addGroupingActivityAttributes(GroupingActivity groupingActivity) {
        Grouping grouping = groupingActivity.getCreateGrouping();
    }

    private void addOptionsActivityAttributes(OptionsActivity optionsActivity) {
        this.maxOptions = optionsActivity.getMaxNumberOfOptions();
        this.minOptions = optionsActivity.getMinNumberOfOptions();
        this.optionsInstructions = optionsActivity.getOptionsInstructions();
    }

    private void addParallelActivityAttributes(ParallelActivity activity) {
    }

    private void addSequenceActivityAttributes(SequenceActivity activity) {
    }

    private void addToolActivityAttributes(ToolActivity toolActivity) {
        Tool tool = toolActivity.getTool();
        if (tool != null) {
            this.toolID = tool.getToolId();
            this.toolContentID = new Long(tool.getDefaultToolContentId());
            this.toolDisplayName = tool.getToolDisplayName();
            this.supportsDefineLater = new Boolean(tool.getSupportsDefineLater());
            this.supportsRunOffline = new Boolean(tool.getSupportsRunOffline());
            this.supportsModeration = new Boolean(tool.getSupportsModeration());
            this.supportsContribute = new Boolean(tool.getSupportsContribute());
            this.authoringURL = tool.getAuthorUrl();
        }
    }

    private void addGateActivityAttributes(Object activity) {
        if (activity instanceof SynchGateActivity) {
            this.addSynchGateActivityAttributes((SynchGateActivity)activity);
        } else if (activity instanceof PermissionGateActivity) {
            this.addPermissionGateActivityAttributes((PermissionGateActivity)activity);
        } else {
            this.addScheduleGateActivityAttributes((ScheduleGateActivity)activity);
        }
        GateActivity gateActivity = (GateActivity)activity;
        this.gateActivityLevelID = gateActivity.getGateActivityLevelId();
        this.gateOpen = gateActivity.getGateOpen();
    }

    private void addSynchGateActivityAttributes(SynchGateActivity activity) {
    }

    private void addPermissionGateActivityAttributes(PermissionGateActivity activity) {
    }

    private void addScheduleGateActivityAttributes(ScheduleGateActivity activity) {
        this.gateStartDateTime = activity.getGateStartDateTime();
        this.gateStartTimeOffset = activity.getGateStartTimeOffset();
        this.gateEndDateTime = activity.getGateEndDateTime();
        this.gateEndTimeOffset = activity.getGateEndTimeOffset();
    }

    public Integer getActivityCategoryID() {
        return this.activityCategoryID;
    }

    public Long getActivityID() {
        return this.activityID;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID;
    }

    public Integer getActivityUIID() {
        return this.activityUIID;
    }

    public Boolean getApplyGrouping() {
        return this.applyGrouping;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Boolean getDefineLater() {
        return this.defineLater;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getGroupingID() {
        return this.groupingID;
    }

    public Integer getGroupingSupportType() {
        return this.groupingSupportType;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Long getLearningLibraryID() {
        return this.learningLibraryID;
    }

    public Long getLibraryActivityID() {
        return this.libraryActivityID;
    }

    public String getLibraryActivityUIImage() {
        return this.libraryActivityUIImage;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public Long getParentActivityID() {
        return this.parentActivityID;
    }

    public Integer getParentUIID() {
        return this.parentUIID;
    }

    public Boolean getRunOffline() {
        return this.runOffline;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getxCoord() {
        return this.xCoord;
    }

    public Integer getyCoord() {
        return this.yCoord;
    }

    public String getAuthoringURL() {
        return this.authoringURL;
    }

    public Boolean getSupportsContribute() {
        return this.supportsContribute;
    }

    public Boolean getSupportsDefineLater() {
        return this.supportsDefineLater;
    }

    public Boolean getSupportsModeration() {
        return this.supportsModeration;
    }

    public Boolean getSupportsRunOffline() {
        return this.supportsRunOffline;
    }

    public Long getToolContentID() {
        return this.toolContentID;
    }

    public String getToolDisplayName() {
        return this.toolDisplayName;
    }

    public Long getToolID() {
        return this.toolID;
    }

    public Integer getGateActivityLevelID() {
        return this.gateActivityLevelID;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public Boolean getGateOpen() {
        return this.gateOpen;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public Integer getMaxOptions() {
        return this.maxOptions;
    }

    public Integer getMinOptions() {
        return this.minOptions;
    }

    public String getOptionsInstructions() {
        return this.optionsInstructions;
    }
}

