/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import org.hibernate.Query;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ToolSessionDAO
extends HibernateDaoSupport
implements IToolSessionDAO {
    protected static final String LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER = "from NonGroupedToolSession s where s.user = :learner and s.toolActivity = :activity";
    protected static final String LOAD_GROUPED_TOOL_SESSION_BY_GROUP = "from GroupedToolSession s where s.sessionGroup = :inputgroup and s.toolActivity = :activity";
    protected static final String LOAD_GROUPED_TOOL_SESSION_BY_GROUP2 = "select s from GroupedToolSession as s inner join s.sessionGroup as sg inner join sg.users as u  where :learner = u and s.toolActivity = :activity";

    public ToolSession getToolSession(Long toolSessionId) {
        ToolSession session = (ToolSession)this.getHibernateTemplate().get(ToolSession.class, (Serializable)toolSessionId);
        return session;
    }

    public ToolSession getToolSessionByLearner(User learner, Activity activity) {
        Query query = this.getSession().createQuery(LOAD_GROUPED_TOOL_SESSION_BY_GROUP2);
        query.setParameter("learner", (Object)learner);
        query.setParameter("activity", (Object)activity);
        GroupedToolSession groupedToolSession = (GroupedToolSession)query.uniqueResult();
        if (groupedToolSession != null) {
            return groupedToolSession;
        }
        query = this.getSession().createQuery(LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER);
        query.setParameter("learner", (Object)learner);
        query.setParameter("activity", (Object)activity);
        NonGroupedToolSession nonGroupedSession = (NonGroupedToolSession)query.uniqueResult();
        return nonGroupedSession;
    }

    public void saveToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().save((Object)toolSession);
    }

    public void removeToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().delete((Object)toolSession);
    }

    public void updateToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().update((Object)toolSession);
    }
}

