/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LamsCoreToolService
implements ILamsCoreToolService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(LamsCoreToolService.class);
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private ToolContentIDGenerator contentIDGenerator;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    public ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        ToolSession toolSession = this.toolSessionDAO.getToolSessionByLearner(learner, activity);
        if (toolSession == null) {
            toolSession = activity.createToolSessionForActivity(learner, lesson);
            this.toolSessionDAO.saveToolSession(toolSession);
            return toolSession;
        }
        return null;
    }

    public Set createToolSessions(Set learners, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        Iterator iter = learners.iterator();
        HashSet<ToolSession> newToolSessions = new HashSet<ToolSession>();
        while (iter.hasNext()) {
            User learner = (User)iter.next();
            ToolSession toolSession = this.createToolSession(learner, activity, lesson);
            if (toolSession == null) continue;
            newToolSessions.add(toolSession);
        }
        return newToolSessions;
    }

    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    public void notifyToolsToCreateSession(Long toolSessionId, ToolActivity activity) throws ToolException {
        if (this.isToolOnClasspath(activity)) {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity);
            sessionManager.createToolSession(toolSessionId, activity.getToolContentId());
        }
    }

    public Long notifyToolToCopyContent(ToolActivity toolActivity) throws DataMissingException, ToolException {
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
        if (this.isToolOnClasspath(toolActivity)) {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity);
            contentManager.copyToolContent(toolActivity.getToolContentId(), newToolcontentID);
            if (toolActivity.getDefineLater() != null && toolActivity.getDefineLater().booleanValue()) {
                contentManager.setAsDefineLater(newToolcontentID);
            }
            if (toolActivity.getRunOffline() != null && toolActivity.getRunOffline().booleanValue()) {
                contentManager.setAsRunOffline(newToolcontentID);
            }
        }
        return newToolcontentID;
    }

    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    public String getLearnerToolURLByMode(ToolActivity activity, User learner, ToolAccessMode accessMode) throws LamsToolServiceException {
        if (accessMode == ToolAccessMode.LEARNER) {
            return this.setupToolURLWithToolSession(activity, learner, WebUtil.appendParameterToURL(activity.getTool().getLearnerUrl(), "mode", ToolAccessMode.LEARNER.toString()));
        }
        if (accessMode == ToolAccessMode.TEACHER) {
            return this.setupToolURLWithToolSession(activity, learner, WebUtil.appendParameterToURL(activity.getTool().getLearnerUrl(), "mode", ToolAccessMode.TEACHER.toString()));
        }
        if (accessMode == ToolAccessMode.AUTHOR) {
            return this.setupToolURLWithToolSession(activity, learner, WebUtil.appendParameterToURL(activity.getTool().getLearnerUrl(), "mode", ToolAccessMode.AUTHOR.toString()));
        }
        throw new LamsToolServiceException("Unknown tool access mode:" + accessMode.toString());
    }

    public String setupToolURLWithToolSession(ToolActivity activity, User learner, String toolURL) throws LamsToolServiceException {
        ToolSession toolSession = this.getToolSessionByActivity(learner, activity);
        if (toolSession == null) {
            String error = "Unable to set up url as session does not exist. Activity " + (activity != null ? activity.getActivityId() + ":" + activity.getTitle() : "null") + " learner " + (learner != null ? learner.getUserId() + ":" + learner.getLogin() : "null");
            log.error((Object)error);
            throw new LamsToolServiceException(error);
        }
        return WebUtil.appendParameterToURL(toolURL, "toolSessionID", toolSession.getToolSessionId().toString());
    }

    public String setupToolURLWithToolContent(ToolActivity activity, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "toolContentID", activity.getToolContentId().toString());
    }

    private Object findToolService(ToolActivity toolActivity) {
        return this.context.getBean(toolActivity.getTool().getServiceName());
    }

    private boolean isToolOnClasspath(ToolActivity toolActivity) {
        String serviceName = toolActivity.getTool().getServiceName();
        if (serviceName == null) {
            return false;
        }
        return serviceName.equals("ImscpService") || serviceName.equals("nbService") || serviceName.equals("qaService") || serviceName.equals("mcService") || serviceName.equals("submitFilesService") || serviceName.equals("surveyService") || serviceName.equals("forumService");
    }
}

