/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.cache.ICacheManager;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IAuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;

public class UserManagementService
implements IUserManagementService {
    protected Logger log = Logger.getLogger(UserManagementService.class);
    private IUserDAO userDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IOrganisationTypeDAO organisationTypeDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    private IUserOrganisationRoleDAO userOrganisationRoleDAO;
    private IAuthenticationMethodDAO authenticationMethodDAO;
    protected IWorkspaceDAO workspaceDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected ICacheManager cacheManager;
    private FlashMessage flashMessage;
    private String[] userClassParts = null;

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationTypeDAO(IOrganisationTypeDAO organisationTypeDAO) {
        this.organisationTypeDAO = organisationTypeDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    public void setUserOrganisationRoleDAO(IUserOrganisationRoleDAO userOrganisationRoleDAO) {
        this.userOrganisationRoleDAO = userOrganisationRoleDAO;
    }

    public void setAuthenticationMethodDAO(IAuthenticationMethodDAO authenticationMethodDAO) {
        this.authenticationMethodDAO = authenticationMethodDAO;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public User getUserById(Integer userId) {
        User user;
        if (this.userClassParts == null) {
            this.userClassParts = this.cacheManager.getPartsFromClass(User.class);
        }
        if ((user = (User)this.cacheManager.getItem(this.userClassParts, (Object)userId)) == null && (user = this.userDAO.getUserById(userId)) != null) {
            this.cacheManager.addItem(this.userClassParts, (Object)userId, (Object)user);
        }
        return user;
    }

    public User getUserByLogin(String login) {
        return this.userDAO.getUserByLogin(login);
    }

    public Organisation getOrganisationById(Integer organisationId) {
        return this.organisationDAO.getOrganisationById(organisationId);
    }

    public OrganisationType getOrganisationTypeByName(String name) {
        return this.organisationTypeDAO.getOrganisationTypeByName(name);
    }

    public Organisation getBaseOrganisation(Organisation organisation) {
        if (organisation.getOrganisationType().getName().equals("ROOT ORGANISATION")) {
            return null;
        }
        if (organisation.getOrganisationType().getName().equals("BASE ORGANISATION")) {
            return organisation;
        }
        return this.getBaseOrganisation(organisation.getParentOrganisation());
    }

    public Role getRoleByName(String roleName) {
        return this.roleDAO.getRoleByName(roleName);
    }

    public UserOrganisationRole getUserOrganisationRole(String login, Integer organisationId, String roleName) {
        User user = this.userDAO.getUserByLogin(login);
        if (user == null) {
            return null;
        }
        UserOrganisation userOrganisation = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), organisationId);
        if (userOrganisation == null) {
            return null;
        }
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            return null;
        }
        return this.userOrganisationRoleDAO.getUserOrganisationRole(userOrganisation.getUserOrganisationId(), role.getRoleId());
    }

    public UserOrganisation getUserOrganisation(Integer userId, Integer organisationId) {
        return this.userOrganisationDAO.getUserOrganisation(userId, organisationId);
    }

    public List getAllAuthenticationMethods() {
        return this.authenticationMethodDAO.getAllAuthenticationMethods();
    }

    public AuthenticationMethod getAuthenticationMethodForUser(String login) {
        return this.authenticationMethodDAO.getAuthenticationMethodByUser(this.userDAO.getUserByLogin(login));
    }

    public AuthenticationMethod getAuthenticationMethodByName(String name) {
        return this.authenticationMethodDAO.getAuthenticationMethodByName(name);
    }

    public List getUserOrganisationsForUser(User user) {
        return this.userOrganisationDAO.getUserOrganisationsByUser(user);
    }

    public List getOrganisationsForUserByRole(User user, String roleName) {
        ArrayList<Organisation> list = new ArrayList<Organisation>();
        for (UserOrganisation userOrganisation : this.userOrganisationDAO.getUserOrganisationsByUser(user)) {
            for (UserOrganisationRole userOrgansiationRole : userOrganisation.getUserOrganisationRoles()) {
                if (!userOrgansiationRole.getRole().getName().equals(roleName)) continue;
                list.add(userOrgansiationRole.getUserOrganisation().getOrganisation());
            }
        }
        return list;
    }

    public List getChildOrganisations(Organisation parentOrg) {
        return this.organisationDAO.getChildOrganisations(parentOrg);
    }

    public List getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        UserOrganisation userOrg = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), orgId);
        if (userOrg == null) {
            return null;
        }
        for (UserOrganisationRole userOrgRole : this.userOrganisationRoleDAO.getUserOrganisationRoles(userOrg.getUserOrganisationId())) {
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    public List getUsersFromOrganisation(Integer orgId) {
        ArrayList<User> list = new ArrayList<User>();
        for (UserOrganisation userOrganisation : this.userOrganisationDAO.getUserOrganisationsByOrganisationId(orgId)) {
            list.add(userOrganisation.getUser());
        }
        return list;
    }

    public void createUser(User user) {
        this.userDAO.saveUser(user);
    }

    public void updateUser(User user) {
        this.userDAO.updateUser(user);
    }

    public void saveOrUpdateUser(User user) {
        this.userDAO.saveOrUpdateUser(user);
    }

    public void updatePassword(String login, String newPassword) {
        this.userDAO.updatePassword(login, newPassword);
    }

    public void removeUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.deleteUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateOrganisation(Organisation organisation) {
        this.organisationDAO.saveOrUpdateOrganisation(organisation);
    }

    public void saveOrUpdateUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateUserOrganisationRole(UserOrganisationRole userOrganisationRole) {
        this.userOrganisationRoleDAO.saveOrUpdateUserOrganisationRole(userOrganisationRole);
    }

    public void setUserManagementWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public Integer saveOrganisation(Organisation organisation, Integer userID) {
        Workspace workspace = this.createWorkspace(organisation.getName());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, userID, WorkspaceFolder.NORMAL);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        organisation.setWorkspace(workspace);
        this.organisationDAO.saveOrganisation(organisation);
        return organisation.getOrganisationId();
    }

    public Workspace createWorkspace(String name) {
        Workspace workspace = new Workspace(name);
        this.workspaceDAO.insert(workspace);
        return workspace;
    }

    public WorkspaceFolder createWorkspaceFolder(Workspace workspace, Integer userID, Integer workspaceFolderType) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(workspace.getName(), workspace.getWorkspaceId(), userID, new Date(), new Date(), workspaceFolderType);
        this.workspaceFolderDAO.insert(workspaceFolder);
        return workspaceFolder;
    }

    public Integer saveUser(User user, Integer roleID) {
        this.userDAO.saveUser(user);
        this.createUserOrganisation(user, roleID);
        Workspace workspace = this.createWorkspace(user.getLogin());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.NORMAL);
        WorkspaceFolder runSequencesFolder = this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.RUN_SEQUENCES);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        user.setWorkspace(workspace);
        this.userDAO.updateUser(user);
        return user.getUserId();
    }

    private Integer createUserOrganisation(User user, Integer roleID) {
        UserOrganisation userOrganisation = new UserOrganisation();
        userOrganisation.setOrganisation(user.getBaseOrganisation());
        userOrganisation.setUser(user);
        this.userOrganisationDAO.saveUserOrganisation(userOrganisation);
        userOrganisation.addUserOrganisationRole(this.createUserOrganisationRole(userOrganisation, roleID));
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
        return userOrganisation.getUserOrganisationId();
    }

    private UserOrganisationRole createUserOrganisationRole(UserOrganisation userOrganisation, Integer roleID) {
        UserOrganisationRole userOrganisationRole = new UserOrganisationRole();
        userOrganisationRole.setUserOrganisation(userOrganisation);
        userOrganisationRole.setRole(this.roleDAO.getRoleById(roleID));
        this.userOrganisationRoleDAO.saveUserOrganisationRole(userOrganisationRole);
        return userOrganisationRole;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public String getWDDXForOrganisationsForUserByRole(Integer userID, String roleName) throws IOException {
        User user = this.userDAO.getUserById(userID);
        Vector<OrganisationDTO> organisations = new Vector<OrganisationDTO>();
        if (user != null) {
            for (Organisation organisation : this.getOrganisationsForUserByRole(user, roleName)) {
                organisations.add(organisation.getOrganisationDTO());
            }
            this.flashMessage = new FlashMessage("getWDDXForOrganisationsForUserByRole", organisations);
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("getWDDXForOrganisationsForUserByRole", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getUsersFromOrganisationByRole(Integer organisationID, String roleName) throws IOException {
        Vector<UserDTO> users = new Vector<UserDTO>();
        Organisation organisation = this.organisationDAO.getOrganisationById(organisationID);
        if (organisation != null) {
            for (UserOrganisation userOrganisation : organisation.getUserOrganisations()) {
                for (UserOrganisationRole userOrganisationRole : userOrganisation.getUserOrganisationRoles()) {
                    if (!userOrganisationRole.getRole().getName().equals(roleName)) continue;
                    users.add(userOrganisation.getUser().getUserDTO());
                }
            }
            this.flashMessage = new FlashMessage("getUsersFromOrganisationByRole", users);
        } else {
            this.flashMessage = new FlashMessage("getUsersFromOrganisationByRole", "No such Organisation with an organisation_id of:" + organisationID + " exists", 1);
        }
        return this.flashMessage.serializeMessage();
    }
}

