/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.core;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.forum.core.FactoryException;
import org.lamsfoundation.lams.tool.forum.core.GenericObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GenericObjectFactoryImpl
implements GenericObjectFactory {
    protected static ApplicationContext applicationContext;
    protected static GenericObjectFactory genericObjectFactory;
    protected static Logger log;

    public static GenericObjectFactory getInstance() {
        if (genericObjectFactory == null) {
            genericObjectFactory = new GenericObjectFactoryImpl();
            GenericObjectFactoryImpl.addContext("/forumApplicationContext.xml");
        }
        return genericObjectFactory;
    }

    public static ApplicationContext addContext(String contextPath) {
        applicationContext = applicationContext == null ? new ClassPathXmlApplicationContext(contextPath) : new ClassPathXmlApplicationContext(new String[]{contextPath}, true, applicationContext);
        return applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public Object lookup(String binding) throws FactoryException {
        try {
            return this.getApplicationContext().getBean(binding);
        }
        catch (RuntimeException e) {
            throw new FactoryException("unable to locate object in container", e);
        }
    }

    public Object lookup(Class type) throws FactoryException {
        Object found = this.lookup(this.toFirstCharLowerCase(this.cutPackageFromName(type.getName())));
        return found;
    }

    protected String toFirstCharLowerCase(String name) {
        char[] chars = name.toCharArray();
        chars[0] = String.valueOf(chars[0]).toLowerCase().toCharArray()[0];
        return String.valueOf(chars);
    }

    protected String cutPackageFromName(String name) {
        if (name.indexOf(".") > -1) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    static {
        log = Logger.getLogger((Class)GenericObjectFactoryImpl.class);
    }
}

