/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.dao.hibernate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiDAO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiAttachment;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDAO
extends BaseDAO
implements IWikiDAO {
    private static final String FIND_FORUM_BY_CONTENTID = "from Wiki wiki where wiki.toolContentId=?";
    private static final String FIND_INSTRUCTION_FILE = "from " + WikiAttachment.class.getName() + " as i where tool_content_id=? and i.file_uuid=? and i.file_version_id=? and i.file_type=?";

    @Override
    public Wiki getByContentId(Long toolContentId) {
        List list = this.getHibernateTemplate().find(FIND_FORUM_BY_CONTENTID, (Object)toolContentId);
        if (list != null && list.size() > 0) {
            Wiki wiki = (Wiki)list.get(0);
            this.removeDuplicatePages(wiki);
            return wiki;
        }
        return null;
    }

    @Override
    public void saveOrUpdate(Wiki wiki) {
        this.removeDuplicatePages(wiki);
        this.getHibernateTemplate().saveOrUpdate((Object)wiki);
    }

    @Override
    public void deleteInstructionFile(Long toolContentId, Long uuid, Long versionId, String type) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (toolContentId != null && uuid != null && versionId != null && (list = this.getSession().createQuery(FIND_INSTRUCTION_FILE).setLong(0, toolContentId.longValue()).setLong(1, uuid.longValue()).setLong(2, versionId.longValue()).setString(3, type).list()) != null && list.size() > 0) {
            WikiAttachment file = (WikiAttachment)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)file);
            templ.flush();
        }
    }

    public void removeDuplicatePages(Wiki wiki) {
        Set<WikiPage> wikiPages = wiki.getWikiPages();
        if (wikiPages != null) {
            HashSet<WikiPage> wikiPagesCopy = new HashSet<WikiPage>(wikiPages);
            Iterator<WikiPage> it = wikiPages.iterator();
            while (it.hasNext()) {
                WikiPage page = it.next();
                if (!this.containsDuplicate(page, wikiPagesCopy)) continue;
                it.remove();
                wikiPagesCopy = new HashSet<WikiPage>(wikiPages);
            }
        }
    }

    private boolean containsDuplicate(WikiPage compPage, Set<WikiPage> wikiPages) {
        int count = 0;
        for (WikiPage page : wikiPages) {
            if (!page.getTitle().equals(compPage.getTitle())) continue;
            ++count;
        }
        return count > 1;
    }
}

