/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.dto;

import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.wiki.dto.WikiAttachmentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiSessionDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiAttachment;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDTO {
    private static Logger logger = Logger.getLogger(WikiDTO.class);
    public Long toolContentId;
    public String title;
    public String instructions;
    public String onlineInstructions;
    public String offlineInstructions;
    public boolean defineLater;
    public boolean contentInUse;
    public boolean lockOnFinish;
    private boolean allowLearnerCreatePages;
    private boolean allowLearnerInsertLinks;
    private boolean allowLearnerAttachImages;
    private boolean notifyUpdates;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private Integer minimumEdits;
    private Integer maximumEdits;
    public Set<WikiAttachmentDTO> onlineInstructionsFiles;
    public Set<WikiAttachmentDTO> offlineInstructionsFiles;
    public Set<WikiSessionDTO> sessionDTOs = new TreeSet<WikiSessionDTO>();
    public Long currentTab;

    public WikiDTO() {
    }

    public WikiDTO(Wiki wiki) {
        this.toolContentId = wiki.getToolContentId();
        this.title = wiki.getTitle();
        this.instructions = wiki.getInstructions();
        this.onlineInstructions = wiki.getOnlineInstructions();
        this.offlineInstructions = wiki.getOfflineInstructions();
        this.contentInUse = wiki.isContentInUse();
        this.lockOnFinish = wiki.isLockOnFinished();
        this.allowLearnerCreatePages = wiki.isAllowLearnerCreatePages();
        this.allowLearnerInsertLinks = wiki.isAllowLearnerInsertLinks();
        this.allowLearnerAttachImages = wiki.isAllowLearnerAttachImages();
        this.notifyUpdates = wiki.isNotifyUpdates();
        this.reflectOnActivity = wiki.isReflectOnActivity();
        this.reflectInstructions = wiki.getReflectInstructions();
        this.minimumEdits = wiki.getMinimumEdits();
        this.maximumEdits = wiki.getMaximumEdits();
        this.onlineInstructionsFiles = new TreeSet<WikiAttachmentDTO>();
        this.offlineInstructionsFiles = new TreeSet<WikiAttachmentDTO>();
        for (WikiAttachment att : wiki.getWikiAttachments()) {
            WikiAttachmentDTO attDTO;
            if (att.getFileType().equals("OFFLINE")) {
                attDTO = new WikiAttachmentDTO(att);
                this.offlineInstructionsFiles.add(attDTO);
                continue;
            }
            if (att.getFileType().equals("ONLINE")) {
                attDTO = new WikiAttachmentDTO(att);
                this.onlineInstructionsFiles.add(attDTO);
                continue;
            }
            logger.error((Object)("File with uid " + att.getFileUuid() + " contains invalid fileType: " + att.getFileType()));
        }
        for (WikiSession session : wiki.getWikiSessions()) {
            WikiSessionDTO sessionDTO = new WikiSessionDTO(session);
            this.sessionDTOs.add(sessionDTO);
        }
    }

    public Set<WikiSessionDTO> getSessionDTOs() {
        return this.sessionDTOs;
    }

    public void setSessionDTOs(Set<WikiSessionDTO> sessionDTOs) {
        this.sessionDTOs = sessionDTOs;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set<WikiAttachmentDTO> getOfflineInstructionsFiles() {
        return this.offlineInstructionsFiles;
    }

    public void setOfflineInstructionsFiles(Set<WikiAttachmentDTO> offlineInstructionsFiles) {
        this.offlineInstructionsFiles = offlineInstructionsFiles;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Set<WikiAttachmentDTO> getOnlineInstructionsFiles() {
        return this.onlineInstructionsFiles;
    }

    public void setOnlineInstructionsFiles(Set<WikiAttachmentDTO> onlineInstructionsFiles) {
        this.onlineInstructionsFiles = onlineInstructionsFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentID) {
        this.toolContentId = toolContentID;
    }

    public Boolean getContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(Boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isAllowLearnerCreatePages() {
        return this.allowLearnerCreatePages;
    }

    public void setAllowLearnerCreatePages(boolean allowLearnerCreatePages) {
        this.allowLearnerCreatePages = allowLearnerCreatePages;
    }

    public boolean isAllowLearnerInsertLinks() {
        return this.allowLearnerInsertLinks;
    }

    public void setAllowLearnerInsertLinks(boolean allowLearnerInsertLinks) {
        this.allowLearnerInsertLinks = allowLearnerInsertLinks;
    }

    public boolean isAllowLearnerAttachImages() {
        return this.allowLearnerAttachImages;
    }

    public void setAllowLearnerAttachImages(boolean allowLearnerAttachImages) {
        this.allowLearnerAttachImages = allowLearnerAttachImages;
    }

    public boolean isNotifyUpdates() {
        return this.notifyUpdates;
    }

    public void setNotifyUpdates(boolean notifyUpdates) {
        this.notifyUpdates = notifyUpdates;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public Integer getMinimumEdits() {
        return this.minimumEdits;
    }

    public void setMinimumEdits(Integer minimumEdits) {
        this.minimumEdits = minimumEdits;
    }

    public Integer getMaximumEdits() {
        return this.maximumEdits;
    }

    public void setMaximumEdits(Integer maximumEdits) {
        this.maximumEdits = maximumEdits;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isLockOnFinish() {
        return this.lockOnFinish;
    }

    public void setLockOnFinish(boolean lockOnFinish) {
        this.lockOnFinish = lockOnFinish;
    }

    public Long getCurrentTab() {
        return this.currentTab;
    }

    public void setCurrentTab(Long currentTab) {
        this.currentTab = currentTab;
    }
}

