/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.dto;

import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageDTO
implements Comparable<WikiPageDTO> {
    private Long uid;
    private String title;
    private String javaScriptTitle;
    private Boolean editable;
    private WikiPageContentDTO currentWikiContentDTO;

    public WikiPageDTO() {
    }

    public WikiPageDTO(WikiPage wikiPage) {
        this.uid = wikiPage.getUid();
        this.title = wikiPage.getTitle().trim();
        this.editable = wikiPage.getEditable();
        this.currentWikiContentDTO = new WikiPageContentDTO(wikiPage.getCurrentWikiContent());
        this.javaScriptTitle = this.javaScriptEscape(wikiPage.getTitle());
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public WikiPageContentDTO getCurrentWikiContentDTO() {
        return this.currentWikiContentDTO;
    }

    public String getJavaScriptTitle() {
        return this.javaScriptTitle;
    }

    public void setJavaScriptTitle(String javaScriptTitle) {
        this.javaScriptTitle = javaScriptTitle;
    }

    public void setCurrentWikiContentDTO(WikiPageContentDTO currentWikiContentDTO) {
        this.currentWikiContentDTO = currentWikiContentDTO;
    }

    @Override
    public int compareTo(WikiPageDTO wikiPageDTO) {
        return wikiPageDTO.getUid().compareTo(this.uid) * -1;
    }

    public String javaScriptEscape(String string) {
        String replaced = string.replaceAll("\n", "").replaceAll("'", "`").replaceAll("\"", "\\&quot;");
        return replaced;
    }
}

