/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.dto;

import java.util.Set;
import java.util.TreeSet;
import org.lamsfoundation.lams.tool.wiki.dto.WikiUserDTO;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiSessionDTO
implements Comparable {
    Long sessionID;
    String sessionName;
    Set<WikiUserDTO> userDTOs = new TreeSet<WikiUserDTO>();
    int numberOfLearners;
    int numberOfFinishedLearners;
    boolean reflectOnActivity;
    String contentFolderID;

    public WikiSessionDTO(WikiSession session) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.contentFolderID = session.getContentFolderID();
        this.numberOfFinishedLearners = 0;
        for (WikiUser user : session.getWikiUsers()) {
            WikiUserDTO userDTO = new WikiUserDTO(user);
            if (userDTO.getEntryUID() != null) {
                ++this.numberOfFinishedLearners;
            }
            this.userDTOs.add(userDTO);
        }
        this.numberOfLearners = this.userDTOs.size();
        this.reflectOnActivity = session.getWiki().isReflectOnActivity();
    }

    public WikiSessionDTO() {
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public int compareTo(Object o) {
        WikiSessionDTO toSession = (WikiSessionDTO)o;
        int returnValue = this.sessionName.compareTo(toSession.sessionName);
        if (returnValue == 0) {
            returnValue = this.sessionID.compareTo(toSession.sessionID);
        }
        return returnValue;
    }

    public Set<WikiUserDTO> getUserDTOs() {
        return this.userDTOs;
    }

    public void setUserDTOs(Set<WikiUserDTO> wikiUsers) {
        this.userDTOs = wikiUsers;
    }

    public int getNumberOfLearners() {
        return this.numberOfLearners;
    }

    public void setNumberOfLearners(int numberOfLearners) {
        this.numberOfLearners = numberOfLearners;
    }

    public int getNumberOfFinishedLearners() {
        return this.numberOfFinishedLearners;
    }

    public void setNumberOfFinishedLearners(int numberOfFinishedLearners) {
        this.numberOfFinishedLearners = numberOfFinishedLearners;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }
}

