/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.wiki.model.WikiAttachment;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiki
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 382787654329119829L;
    static Logger log = Logger.getLogger((String)Wiki.class.getName());
    private Long uid;
    private Date createDate;
    private Date updateDate;
    private Long createBy;
    private String title;
    private String instructions;
    private boolean runOffline;
    private boolean lockOnFinished;
    private boolean allowLearnerCreatePages;
    private boolean allowLearnerInsertLinks;
    private boolean allowLearnerAttachImages;
    private boolean notifyUpdates;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private Integer minimumEdits;
    private Integer maximumEdits;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean contentInUse;
    private boolean defineLater;
    private Long toolContentId;
    private Set<WikiAttachment> wikiAttachments;
    private Set<WikiSession> wikiSessions;
    private Set<WikiPage> wikiPages;
    private WikiPage mainPage;
    private IToolContentHandler toolContentHandler;

    public Wiki() {
    }

    public Wiki(Date createDate, Date updateDate, Long createBy, String title, String instructions, boolean runOffline, boolean lockOnFinished, boolean filteringEnabled, String filterKeywords, String onlineInstructions, String offlineInstructions, boolean contentInUse, boolean defineLater, Long toolContentId, Set<WikiAttachment> wikiAttachments, Set<WikiSession> wikiSessions, Set<WikiPage> wikiPages) {
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.createBy = createBy;
        this.title = title;
        this.instructions = instructions;
        this.runOffline = runOffline;
        this.lockOnFinished = lockOnFinished;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.contentInUse = contentInUse;
        this.defineLater = defineLater;
        this.toolContentId = toolContentId;
        this.wikiAttachments = wikiAttachments;
        this.wikiSessions = wikiSessions;
        this.wikiPages = wikiPages;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public boolean isAllowLearnerCreatePages() {
        return this.allowLearnerCreatePages;
    }

    public void setAllowLearnerCreatePages(boolean allowLearnerCreatePages) {
        this.allowLearnerCreatePages = allowLearnerCreatePages;
    }

    public boolean isAllowLearnerInsertLinks() {
        return this.allowLearnerInsertLinks;
    }

    public void setAllowLearnerInsertLinks(boolean allowLearnerInsertLinks) {
        this.allowLearnerInsertLinks = allowLearnerInsertLinks;
    }

    public boolean isAllowLearnerAttachImages() {
        return this.allowLearnerAttachImages;
    }

    public void setAllowLearnerAttachImages(boolean allowLearnerAttachImages) {
        this.allowLearnerAttachImages = allowLearnerAttachImages;
    }

    public boolean isNotifyUpdates() {
        return this.notifyUpdates;
    }

    public void setNotifyUpdates(boolean notifyUpdates) {
        this.notifyUpdates = notifyUpdates;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public Integer getMinimumEdits() {
        return this.minimumEdits;
    }

    public void setMinimumEdits(Integer minimumEdits) {
        this.minimumEdits = minimumEdits;
    }

    public Integer getMaximumEdits() {
        return this.maximumEdits;
    }

    public void setMaximumEdits(Integer maximumEdits) {
        this.maximumEdits = maximumEdits;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Set<WikiAttachment> getWikiAttachments() {
        return this.wikiAttachments;
    }

    public void setWikiAttachments(Set<WikiAttachment> wikiAttachments) {
        this.wikiAttachments = wikiAttachments;
    }

    public Set<WikiSession> getWikiSessions() {
        return this.wikiSessions;
    }

    public void setWikiSessions(Set<WikiSession> wikiSessions) {
        this.wikiSessions = wikiSessions;
    }

    public Set<WikiPage> getWikiPages() {
        return this.wikiPages;
    }

    public void setWikiPages(Set<WikiPage> wikiPages) {
        this.wikiPages = wikiPages;
    }

    public WikiPage getMainPage() {
        return this.mainPage;
    }

    public void setMainPage(WikiPage mainPage) {
        this.mainPage = mainPage;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" [");
        buffer.append("title").append("='").append(this.getTitle()).append("' ");
        buffer.append("instructions").append("='").append(this.getInstructions()).append("' ");
        buffer.append("toolContentId").append("='").append(this.getToolContentId()).append("' ");
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wiki)) {
            return false;
        }
        Wiki castOther = (Wiki)other;
        return this.getUid() == castOther.getUid() || this.getUid() != null && castOther.getUid() != null && this.getUid().equals(castOther.getUid());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getUid() == null ? 0 : this.getUid().hashCode());
        return result;
    }

    public static Wiki newInstance(Wiki fromContent, Long toContentId, IToolContentHandler wikiToolContentHandler) {
        Wiki toContent = new Wiki();
        fromContent.toolContentHandler = wikiToolContentHandler;
        toContent = (Wiki)fromContent.clone();
        toContent.setToolContentId(toContentId);
        toContent.setCreateDate(new Date());
        return toContent;
    }

    protected Object clone() {
        Wiki wiki = null;
        try {
            wiki = (Wiki)super.clone();
            wiki.setUid(null);
            if (this.wikiAttachments != null) {
                Iterator<WikiAttachment> iter = this.wikiAttachments.iterator();
                HashSet<WikiAttachment> set = new HashSet<WikiAttachment>();
                while (iter.hasNext()) {
                    WikiAttachment originalFile = iter.next();
                    WikiAttachment newFile = (WikiAttachment)originalFile.clone();
                    set.add(newFile);
                }
                wiki.wikiAttachments = set;
            }
            if (this.wikiPages != null) {
                HashSet<WikiPage> newPages = new HashSet<WikiPage>();
                for (WikiPage page : this.wikiPages) {
                    WikiPage newPage = (WikiPage)page.clone();
                    newPage.setParentWiki(wiki);
                    if (page.getTitle().equals(this.mainPage.getTitle())) {
                        wiki.setMainPage(page);
                    }
                    newPages.add(newPage);
                }
                wiki.setWikiPages(newPages);
            }
            wiki.setMainPage((WikiPage)wiki.getMainPage().clone());
            wiki.wikiSessions = new HashSet<WikiSession>();
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)("Error cloning " + Wiki.class));
        }
        return wiki;
    }

    public IToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }
}

