/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.service;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lamsfoundation.lams.tool.OutputFactory;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiOutputFactory
extends OutputFactory {
    protected static final String OUTPUT_NAME_LEARNER_NUM_EDITS = "output.learner.number.of.edits";
    protected static final String OUTPUT_NAME_LEARNER_NUM_ADDS = "output.learner.number.of.adds";

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object toolContentObject) throws ToolException {
        TreeMap<String, ToolOutputDefinition> definitionMap = new TreeMap<String, ToolOutputDefinition>();
        ToolOutputDefinition definition1 = this.buildRangeDefinition(OUTPUT_NAME_LEARNER_NUM_EDITS, new Long(0L), null);
        definitionMap.put(OUTPUT_NAME_LEARNER_NUM_EDITS, definition1);
        ToolOutputDefinition definition2 = this.buildRangeDefinition(OUTPUT_NAME_LEARNER_NUM_ADDS, new Long(0L), null);
        definitionMap.put(OUTPUT_NAME_LEARNER_NUM_ADDS, definition2);
        return definitionMap;
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, IWikiService wikiService, Long toolSessionId, Long learnerId) {
        TreeMap<String, ToolOutput> map = new TreeMap<String, ToolOutput>();
        if (names == null || names.contains(OUTPUT_NAME_LEARNER_NUM_EDITS)) {
            map.put(OUTPUT_NAME_LEARNER_NUM_EDITS, this.getNumEdits(wikiService, learnerId, toolSessionId));
        }
        if (names.contains(OUTPUT_NAME_LEARNER_NUM_ADDS)) {
            map.put(OUTPUT_NAME_LEARNER_NUM_ADDS, this.getNumAdds(wikiService, learnerId, toolSessionId));
        }
        return map;
    }

    public ToolOutput getToolOutput(String name, IWikiService wikiService, Long toolSessionId, Long learnerId) {
        if (name != null && name.equals(OUTPUT_NAME_LEARNER_NUM_EDITS)) {
            return this.getNumEdits(wikiService, learnerId, toolSessionId);
        }
        if (name != null && name.equals(OUTPUT_NAME_LEARNER_NUM_ADDS)) {
            return this.getNumAdds(wikiService, learnerId, toolSessionId);
        }
        return null;
    }

    private ToolOutput getNumEdits(IWikiService wikiService, Long learnerId, Long toolSessionId) {
        int num = wikiService.getEditsNum(learnerId, toolSessionId);
        return new ToolOutput(OUTPUT_NAME_LEARNER_NUM_EDITS, this.getI18NText(OUTPUT_NAME_LEARNER_NUM_EDITS, true), new Long(num));
    }

    private ToolOutput getNumAdds(IWikiService wikiService, Long learnerId, Long toolSessionId) {
        int num = wikiService.getAddsNum(learnerId, toolSessionId);
        return new ToolOutput(OUTPUT_NAME_LEARNER_NUM_EDITS, this.getI18NText(OUTPUT_NAME_LEARNER_NUM_EDITS, true), new Long(num));
    }
}

