/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiAttachmentDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiPageContentDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiPageDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiSessionDAO;
import org.lamsfoundation.lams.tool.wiki.dao.IWikiUserDAO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiAttachment;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiPageContent;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiOutputFactory;
import org.lamsfoundation.lams.tool.wiki.util.WikiException;
import org.lamsfoundation.lams.tool.wiki.util.WikiToolContentHandler;
import org.lamsfoundation.lams.tool.wiki.util.diff.Diff;
import org.lamsfoundation.lams.tool.wiki.util.diff.Difference;
import org.lamsfoundation.lams.tool.wiki.web.forms.WikiPageForm;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiService
implements ToolSessionManager,
ToolContentManager,
IWikiService,
ToolContentImport102Manager {
    static Logger logger = Logger.getLogger((String)WikiService.class.getName());
    private IWikiDAO wikiDAO = null;
    private IWikiPageDAO wikiPageDAO = null;
    private IWikiPageContentDAO wikiPageContentDAO = null;
    private IWikiSessionDAO wikiSessionDAO = null;
    private IWikiUserDAO wikiUserDAO = null;
    private IWikiAttachmentDAO wikiAttachmentDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler wikiToolContentHandler = null;
    private IRepositoryService repositoryService = null;
    private IAuditService auditService = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;
    private WikiOutputFactory wikiOutputFactory;
    private IEventNotificationService eventNotificationService;
    private MessageService messageService;
    private ILessonService lessonService;

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method createToolSession: toolSessionId = " + toolSessionId + " toolSessionName = " + toolSessionName + " toolContentId = " + toolContentId));
        }
        WikiSession session = new WikiSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Wiki wiki = this.wikiDAO.getByContentId(toolContentId);
        session.setWiki(wiki);
        session.setContentFolderID(FileUtil.generateUniqueContentFolderID());
        HashSet<WikiPage> sessionWikiPages = new HashSet<WikiPage>();
        for (WikiPage childPage : wiki.getWikiPages()) {
            if (childPage.getWikiSession() != null) continue;
            WikiPage newChildPage = (WikiPage)childPage.clone();
            this.wikiPageDAO.saveOrUpdate(newChildPage);
            WikiPageContent newPageContent = (WikiPageContent)childPage.getCurrentWikiContent().clone();
            newPageContent.setWikiPage(newChildPage);
            this.wikiPageContentDAO.saveOrUpdate(newPageContent);
            newChildPage.setCurrentWikiContent(newPageContent);
            newChildPage.setParentWiki(wiki);
            newChildPage.setWikiSession(session);
            newChildPage.getWikiContentVersions().add(newPageContent);
            if (newChildPage.getTitle().equals(wiki.getMainPage().getTitle())) {
                session.setMainPage(newChildPage);
            }
            sessionWikiPages.add(newChildPage);
        }
        session.setWikiPages(sessionWikiPages);
        this.wikiSessionDAO.saveOrUpdate(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.wikiSessionDAO.deleteBySessionID(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        this.wikiOutputFactory = this.getWikiOutputFactory();
        WikiSession session = this.getSessionBySessionId(toolSessionId);
        if (session == null) {
            return null;
        }
        return this.wikiOutputFactory.getToolOutput(names, (IWikiService)this, toolSessionId, learnerId);
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        this.wikiOutputFactory = this.getWikiOutputFactory();
        WikiSession session = this.getSessionBySessionId(toolSessionId);
        if (session == null) {
            return null;
        }
        return this.wikiOutputFactory.getToolOutput(name, (IWikiService)this, toolSessionId, learnerId);
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        this.wikiOutputFactory = this.getWikiOutputFactory();
        Wiki wiki = this.getWikiByContentId(toolContentId);
        if (wiki == null) {
            wiki = this.getDefaultContent();
        }
        return this.wikiOutputFactory.getToolOutputDefinitions(wiki);
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method copyToolContent: fromContentId=" + fromContentId + " toContentId=" + toContentId));
        }
        if (toContentId == null) {
            String error = "Failed to copy tool content: toContentID is null";
            throw new ToolException(error);
        }
        Wiki fromContent = null;
        if (fromContentId != null) {
            fromContent = this.wikiDAO.getByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultContent();
        }
        Wiki toContent = Wiki.newInstance(fromContent, toContentId, this.wikiToolContentHandler);
        this.insertUnsavedWikiContent(toContent);
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Wiki wiki = this.wikiDAO.getByContentId(toolContentId);
        if (wiki == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        wiki.setDefineLater(value);
        this.wikiDAO.saveOrUpdate(wiki);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Wiki wiki = this.wikiDAO.getByContentId(toolContentId);
        if (wiki == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        wiki.setRunOffline(value);
        this.wikiDAO.saveOrUpdate(wiki);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Wiki wiki = this.wikiDAO.getByContentId(toolContentId);
        if (wiki == null) {
            wiki = this.getDefaultContent();
        }
        if (wiki == null) {
            throw new DataMissingException("Unable to find default content for the wiki tool");
        }
        wiki = Wiki.newInstance(wiki, toolContentId, null);
        wiki.setToolContentHandler(null);
        wiki.setWikiSessions(null);
        Set<WikiPage> wikiPages = wiki.getWikiPages();
        for (WikiPage page : wikiPages) {
            page.setParentWiki(null);
            page.setWikiContentVersions(null);
            page.setWikiSession(null);
            WikiPageContent content = page.getCurrentWikiContent();
            content.setWikiPage(null);
            content.setEditDate(null);
            content.setEditor(null);
            page.setCurrentWikiContent(content);
        }
        WikiPage mainPage = new WikiPage();
        mainPage.setTitle(wiki.getMainPage().getTitle());
        wiki.setMainPage(mainPage);
        Set<WikiAttachment> atts = wiki.getWikiAttachments();
        for (WikiAttachment att : atts) {
            att.setWiki(null);
        }
        try {
            this.exportContentService.registerFileClassForExport(WikiAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)wiki, this.wikiToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(WikiAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.wikiToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Wiki)) {
                throw new ImportToolContentException("Import Wiki tool content failed. Deserialized object is " + toolPOJO);
            }
            Wiki wiki = (Wiki)toolPOJO;
            wiki.setToolContentId(toolContentId);
            wiki.setCreateBy(new Long(newUserUid.longValue()));
            for (WikiPage wikiPage : wiki.getWikiPages()) {
                String title = wikiPage.getTitle();
                title = title.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
                wikiPage.setTitle(title);
            }
            this.insertUnsavedWikiContent(wiki);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    @Override
    public String comparePages(String old, String current) {
        Object[] oldArray = old.replaceAll("[\\t\\n\\r]", "").split("<div>");
        Object[] currentArray = current.replaceAll("[\\t\\n\\r]", "").split("<div>");
        Diff diff = new Diff(oldArray, currentArray);
        List diffOut = diff.diff();
        LinkedList<Object> result = new LinkedList<Object>(Arrays.asList(currentArray));
        int resultOffset = 0;
        for (Difference difference : diffOut) {
            int n;
            if (difference.getDeletedEnd() == -1) {
                for (n = difference.getAddedStart(); n <= difference.getAddedEnd(); ++n) {
                    result.set(n + resultOffset, "<div style='background-color:#99FFCC; width: 90%;'> " + (String)currentArray[n]);
                }
                continue;
            }
            if (difference.getAddedEnd() == -1) {
                for (n = difference.getDeletedStart(); n <= difference.getDeletedEnd(); ++n) {
                    if (result.size() > n + resultOffset) {
                        result.add(n + resultOffset, "<div style='background-color:#FF9999; width: 90%;'>" + (String)oldArray[n]);
                    } else {
                        result.add("<div style='background-color:#FF9999; width: 90%;'>" + (String)oldArray[n]);
                    }
                    ++resultOffset;
                }
                continue;
            }
            for (n = difference.getAddedStart(); n <= difference.getAddedEnd(); ++n) {
                result.set(n + resultOffset, "<div style='background-color:#99FFCC; width: 90%;'>" + (String)currentArray[n]);
            }
            for (n = difference.getDeletedStart(); n <= difference.getDeletedEnd(); ++n) {
                if (result.size() > n + resultOffset) {
                    result.add(n + resultOffset, "<div style='background-color:#FF9999; width: 90%;'>" + (String)oldArray[n]);
                } else {
                    result.add("<div style='background-color:#FF9999; width: 90%;'>" + (String)oldArray[n]);
                }
                ++resultOffset;
            }
        }
        StringBuffer retBuf = new StringBuffer();
        for (String string : result) {
            String string2 = string.replaceAll("[//r][//n][//t]", "");
            if (!string2.startsWith("<div")) {
                retBuf.append("<div>");
            }
            retBuf.append(string2);
            if (string2.contains("</div>")) continue;
            retBuf.append("</div>");
        }
        logger.debug((Object)"Result:");
        logger.debug((Object)retBuf);
        return retBuf.toString();
    }

    @Override
    public Long getDefaultContentIdBySignature(String toolSignature) {
        Long toolContentId = null;
        toolContentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (toolContentId == null) {
            String error = "Could not retrieve default content id for this tool";
            logger.error((Object)error);
            throw new WikiException(error);
        }
        return toolContentId;
    }

    @Override
    public Wiki getDefaultContent() {
        Long defaultContentID = this.getDefaultContentIdBySignature("lawiki10");
        Wiki defaultContent = this.getWikiByContentId(defaultContentID);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            logger.error((Object)error);
            throw new WikiException(error);
        }
        return defaultContent;
    }

    @Override
    public Wiki copyDefaultContent(Long newContentID) {
        if (newContentID == null) {
            String error = "Cannot copy the Wiki tools default content: + newContentID is null";
            logger.error((Object)error);
            throw new WikiException(error);
        }
        Wiki defaultContent = this.getDefaultContent();
        Wiki newContent = Wiki.newInstance(defaultContent, newContentID, this.wikiToolContentHandler);
        this.insertUnsavedWikiContent(newContent);
        return newContent;
    }

    private Wiki insertUnsavedWikiContent(Wiki wiki) {
        this.wikiDAO.saveOrUpdate(wiki);
        for (WikiPage wikiPage : wiki.getWikiPages()) {
            WikiPageContent currentContent = wikiPage.getCurrentWikiContent();
            currentContent.setEditDate(new Date());
            this.wikiPageContentDAO.saveOrUpdate(currentContent);
            currentContent.setWikiPage(wikiPage);
            wikiPage.setCurrentWikiContent(currentContent);
            this.wikiPageDAO.saveOrUpdate(wikiPage);
            if (wiki.getMainPage().getTitle() == wikiPage.getTitle()) {
                wiki.setMainPage(wikiPage);
            }
            wiki.getWikiPages().add(wikiPage);
        }
        for (WikiPage wikiPage : wiki.getWikiPages()) {
            wikiPage.setParentWiki(wiki);
            this.wikiPageDAO.saveOrUpdate(wikiPage);
        }
        return wiki;
    }

    @Override
    public Wiki getWikiByContentId(Long toolContentID) {
        Wiki wiki = this.wikiDAO.getByContentId(toolContentID);
        if (wiki == null) {
            logger.debug((Object)("Could not find the content with toolContentID:" + toolContentID));
        }
        return wiki;
    }

    @Override
    public WikiSession getSessionBySessionId(Long toolSessionId) {
        WikiSession wikiSession = this.wikiSessionDAO.getBySessionId(toolSessionId);
        if (wikiSession == null) {
            logger.debug((Object)("Could not find the wiki session with toolSessionID:" + toolSessionId));
        }
        return wikiSession;
    }

    @Override
    public WikiUser getUserByUserIdAndSessionId(Long userId, Long toolSessionId) {
        return this.wikiUserDAO.getByUserIdAndSessionId(userId, toolSessionId);
    }

    public WikiUser getUserByLoginNameAndSessionId(String loginName, Long toolSessionId) {
        return this.wikiUserDAO.getByLoginNameAndSessionId(loginName, toolSessionId);
    }

    @Override
    public WikiUser getUserByUID(Long uid) {
        return this.wikiUserDAO.getByUID(uid);
    }

    @Override
    public WikiAttachment uploadFileToContent(Long toolContentId, FormFile file, String type) {
        if (file == null || StringUtils.isEmpty((String)file.getFileName())) {
            throw new WikiException("Could not find upload file: " + file);
        }
        NodeKey nodeKey = this.processFile(file, type);
        WikiAttachment attachment = new WikiAttachment(nodeKey.getVersion(), type, file.getFileName(), nodeKey.getUuid(), new Date());
        return attachment;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws WikiException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new WikiException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void updateWikiPage(WikiPageForm wikiPageForm, WikiPage wikiPage, WikiUser user) {
        if (wikiPage == null) {
            throw new WikiException("Could not find wiki page to update");
        }
        WikiPageContent wikiPageContent = new WikiPageContent();
        wikiPageContent.setBody(wikiPageForm.getWikiBody());
        wikiPageContent.setEditDate(new Date());
        wikiPageContent.setEditor(user);
        wikiPageContent.setVersion(wikiPage.getCurrentWikiContent().getVersion() + 1L);
        wikiPageContent.setWikiPage(wikiPage);
        this.wikiPageContentDAO.saveOrUpdate(wikiPageContent);
        wikiPage.setTitle(wikiPageForm.getTitle());
        wikiPage.setEditable(wikiPageForm.getIsEditable());
        wikiPage.setCurrentWikiContent(wikiPageContent);
        wikiPage.getWikiContentVersions().add(wikiPageContent);
        wikiPage.setEditable(wikiPageForm.getIsEditable());
        this.wikiPageContentDAO.saveOrUpdate(wikiPageContent);
        if (user != null) {
            user.setWikiEdits(user.getWikiEdits() + 1);
            this.wikiUserDAO.saveOrUpdate(user);
        }
    }

    @Override
    public Long insertWikiPage(WikiPageForm wikiPageForm, Wiki wiki, WikiUser user, WikiSession session) {
        WikiPage wikiPage = new WikiPage();
        wikiPage.setEditable(wikiPageForm.getIsEditable());
        wikiPage.setParentWiki(wiki);
        wikiPage.setTitle(wikiPageForm.getNewPageTitle());
        wikiPage.setEditable(wikiPageForm.getNewPageIsEditable());
        wikiPage.setAddedBy(user);
        wikiPage.setWikiContentVersions(new HashSet<WikiPageContent>());
        wikiPage.setWikiSession(session);
        this.wikiPageDAO.saveOrUpdate(wikiPage);
        WikiPageContent wikiPageContent = new WikiPageContent();
        wikiPageContent.setBody(wikiPageForm.getNewPageWikiBody());
        wikiPageContent.setEditDate(new Date());
        wikiPageContent.setEditor(user);
        wikiPageContent.setVersion(new Long(1L));
        wikiPageContent.setWikiPage(wikiPage);
        this.wikiPageContentDAO.saveOrUpdate(wikiPageContent);
        wikiPage.setCurrentWikiContent(wikiPageContent);
        wikiPage.getWikiContentVersions().add(wikiPageContent);
        this.wikiPageDAO.saveOrUpdate(wikiPage);
        if (user != null) {
            user.setWikiEdits(user.getWikiEdits() + 1);
            this.wikiUserDAO.saveOrUpdate(user);
        }
        return wikiPage.getUid();
    }

    @Override
    public void deleteWikiPage(WikiPage wikiPage) {
        this.wikiPageDAO.delete(wikiPage);
    }

    @Override
    public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type) {
        this.wikiDAO.deleteInstructionFile(contentID, uuid, versionID, type);
    }

    @Override
    public void saveOrUpdateWiki(Wiki wiki) {
        this.wikiDAO.saveOrUpdate(wiki);
    }

    @Override
    public void saveOrUpdateWikiPage(WikiPage wikiPage) {
        this.wikiPageDAO.saveOrUpdate(wikiPage);
    }

    @Override
    public WikiPage getWikiPageByWikiAndTitle(Wiki wiki, String title) {
        return this.wikiPageDAO.getByWikiAndTitle(wiki, title);
    }

    @Override
    public WikiPage getWikiBySessionAndTitle(WikiSession wikiSession, String title) {
        return this.wikiPageDAO.getBySessionAndTitle(wikiSession, title);
    }

    @Override
    public WikiPage getWikiPageByUid(Long uid) {
        List list = this.wikiPageDAO.findByProperty(WikiPage.class, "uid", uid);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (WikiPage)list.get(0);
    }

    @Override
    public WikiPageContent getWikiPageContent(Long uid) {
        List list = this.wikiPageContentDAO.findByProperty(WikiPageContent.class, "uid", uid);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (WikiPageContent)list.get(0);
    }

    @Override
    public void saveOrUpdateWikiPageContent(WikiPageContent wikiPageContent) {
        this.wikiPageContentDAO.saveOrUpdate(wikiPageContent);
    }

    @Override
    public void saveOrUpdateWikiSession(WikiSession wikiSession) {
        this.wikiSessionDAO.saveOrUpdate(wikiSession);
    }

    @Override
    public void saveOrUpdateWikiUser(WikiUser wikiUser) {
        this.wikiUserDAO.saveOrUpdate(wikiUser);
    }

    @Override
    public WikiUser createWikiUser(UserDTO user, WikiSession wikiSession) {
        WikiUser wikiUser = new WikiUser(user, wikiSession);
        this.saveOrUpdateWikiUser(wikiUser);
        return wikiUser;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private NodeKey processFile(FormFile file, String type) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getWikiToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), type);
            }
            catch (InvalidParameterException e) {
                throw new WikiException("InvalidParameterException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new WikiException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new WikiException("RepositoryCheckedException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new WikiException("IOException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws WikiException {
        SimpleCredentials credentials = new SimpleCredentials(WikiToolContentHandler.repositoryUser, WikiToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, WikiToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new WikiException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new WikiException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new WikiException("Login failed." + e.getMessage());
        }
    }

    @Override
    public int getEditsNum(Long learnerId, Long toolSessionId) {
        WikiUser wikiUser = this.getUserByUserIdAndSessionId(learnerId, toolSessionId);
        WikiSession wikiSession = this.getSessionBySessionId(toolSessionId);
        int edits = 0;
        for (WikiPage wikiPage : wikiSession.getWikiPages()) {
            for (WikiPageContent wikiPageContent : wikiPage.getWikiContentVersions()) {
                if (wikiPageContent.getEditor() == null || !wikiPageContent.getEditor().getUid().equals(wikiUser.getUid())) continue;
                ++edits;
            }
        }
        return edits;
    }

    @Override
    public int getAddsNum(Long learnerId, Long toolSessionId) {
        WikiUser wikiUser = this.getUserByUserIdAndSessionId(learnerId, toolSessionId);
        WikiSession wikiSession = this.getSessionBySessionId(toolSessionId);
        int adds = 0;
        for (WikiPage wikiPage : wikiSession.getWikiPages()) {
            if (wikiPage.getAddedBy() == null || !wikiPage.getAddedBy().getUid().equals(wikiUser.getUid())) continue;
            ++adds;
        }
        return adds;
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Wiki wiki = new Wiki();
        wiki.setContentInUse(Boolean.FALSE);
        wiki.setCreateBy(new Long(user.getUserID().longValue()));
        wiki.setCreateDate(now);
        wiki.setDefineLater(Boolean.FALSE);
        wiki.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        wiki.setLockOnFinished(Boolean.TRUE);
        wiki.setOfflineInstructions(null);
        wiki.setOnlineInstructions(null);
        wiki.setRunOffline(Boolean.FALSE);
        wiki.setTitle((String)importValues.get("title"));
        wiki.setToolContentId(toolContentId);
        wiki.setUpdateDate(now);
        wiki.setAllowLearnerAttachImages(Boolean.TRUE);
        wiki.setAllowLearnerCreatePages(Boolean.TRUE);
        wiki.setAllowLearnerInsertLinks(Boolean.TRUE);
        wiki.setReflectOnActivity(Boolean.FALSE);
        wiki.setReflectInstructions(null);
        wiki.setMaximumEdits(0);
        wiki.setMinimumEdits(0);
        this.wikiDAO.saveOrUpdate(wiki);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        logger.warn((Object)"Setting the reflective field on a wiki. This doesn't make sense as the wiki is for reflection and we don't reflect on reflection!");
        Wiki wiki = this.getWikiByContentId(toolContentId);
        if (wiki == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        wiki.setInstructions(description);
    }

    public IWikiAttachmentDAO getWikiAttachmentDAO() {
        return this.wikiAttachmentDAO;
    }

    public void setWikiAttachmentDAO(IWikiAttachmentDAO attachmentDAO) {
        this.wikiAttachmentDAO = attachmentDAO;
    }

    public IWikiDAO getWikiDAO() {
        return this.wikiDAO;
    }

    public void setWikiDAO(IWikiDAO wikiDAO) {
        this.wikiDAO = wikiDAO;
    }

    public IWikiPageDAO getWikiPageDAO() {
        return this.wikiPageDAO;
    }

    public void setWikiPageDAO(IWikiPageDAO wikiPageDAO) {
        this.wikiPageDAO = wikiPageDAO;
    }

    public IWikiPageContentDAO getWikiPageContentDAO() {
        return this.wikiPageContentDAO;
    }

    public void setWikiPageContentDAO(IWikiPageContentDAO wikiPageContentDAO) {
        this.wikiPageContentDAO = wikiPageContentDAO;
    }

    public IToolContentHandler getWikiToolContentHandler() {
        return this.wikiToolContentHandler;
    }

    public void setWikiToolContentHandler(IToolContentHandler wikiToolContentHandler) {
        this.wikiToolContentHandler = wikiToolContentHandler;
    }

    public IWikiSessionDAO getWikiSessionDAO() {
        return this.wikiSessionDAO;
    }

    public void setWikiSessionDAO(IWikiSessionDAO sessionDAO) {
        this.wikiSessionDAO = sessionDAO;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IWikiUserDAO getWikiUserDAO() {
        return this.wikiUserDAO;
    }

    public void setWikiUserDAO(IWikiUserDAO userDAO) {
        this.wikiUserDAO = userDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public WikiOutputFactory getWikiOutputFactory() {
        if (this.wikiOutputFactory == null) {
            this.wikiOutputFactory = new WikiOutputFactory();
        }
        return this.wikiOutputFactory;
    }

    public void setWikiOutputFactory(WikiOutputFactory wikiOutputFactory) {
        this.wikiOutputFactory = wikiOutputFactory;
    }

    @Override
    public IEventNotificationService getEventNotificationService() {
        return this.eventNotificationService;
    }

    public void setEventNotificationService(IEventNotificationService eventNotificationService) {
        this.eventNotificationService = eventNotificationService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public String getLocalisedMessage(String key, Object[] args) {
        return this.messageService.getMessage(key, args);
    }

    @Override
    public List<User> getMonitorsByToolSessionId(Long sessionId) {
        return this.getLessonService().getMonitorsByToolSessionId(sessionId);
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

