/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.actions;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiAttachment;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiPageContent;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.web.actions.WikiPageAction;
import org.lamsfoundation.lams.tool.wiki.web.forms.AuthoringForm;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends WikiPageAction {
    private static Logger logger = Logger.getLogger(AuthoringAction.class);
    public IWikiService wikiService;
    private static final String KEY_TOOL_CONTENT_ID = "toolContentID";
    private static final String KEY_CONTENT_FOLDER_ID = "contentFolderID";
    private static final String KEY_MODE = "mode";
    private static final String KEY_ONLINE_FILES = "onlineFiles";
    private static final String KEY_OFFLINE_FILES = "offlineFiles";
    private static final String KEY_UNSAVED_ONLINE_FILES = "unsavedOnlineFiles";
    private static final String KEY_UNSAVED_OFFLINE_FILES = "unsavedOfflineFiles";
    private static final String KEY_DELETED_FILES = "deletedFiles";

    @Override
    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Wiki wiki;
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)KEY_TOOL_CONTENT_ID));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)KEY_CONTENT_FOLDER_ID);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)KEY_MODE, (boolean)true);
        AuthoringForm authForm = (AuthoringForm)form;
        Long currentPageUid = authForm.getCurrentWikiPageId();
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        if ((wiki = this.wikiService.getWikiByContentId(toolContentID)) == null) {
            wiki = this.wikiService.copyDefaultContent(toolContentID);
            wiki.setCreateDate(new Date());
            this.wikiService.saveOrUpdateWiki(wiki);
        }
        if (mode != null && mode.isTeacher()) {
            wiki.setDefineLater(true);
            this.wikiService.saveOrUpdateWiki(wiki);
        }
        this.updateAuthForm(authForm, wiki);
        WikiPageDTO mainPageDTO = new WikiPageDTO(wiki.getMainPage());
        request.setAttribute("mainWikiPage", (Object)mainPageDTO);
        WikiPage currentWikiPage = null;
        currentWikiPage = currentPageUid != null ? this.wikiService.getWikiPageByUid(currentPageUid) : wiki.getMainPage();
        WikiPageDTO currentPageDTO = new WikiPageDTO(currentWikiPage);
        request.setAttribute("currentWikiPage", (Object)currentPageDTO);
        authForm.setIsEditable(currentPageDTO.getEditable());
        TreeSet<WikiPageContentDTO> currentWikiPageHistoryDTOs = new TreeSet<WikiPageContentDTO>();
        for (WikiPageContent wikiPageContentHistoryItem : currentWikiPage.getWikiContentVersions()) {
            currentWikiPageHistoryDTOs.add(new WikiPageContentDTO(wikiPageContentHistoryItem));
        }
        request.setAttribute("wikiPageContentHistory", currentWikiPageHistoryDTOs);
        TreeSet<WikiPageDTO> wikiPageDTOs = new TreeSet<WikiPageDTO>();
        for (WikiPage wikiPage : wiki.getWikiPages()) {
            wikiPageDTOs.add(new WikiPageDTO(wikiPage));
        }
        request.setAttribute("wikiPages", wikiPageDTOs);
        SessionMap<String, Object> map = this.createSessionMap(wiki, this.getAccessMode(request), contentFolderID, toolContentID);
        authForm.setSessionMapID(map.getSessionID());
        request.getSession().setAttribute(map.getSessionID(), map);
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    @Override
    protected ActionForward returnToWiki(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long currentWikiPageId) throws Exception {
        AuthoringForm authForm = (AuthoringForm)form;
        authForm.setCurrentWikiPageId(currentWikiPageId);
        return this.unspecified(mapping, authForm, request, response);
    }

    @Override
    public WikiUser getCurrentUser(Long toolSessionId) {
        return null;
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        Wiki wiki = this.wikiService.getWikiByContentId((Long)map.get((Object)KEY_TOOL_CONTENT_ID));
        ToolAccessMode mode = (ToolAccessMode)map.get((Object)KEY_MODE);
        this.updateWiki(wiki, authForm, mode);
        Set<WikiAttachment> attachments = wiki.getWikiAttachments();
        if (attachments == null) {
            attachments = new HashSet<WikiAttachment>();
        }
        for (WikiAttachment att : this.getAttList(KEY_DELETED_FILES, map)) {
            attachments.remove(att);
        }
        attachments.addAll(this.getAttList(KEY_UNSAVED_ONLINE_FILES, map));
        attachments.addAll(this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map));
        wiki.setWikiAttachments(attachments);
        wiki.setUpdateDate(new Date());
        wiki.setDefineLater(false);
        this.wikiService.saveOrUpdateWiki(wiki);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        authForm.setSessionMapID(map.getSessionID());
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward deleteOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward deleteOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward removeUnsavedOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward removeUnsavedOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        List<WikiAttachment> savedFiles;
        List<WikiAttachment> unsavedFiles;
        FormFile file;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        if (StringUtils.equals((String)"OFFLINE", (String)type)) {
            file = authForm.getOfflineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map);
            savedFiles = this.getAttList(KEY_OFFLINE_FILES, map);
        } else {
            file = authForm.getOnlineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
            savedFiles = this.getAttList(KEY_ONLINE_FILES, map);
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            request.setAttribute("sessionMap", map);
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        if (file.getFileName().length() != 0) {
            WikiAttachment newAtt = this.wikiService.uploadFileToContent((Long)map.get((Object)KEY_TOOL_CONTENT_ID), file, type);
            Iterator<WikiAttachment> iter = savedFiles.iterator();
            while (iter.hasNext()) {
                WikiAttachment currAtt = iter.next();
                if (!StringUtils.equals((String)currAtt.getFileName(), (String)newAtt.getFileName()) || !StringUtils.equals((String)currAtt.getFileType(), (String)newAtt.getFileType())) continue;
                this.getAttList(KEY_DELETED_FILES, map).add(currAtt);
                iter.remove();
                break;
            }
            unsavedFiles.add(newAtt);
            request.setAttribute("sessionMap", map);
            request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        }
        return mapping.findForward("success");
    }

    private ActionForward deleteFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<WikiAttachment> fileList = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_OFFLINE_FILES, map) : this.getAttList(KEY_ONLINE_FILES, map);
        Iterator<WikiAttachment> iter = fileList.iterator();
        while (iter.hasNext()) {
            WikiAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.getAttList(KEY_DELETED_FILES, map).add(att);
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private ActionForward removeUnsaved(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<WikiAttachment> unsavedFiles = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map) : this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
        Iterator<WikiAttachment> iter = unsavedFiles.iterator();
        while (iter.hasNext()) {
            WikiAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.wikiService.deleteFromRepository(att.getFileUuid(), att.getFileVersionId());
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private void updateWiki(Wiki wiki, AuthoringForm authForm, ToolAccessMode mode) {
        WikiPage mainPage = wiki.getMainPage();
        WikiPageContent content = mainPage.getCurrentWikiContent();
        wiki.setMainPage(mainPage);
        if (mode.isAuthor()) {
            wiki.setOfflineInstructions(authForm.getOfflineInstruction());
            wiki.setOnlineInstructions(authForm.getOnlineInstruction());
            wiki.setLockOnFinished(authForm.isLockOnFinished());
            wiki.setAllowLearnerAttachImages(authForm.isAllowLearnerAttachImages());
            wiki.setAllowLearnerCreatePages(authForm.isAllowLearnerCreatePages());
            wiki.setAllowLearnerInsertLinks(authForm.isAllowLearnerInsertLinks());
            wiki.setReflectOnActivity(authForm.isReflectOnActivity());
            wiki.setReflectInstructions(authForm.getReflectInstructions());
            wiki.setNotifyUpdates(authForm.isNotifyUpdates());
            wiki.setMaximumEdits(authForm.getMaximumEdits());
            wiki.setMinimumEdits(authForm.getMinimumEdits());
        }
    }

    private void updateAuthForm(AuthoringForm authForm, Wiki wiki) {
        authForm.setOnlineInstruction(wiki.getOnlineInstructions());
        authForm.setOfflineInstruction(wiki.getOfflineInstructions());
        authForm.setLockOnFinished(wiki.isLockOnFinished());
        authForm.setAllowLearnerAttachImages(wiki.isAllowLearnerAttachImages());
        authForm.setAllowLearnerCreatePages(wiki.isAllowLearnerCreatePages());
        authForm.setAllowLearnerInsertLinks(wiki.isAllowLearnerInsertLinks());
        authForm.setReflectOnActivity(wiki.isReflectOnActivity());
        authForm.setReflectInstructions(wiki.getReflectInstructions());
        authForm.setMaximumEdits(wiki.getMaximumEdits());
        authForm.setMinimumEdits(wiki.getMinimumEdits());
        authForm.setNewPageIsEditable(true);
        authForm.setNotifyUpdates(wiki.isNotifyUpdates());
    }

    private SessionMap<String, Object> createSessionMap(Wiki wiki, ToolAccessMode mode, String contentFolderID, Long toolContentID) {
        SessionMap map = new SessionMap();
        map.put((Object)KEY_MODE, (Object)mode);
        map.put((Object)KEY_CONTENT_FOLDER_ID, (Object)contentFolderID);
        map.put((Object)KEY_TOOL_CONTENT_ID, (Object)toolContentID);
        map.put((Object)KEY_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_DELETED_FILES, new LinkedList());
        for (WikiAttachment attachment : wiki.getWikiAttachments()) {
            String type = attachment.getFileType();
            if (type.equals("OFFLINE")) {
                this.getAttList(KEY_OFFLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
            }
            if (!type.equals("ONLINE")) continue;
            this.getAttList(KEY_ONLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
        }
        return map;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter(KEY_MODE);
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private List<WikiAttachment> getAttList(String key, SessionMap<String, Object> map) {
        List list = (List)map.get((Object)key);
        return list;
    }

    private SessionMap<String, Object> getSessionMap(HttpServletRequest request, AuthoringForm authForm) {
        return (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
    }
}

