/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.actions;

import java.io.IOException;
import java.util.Date;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.wiki.dto.WikiDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiUserDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiPageContent;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.util.WikiException;
import org.lamsfoundation.lams.tool.wiki.web.actions.WikiPageAction;
import org.lamsfoundation.lams.tool.wiki.web.forms.LearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LearningAction
extends WikiPageAction {
    private static Logger log = Logger.getLogger(LearningAction.class);
    private static final boolean MODE_OPTIONAL = false;
    private IWikiService wikiService;

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotebookEntry notebookEntry;
        WikiUser wikiUser;
        WikiSession wikiSession;
        LearningForm learningForm = (LearningForm)form;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        Long currentPageUid = learningForm.getCurrentWikiPageId();
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        if ((wikiSession = this.wikiService.getSessionBySessionId(toolSessionID)) == null) {
            throw new WikiException("Cannot retreive session with toolSessionID" + toolSessionID);
        }
        Wiki wiki = wikiSession.getWiki();
        if (wiki.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        request.setAttribute("mode", (Object)mode.toString());
        learningForm.setToolSessionID(toolSessionID);
        WikiDTO wikiDTO = new WikiDTO(wiki);
        request.setAttribute("wikiDTO", (Object)wikiDTO);
        if (!wiki.isContentInUse()) {
            wiki.setContentInUse(new Boolean(true));
            this.wikiService.saveOrUpdateWiki(wiki);
        }
        if (wiki.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER)) {
            Long userID = WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
            wikiUser = this.wikiService.getUserByUserIdAndSessionId(userID, toolSessionID);
        } else {
            wikiUser = this.getCurrentUser(toolSessionID);
        }
        WikiUserDTO wikiUserDTO = new WikiUserDTO(wikiUser);
        if (wikiUser.isFinishedActivity() && (notebookEntry = this.wikiService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", wikiUser.getUserId().intValue())) != null) {
            wikiUserDTO.setNotebookEntry(notebookEntry.getEntry());
        }
        if (this.wikiService.getEventNotificationService().eventExists("lawiki10", "wikiNotifyLearners", toolSessionID) && this.wikiService.getEventNotificationService().isSubscribed("lawiki10", "wikiNotifyLearners", toolSessionID, Long.valueOf(wikiUser.getUserId()))) {
            wikiUserDTO.setNotificationEnabled(true);
        }
        request.setAttribute("userDTO", (Object)wikiUserDTO);
        int maxEdits = wiki.getMaximumEdits();
        Boolean maxEditsReached = maxEdits != 0 && wikiUser.getWikiEdits() >= maxEdits;
        request.setAttribute("maxEditsReached", (Object)maxEditsReached);
        request.setAttribute("editsLeft", (Object)(maxEdits - wikiUser.getWikiEdits()));
        int minEdits = wiki.getMinimumEdits();
        Boolean minEditsReached = wikiUser.getWikiEdits() >= minEdits;
        request.setAttribute("minEditsReached", (Object)minEditsReached);
        TreeSet<WikiPageDTO> wikiPageDTOs = new TreeSet<WikiPageDTO>();
        for (WikiPage wikiPage : wikiSession.getWikiPages()) {
            WikiPageDTO pageDTO = new WikiPageDTO(wikiPage);
            wikiPageDTOs.add(pageDTO);
        }
        request.setAttribute("wikiPages", wikiPageDTOs);
        request.setAttribute("mainWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
        WikiPage currentWikiPage = null;
        currentWikiPage = currentPageUid != null ? this.wikiService.getWikiPageByUid(currentPageUid) : wikiSession.getMainPage();
        request.setAttribute("currentWikiPage", (Object)new WikiPageDTO(currentWikiPage));
        TreeSet<WikiPageContentDTO> currentWikiPageHistoryDTOs = new TreeSet<WikiPageContentDTO>();
        for (WikiPageContent wikiPageContentHistoryItem : currentWikiPage.getWikiContentVersions()) {
            currentWikiPageHistoryDTOs.add(new WikiPageContentDTO(wikiPageContentHistoryItem));
        }
        request.setAttribute("wikiPageContentHistory", currentWikiPageHistoryDTOs);
        request.setAttribute("contentFolderID", (Object)wikiSession.getContentFolderID());
        if (mode.equals((Object)ToolAccessMode.TEACHER) || wiki.isLockOnFinished() && wikiUser.isFinishedActivity()) {
            request.setAttribute("contentEditable", (Object)false);
        } else {
            request.setAttribute("contentEditable", (Object)true);
        }
        request.setAttribute("finishedActivity", (Object)wikiUser.isFinishedActivity());
        return mapping.findForward("wiki");
    }

    protected ActionForward returnToWiki(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long currentWikiPageId) throws Exception {
        LearningForm learnForm = (LearningForm)form;
        learnForm.setCurrentWikiPageId(currentWikiPageId);
        return this.unspecified(mapping, learnForm, request, response);
    }

    protected WikiUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        WikiUser wikiUser = this.wikiService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (wikiUser == null) {
            WikiSession wikiSession = this.wikiService.getSessionBySessionId(toolSessionId);
            wikiUser = this.wikiService.createWikiUser(user, wikiSession);
        }
        return wikiUser;
    }

    public ActionForward finishActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        WikiUser wikiUser = this.getCurrentUser(toolSessionID);
        if (wikiUser != null) {
            wikiUser.setFinishedActivity(true);
            this.wikiService.saveOrUpdateWikiUser(wikiUser);
        } else {
            log.error((Object)("finishActivity(): couldn't find WikiUser with id: " + wikiUser.getUserId() + "and toolSessionID: " + toolSessionID));
        }
        ToolSessionManager sessionMgrService = WikiServiceProxy.getWikiSessionManager(this.getServlet().getServletContext());
        try {
            String nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, wikiUser.getUserId());
            response.sendRedirect(nextActivityUrl);
        }
        catch (DataMissingException e) {
            throw new WikiException(e);
        }
        catch (ToolException e) {
            throw new WikiException(e);
        }
        catch (IOException e) {
            throw new WikiException(e);
        }
        return null;
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearningForm lrnForm = (LearningForm)form;
        WikiUser wikiUser = this.getCurrentUser(lrnForm.getToolSessionID());
        WikiDTO wikiDTO = new WikiDTO(wikiUser.getWikiSession().getWiki());
        request.setAttribute("wikiDTO", (Object)wikiDTO);
        NotebookEntry notebookEntry = this.wikiService.getEntry(wikiUser.getWikiSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", wikiUser.getUserId().intValue());
        if (notebookEntry != null) {
            lrnForm.setEntryText(notebookEntry.getEntry());
        }
        return mapping.findForward("notebook");
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer userID;
        LearningForm lrnForm = (LearningForm)form;
        WikiUser wikiUser = this.getCurrentUser(lrnForm.getToolSessionID());
        Long toolSessionID = wikiUser.getWikiSession().getSessionId();
        NotebookEntry entry = this.wikiService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", userID = Integer.valueOf(wikiUser.getUserId().intValue()));
        if (entry == null) {
            this.wikiService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", userID, lrnForm.getEntryText());
        } else {
            entry.setEntry(lrnForm.getEntryText());
            entry.setLastModified(new Date());
            this.wikiService.updateEntry(entry);
        }
        return this.finishActivity(mapping, form, request, response);
    }
}

