/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.actions;

import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.wiki.dto.WikiDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiSessionDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiUserDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiPageContent;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.util.WikiException;
import org.lamsfoundation.lams.tool.wiki.web.actions.WikiPageAction;
import org.lamsfoundation.lams.tool.wiki.web.forms.MonitoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MonitoringAction
extends WikiPageAction {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    public IWikiService wikiService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        Wiki wiki = this.wikiService.getWikiByContentId(toolContentID);
        if (wiki == null) {
            throw new WikiException("Could not find wiki with content id: " + toolContentID);
        }
        WikiDTO wikiDT0 = new WikiDTO(wiki);
        Long currentTab = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true);
        wikiDT0.setCurrentTab(currentTab);
        request.setAttribute("wikiDTO", (Object)wikiDT0);
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        return mapping.findForward("success");
    }

    protected ActionForward returnToWiki(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long currentWikiPageId) throws Exception {
        MonitoringForm monitoringForm = (MonitoringForm)form;
        monitoringForm.setCurrentWikiPageId(currentWikiPageId);
        return this.showWiki(mapping, monitoringForm, request, response);
    }

    protected WikiUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        WikiUser wikiUser = this.wikiService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (wikiUser == null) {
            WikiSession wikiSession = this.wikiService.getSessionBySessionId(toolSessionId);
            wikiUser = this.wikiService.createWikiUser(user, wikiSession);
        }
        return wikiUser;
    }

    public ActionForward showWiki(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiSession wikiSession = this.wikiService.getSessionBySessionId(toolSessionId);
        WikiSessionDTO sessionDTO = new WikiSessionDTO(wikiSession);
        for (WikiUserDTO userDTO : sessionDTO.getUserDTOs()) {
            NotebookEntry notebookEntry = this.wikiService.getEntry(toolSessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", userDTO.getUserId().intValue());
            if (notebookEntry != null) {
                userDTO.setNotebookEntry(notebookEntry.getEntry());
            }
            sessionDTO.getUserDTOs().add(userDTO);
        }
        request.setAttribute("sessionDTO", (Object)sessionDTO);
        MonitoringForm monForm = (MonitoringForm)form;
        Long currentPageUid = monForm.getCurrentWikiPageId();
        TreeSet<WikiPageDTO> wikiPageDTOs = new TreeSet<WikiPageDTO>();
        for (WikiPage wikiPage : wikiSession.getWikiPages()) {
            WikiPageDTO pageDTO = new WikiPageDTO(wikiPage);
            wikiPageDTOs.add(pageDTO);
        }
        request.setAttribute("contentFolderID", (Object)wikiSession.getContentFolderID());
        request.setAttribute("wikiPages", wikiPageDTOs);
        request.setAttribute("mainWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
        WikiPage currentWikiPage = null;
        currentWikiPage = currentPageUid != null ? this.wikiService.getWikiPageByUid(currentPageUid) : wikiSession.getMainPage();
        request.setAttribute("currentWikiPage", (Object)new WikiPageDTO(currentWikiPage));
        monForm.setIsEditable(currentWikiPage.getEditable());
        monForm.setNewPageIsEditable(true);
        TreeSet<WikiPageContentDTO> currentWikiPageHistoryDTOs = new TreeSet<WikiPageContentDTO>();
        for (WikiPageContent wikiPageContentHistoryItem : currentWikiPage.getWikiContentVersions()) {
            currentWikiPageHistoryDTOs.add(new WikiPageContentDTO(wikiPageContentHistoryItem));
        }
        request.setAttribute("wikiPageContentHistory", currentWikiPageHistoryDTOs);
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        return mapping.findForward("wiki_display");
    }
}

