/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.actions;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.web.forms.WikiPedagogicalPlannerForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class PedagogicalPlannerAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(PedagogicalPlannerAction.class);
    public IWikiService wikiService;

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        return this.initPedagogicalPlannerForm(mapping, form, request, response);
    }

    public ActionForward initPedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WikiPedagogicalPlannerForm plannerForm = (WikiPedagogicalPlannerForm)form;
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Wiki wiki = this.getWikiService().getWikiByContentId(toolContentID);
        String command = WebUtil.readStrParam((HttpServletRequest)request, (String)"command", (boolean)true);
        if (command == null) {
            plannerForm.fillForm(wiki);
            String contentFolderId = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
            plannerForm.setContentFolderID(contentFolderId);
            return mapping.findForward("success");
        }
        try {
            String onlineInstructions = wiki.getOnlineInstructions();
            response.setContentType("text/html;charset=utf-8");
            PrintWriter writer = response.getWriter();
            if ("checkEditingAdvice".equals(command)) {
                Integer activityIndex = WebUtil.readIntParam((HttpServletRequest)request, (String)"activityIndex");
                String responseText = (StringUtils.isEmpty((String)wiki.getOnlineInstructions()) ? "NO" : "OK") + '&' + activityIndex;
                writer.print(responseText);
            } else if ("getEditingAdvice".equals(command)) {
                writer.print(onlineInstructions);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public ActionForward saveOrUpdatePedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WikiPedagogicalPlannerForm plannerForm = (WikiPedagogicalPlannerForm)form;
        ActionMessages errors = plannerForm.validate();
        if (errors.isEmpty()) {
            String instructions = plannerForm.getWikiBody();
            Long toolContentID = plannerForm.getToolContentID();
            Wiki wiki = this.getWikiService().getWikiByContentId(toolContentID);
            WikiPage wikiPage = wiki.getWikiPages().iterator().next();
            wikiPage.setTitle(plannerForm.getTitle());
            wikiPage.getCurrentWikiContent().setBody(plannerForm.getWikiBody());
            this.getWikiService().saveOrUpdateWikiPage(wikiPage);
        } else {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("success");
    }

    private IWikiService getWikiService() {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        return this.wikiService;
    }
}

