/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.actions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiPageContent;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.web.actions.AuthoringAction;
import org.lamsfoundation.lams.tool.wiki.web.forms.WikiPageForm;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public abstract class WikiPageAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(AuthoringAction.class);
    public IWikiService wikiService;

    protected abstract ActionForward unspecified(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected abstract ActionForward returnToWiki(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4, Long var5) throws Exception;

    protected abstract WikiUser getCurrentUser(Long var1);

    public ActionForward editPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiPageForm wikiForm = (WikiPageForm)form;
        WikiPage currentPage = this.wikiService.getWikiPageByUid(currentPageUid);
        if (!currentPage.getCurrentWikiContent().getBody().equals(wikiForm.getWikiBody()) || !currentPage.getTitle().equals(wikiForm.getTitle())) {
            ToolAccessMode mode;
            Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
            WikiUser user = null;
            if (toolSessionID != null) {
                user = this.getCurrentUser(toolSessionID);
            }
            if ((mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true)) == null || mode == ToolAccessMode.TEACHER) {
                if (wikiForm.getIsEditable() == null) {
                    wikiForm.setIsEditable(false);
                }
            } else if (wikiForm.getIsEditable() == null) {
                wikiForm.setIsEditable(true);
            }
            this.wikiService.updateWikiPage(wikiForm, currentPage, user);
            if (toolSessionID != null && user != null) {
                this.notifyWikiChange(toolSessionID, "notify.pageEdited.subject", "notify.pageEdited.body", user, request);
            }
        }
        return this.returnToWiki(mapping, wikiForm, request, response, currentPageUid);
    }

    public ActionForward revertPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long revertPageContentVersion = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"historyPageContentId"));
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiPage currentPage = this.wikiService.getWikiPageByUid(currentPageUid);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
        WikiUser user = null;
        if (toolSessionID != null) {
            user = this.getCurrentUser(toolSessionID);
        }
        WikiPageContent content = this.wikiService.getWikiPageContent(revertPageContentVersion);
        WikiPageForm wikiForm = (WikiPageForm)form;
        wikiForm.setWikiBody(content.getBody());
        wikiForm.setIsEditable(currentPage.getEditable());
        this.wikiService.updateWikiPage(wikiForm, currentPage, user);
        if (toolSessionID != null && user != null) {
            this.notifyWikiChange(toolSessionID, "notify.pageEdited.subject", "notify.pageEdited.body", user, request);
        }
        return this.unspecified(mapping, wikiForm, request, response);
    }

    public ActionForward comparePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long revertPageContentVersion = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"historyPageContentId"));
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiPage currentWikiPage = this.wikiService.getWikiPageByUid(currentPageUid);
        WikiPageContent currentContent = currentWikiPage.getCurrentWikiContent();
        WikiPageContent compareContent = this.wikiService.getWikiPageContent(revertPageContentVersion);
        String diff = this.wikiService.comparePages(compareContent.getBody(), currentContent.getBody());
        request.setAttribute("compareVersions", (Object)(compareContent.getVersion().toString() + "-" + currentContent.getVersion().toString()));
        request.setAttribute("compareTitle", (Object)currentWikiPage.getTitle());
        request.setAttribute("compareString", (Object)diff);
        return mapping.findForward("compareWiki");
    }

    public ActionForward viewPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long revertPageContentVersion = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"historyPageContentId"));
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiPage currentWikiPage = this.wikiService.getWikiPageByUid(currentPageUid);
        WikiPageContent oldContent = this.wikiService.getWikiPageContent(revertPageContentVersion);
        WikiPageDTO pageDTO = new WikiPageDTO();
        pageDTO.setTitle(currentWikiPage.getTitle());
        pageDTO.setCurrentWikiContentDTO(new WikiPageContentDTO(oldContent));
        request.setAttribute("currentWikiPage", (Object)pageDTO);
        return mapping.findForward("viewWiki");
    }

    public ActionForward changePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        Wiki wiki = null;
        WikiSession session = null;
        WikiPage wikiPage = null;
        String newPageName = WebUtil.readStrParam((HttpServletRequest)request, (String)"newPageName").replaceAll("`", "'");
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
        if (toolSessionID == null) {
            Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
            wiki = this.wikiService.getWikiByContentId(toolContentID);
            wikiPage = this.wikiService.getWikiPageByWikiAndTitle(wiki, newPageName);
        } else {
            session = this.wikiService.getSessionBySessionId(toolSessionID);
            wiki = session.getWiki();
            wikiPage = this.wikiService.getWikiBySessionAndTitle(session, newPageName);
        }
        if (wikiPage == null) {
            // empty if block
        }
        return this.returnToWiki(mapping, form, request, response, wikiPage.getUid());
    }

    public ActionForward addPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        Wiki wiki = null;
        WikiSession session = null;
        WikiUser user = null;
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
        WikiPageForm wikiForm = (WikiPageForm)form;
        if (toolSessionID == null) {
            Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
            wiki = this.wikiService.getWikiByContentId(toolContentID);
            if (wikiForm.getNewPageIsEditable() == null) {
                wikiForm.setNewPageIsEditable(false);
            }
        } else {
            session = this.wikiService.getSessionBySessionId(toolSessionID);
            wiki = session.getWiki();
            user = this.getCurrentUser(toolSessionID);
        }
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        if (mode == null || mode == ToolAccessMode.TEACHER) {
            if (wikiForm.getNewPageIsEditable() == null) {
                wikiForm.setNewPageIsEditable(false);
            }
        } else if (wikiForm.getNewPageIsEditable() == null) {
            wikiForm.setNewPageIsEditable(true);
        }
        Long currentPageUid = this.wikiService.insertWikiPage(wikiForm, wiki, user, session);
        if (toolSessionID != null && user != null) {
            this.notifyWikiChange(toolSessionID, "notify.pageAdded.subject", "notify.pageAdded.body", user, request);
        }
        return this.returnToWiki(mapping, wikiForm, request, response, currentPageUid);
    }

    public ActionForward removePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
        WikiUser user = this.getCurrentUser(toolSessionID);
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiPage wikiPage = this.wikiService.getWikiPageByUid(currentPageUid);
        this.wikiService.deleteWikiPage(wikiPage);
        if (toolSessionID != null && user != null) {
            this.notifyWikiChange(toolSessionID, "notify.pageRemoved.subject", "notify.pageRemoved.body", user, request);
        }
        return this.returnToWiki(mapping, form, request, response, null);
    }

    public ActionForward toggleLearnerSubsciption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean subscribed;
        IEventNotificationService notificationService;
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)true);
        Long currentPageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentWikiPage");
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        if (!(notificationService = this.wikiService.getEventNotificationService()).eventExists("lawiki10", "wikiNotifyLearners", toolSessionID)) {
            notificationService.createEvent("lawiki10", "wikiNotifyLearners", toolSessionID, null, null);
        }
        if (subscribed = notificationService.isSubscribed("lawiki10", "wikiNotifyLearners", toolSessionID, Long.valueOf(user.getUserID().longValue()))) {
            notificationService.unsubscribe("lawiki10", "wikiNotifyLearners", toolSessionID, Long.valueOf(user.getUserID().longValue()));
        } else {
            notificationService.subscribe("lawiki10", "wikiNotifyLearners", toolSessionID, Long.valueOf(user.getUserID().longValue()), IEventNotificationService.DELIVERY_METHOD_MAIL, Long.valueOf(0L));
        }
        return this.returnToWiki(mapping, (WikiPageForm)form, request, response, currentPageUid);
    }

    private void notifyWikiChange(Long toolSessionID, String subjectLangKey, String bodyLangKey, WikiUser wikiUser, HttpServletRequest request) throws Exception {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServlet().getServletContext());
        }
        WikiSession wikiSession = this.wikiService.getSessionBySessionId(toolSessionID);
        IEventNotificationService notificationService = this.wikiService.getEventNotificationService();
        String subject = this.wikiService.getLocalisedMessage(subjectLangKey, new Object[]{wikiSession.getSessionName()});
        String fullName = wikiUser.getFirstName() + " " + wikiUser.getLastName();
        if (wikiSession.getWiki().isNotifyUpdates()) {
            List<User> users = this.wikiService.getMonitorsByToolSessionId(toolSessionID);
            Long[] monitoringUsersIds = new Long[users.size()];
            for (int i = 0; i < monitoringUsersIds.length; ++i) {
                monitoringUsersIds[i] = users.get(i).getUserId().longValue();
            }
            String relativePath = "/tool/lawiki10/monitoring.do?dispatch=showWiki&toolSessionID=" + toolSessionID.toString() + "&contentFolderID=" + wikiSession.getContentFolderID();
            String hash = relativePath + "," + toolSessionID.toString() + ",t";
            hash = new String(Base64.encodeBase64((byte[])hash.getBytes()));
            String link = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "r.do?" + "h=" + hash;
            String body = this.wikiService.getLocalisedMessage(bodyLangKey, new Object[]{fullName, wikiSession.getSessionName(), link});
            notificationService.sendMessage(monitoringUsersIds, IEventNotificationService.DELIVERY_METHOD_MAIL, subject, body);
        }
        if (notificationService.eventExists("lawiki10", "wikiNotifyLearners", toolSessionID)) {
            String relativePath = "/tool/lawiki10/learning.do?mode=learner&toolSessionID=" + toolSessionID.toString();
            String hash = relativePath + "," + toolSessionID.toString() + ",l";
            hash = new String(Base64.encodeBase64((byte[])hash.getBytes()));
            String link = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "r.do?" + "h=" + hash;
            String body = this.wikiService.getLocalisedMessage(bodyLangKey, new Object[]{fullName, wikiSession.getSessionName(), link});
            notificationService.trigger("lawiki10", "wikiNotifyLearners", toolSessionID, subject, body);
        }
    }
}

