/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.wiki.web.servlets;

import java.io.IOException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.export.web.action.ImageBundler;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.wiki.dto.WikiDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageContentDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiPageDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiSessionDTO;
import org.lamsfoundation.lams.tool.wiki.dto.WikiUserDTO;
import org.lamsfoundation.lams.tool.wiki.model.Wiki;
import org.lamsfoundation.lams.tool.wiki.model.WikiPage;
import org.lamsfoundation.lams.tool.wiki.model.WikiSession;
import org.lamsfoundation.lams.tool.wiki.model.WikiUser;
import org.lamsfoundation.lams.tool.wiki.service.IWikiService;
import org.lamsfoundation.lams.tool.wiki.service.WikiServiceProxy;
import org.lamsfoundation.lams.tool.wiki.util.WikiException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -2829707715037631881L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "wiki_main.html";
    private IWikiService wikiService;

    protected String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.wikiService == null) {
            this.wikiService = WikiServiceProxy.getWikiService(this.getServletContext());
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
                this.doLearnerExport(request, response, directoryName, basePath, cookies);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
                this.doTeacherExport(request, response, directoryName, basePath, cookies);
            }
        }
        catch (WikiException e) {
            logger.error((Object)"Cannot perform export for wiki tool.");
        }
        catch (IOException e) {
            logger.error((Object)"Cannot perform export for wiki tool.");
        }
        return "wiki_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            if (this.wikiService == null) {
                this.wikiService = WikiServiceProxy.getWikiService(this.getServletContext());
            }
            Wiki content = null;
            if (this.toolContentID != null) {
                content = this.wikiService.getWikiByContentId(this.toolContentID);
            } else {
                WikiSession session = this.wikiService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getWiki();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void doLearnerExport(HttpServletRequest request, HttpServletResponse response, String directoryName, String basePath, Cookie[] cookies) throws WikiException, IOException {
        NotebookEntry notebookEntry;
        logger.debug((Object)("doExportLearner: toolContentID:" + this.toolSessionID));
        if (this.toolSessionID == null) {
            String error = "Tool Session ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new WikiException(error);
        }
        WikiSession wikiSession = this.wikiService.getSessionBySessionId(this.toolSessionID);
        Wiki wiki = wikiSession.getWiki();
        WikiDTO wikiDTO = new WikiDTO(wiki);
        request.getSession().setAttribute("wikiDTO", (Object)wikiDTO);
        WikiSessionDTO sessionDTO = new WikiSessionDTO(wikiSession);
        request.getSession().setAttribute("sessionDTO", (Object)sessionDTO);
        TreeSet<WikiPageDTO> wikiPageDTOs = new TreeSet<WikiPageDTO>();
        for (WikiPage wikiPage : wikiSession.getWikiPages()) {
            WikiPageDTO wikiPageDTO = new WikiPageDTO(wikiPage);
            WikiPageContentDTO contentDTO = wikiPageDTO.getCurrentWikiContentDTO();
            contentDTO.setBody(this.replaceImageFolderLinks(contentDTO.getBody(), wikiSession.getContentFolderID(), Configuration.get((String)ConfigurationKeys.SERVER_URL_CONTEXT_PATH)));
            wikiPageDTO.setCurrentWikiContentDTO(contentDTO);
            wikiPageDTOs.add(wikiPageDTO);
        }
        request.getSession().setAttribute("wikiPages", wikiPageDTOs);
        request.getSession().setAttribute("currentWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
        request.getSession().setAttribute("mainWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
        ImageBundler imageBundler = new ImageBundler(directoryName, wikiSession.getContentFolderID());
        imageBundler.bundleImages();
        UserDTO lamsUserDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        WikiUser wikiUser = this.wikiService.getUserByUserIdAndSessionId(new Long(lamsUserDTO.getUserID().intValue()), this.toolSessionID);
        WikiUserDTO wikiUserDTO = new WikiUserDTO(wikiUser);
        if (wikiUser.isFinishedActivity() && (notebookEntry = this.wikiService.getEntry(this.toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", wikiUser.getUserId().intValue())) != null) {
            wikiUserDTO.setNotebookEntry(notebookEntry.getEntry());
        }
        request.getSession().setAttribute("userDTO", (Object)wikiUserDTO);
        request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, "wiki_main.html", cookies);
    }

    private void doTeacherExport(HttpServletRequest request, HttpServletResponse response, String directoryName, String basePath, Cookie[] cookies) throws WikiException, IOException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolContentID));
        if (this.toolContentID == null) {
            String error = "Tool Content ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new WikiException(error);
        }
        Wiki wiki = this.wikiService.getWikiByContentId(this.toolContentID);
        WikiDTO wikiDTO = new WikiDTO(wiki);
        request.getSession().setAttribute("wikiDTO", (Object)wikiDTO);
        String wikiTitle = wiki.getMainPage().getTitle();
        request.getSession().setAttribute("mainPageTitle", (Object)wikiTitle);
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolioTeacher.jsp", directoryName, "wiki_main.html", cookies);
        for (WikiSession wikiSession : wiki.getWikiSessions()) {
            WikiSessionDTO sessionDTO = new WikiSessionDTO(wikiSession);
            for (WikiUserDTO wikiUserDTO : sessionDTO.getUserDTOs()) {
                NotebookEntry notebookEntry;
                if (wikiUserDTO.isFinishedActivity() && (notebookEntry = this.wikiService.getEntry(sessionDTO.getSessionID(), CoreNotebookConstants.NOTEBOOK_TOOL, "lawiki10", wikiUserDTO.getUserId().intValue())) != null) {
                    wikiUserDTO.setNotebookEntry(notebookEntry.getEntry());
                }
                sessionDTO.getUserDTOs().add(wikiUserDTO);
            }
            request.getSession().setAttribute("sessionDTO", (Object)sessionDTO);
            TreeSet<WikiPageDTO> wikiPageDTOs = new TreeSet<WikiPageDTO>();
            for (WikiPage wikiPage : wikiSession.getWikiPages()) {
                WikiPageDTO wikiPageDTO = new WikiPageDTO(wikiPage);
                WikiPageContentDTO contentDTO = wikiPageDTO.getCurrentWikiContentDTO();
                contentDTO.setBody(this.replaceImageFolderLinks(contentDTO.getBody(), wikiSession.getContentFolderID(), Configuration.get((String)ConfigurationKeys.SERVER_URL_CONTEXT_PATH)));
                wikiPageDTO.setCurrentWikiContentDTO(contentDTO);
                wikiPageDTOs.add(wikiPageDTO);
            }
            request.getSession().setAttribute("wikiPages", wikiPageDTOs);
            request.getSession().setAttribute("currentWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
            request.getSession().setAttribute("mainWikiPage", (Object)new WikiPageDTO(wikiSession.getMainPage()));
            ImageBundler imageBundler = new ImageBundler(directoryName, wikiSession.getContentFolderID());
            imageBundler.bundleImages();
            this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, wikiSession.getSessionId() + ".html", cookies);
            request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
        }
    }

    private String replaceImageFolderLinks(String body, String contentFolderID, String lamsOrRams) {
        String fckeditorpath = "/" + lamsOrRams + "/www/secure/" + contentFolderID;
        String newfckeditorpath = "./" + contentFolderID;
        String fckeditorsmiley = "/" + lamsOrRams + "/fckeditor/editor/images/smiley";
        String newfckeditorsmiley = "./fckeditor/editor/images/smiley";
        Pattern p = Pattern.compile(fckeditorpath);
        Matcher m = p.matcher("");
        Pattern p2 = Pattern.compile(fckeditorsmiley);
        Matcher m2 = p2.matcher("");
        m.reset(body);
        String result = m.replaceAll(newfckeditorpath);
        m2.reset(result);
        result = m2.replaceAll(newfckeditorsmiley);
        return result;
    }
}

