/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.util.Set;
import java.util.Vector;
import org.lamsfoundation.lams.authoring.dto.StoreLearningDesignResultsDTO;
import org.lamsfoundation.lams.authoring.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;

public class LearningDesignValidator {
    protected LearningDesignDAO learningDesignDAO = null;
    private Vector listOfValidationErrorDTOs = null;
    private FlashMessage flashMessage;

    public LearningDesignValidator(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
        this.listOfValidationErrorDTOs = new Vector();
    }

    public FlashMessage validateLearningDesign(LearningDesign learningDesign) {
        boolean valid = true;
        this.validateActivityTransitionRules(learningDesign.getParentActivities(), learningDesign.getTransitions());
        this.validateGeneral(learningDesign.getActivities());
        if (this.listOfValidationErrorDTOs.size() > 0) {
            valid = false;
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)new StoreLearningDesignResultsDTO(valid, this.listOfValidationErrorDTOs, learningDesign.getLearningDesignId()), 1);
        } else {
            learningDesign.setValidDesign(new Boolean(valid));
            this.learningDesignDAO.insert((Object)learningDesign);
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)new StoreLearningDesignResultsDTO(valid, learningDesign.getLearningDesignId()));
        }
        return this.flashMessage;
    }

    private void validateActivityTransitionRules(Set topLevelActivities, Set transitions) {
        this.validateTransitions(transitions);
        Vector<Activity> noInputTransition = new Vector<Activity>();
        Vector<Activity> noOuputTransition = new Vector<Activity>();
        int numOfTopLevelActivities = topLevelActivities.size();
        for (Activity activity : topLevelActivities) {
            this.checkActivityForTransition(activity, numOfTopLevelActivities);
            if (activity.getTransitionFrom() == null) {
                noOuputTransition.add(activity);
            }
            if (activity.getTransitionTo() != null) continue;
            noInputTransition.add(activity);
        }
        if (numOfTopLevelActivities > 0) {
            if (noInputTransition.size() == 0) {
                this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.INPUT_TRANSITION_ERROR_TYPE2));
            }
            if (noInputTransition.size() > 1) {
                for (Activity a : noInputTransition) {
                    this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.INPUT_TRANSITION_ERROR_TYPE1, a.getActivityUIID()));
                }
            }
            if (noOuputTransition.size() == 0) {
                this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.OUTPUT_TRANSITION_ERROR_TYPE2));
            }
            if (noOuputTransition.size() > 1) {
                for (Activity a : noOuputTransition) {
                    this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.OUTPUT_TRANSITION_ERROR_TYPE1, a.getActivityUIID()));
                }
            }
        }
    }

    private void validateTransitions(Set transitions) {
        for (Transition transition : transitions) {
            Activity fromActivity = transition.getFromActivity();
            Activity toActivity = transition.getToActivity();
            if (fromActivity == null) {
                this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.TRANSITION_ERROR, transition.getTransitionUIID()));
                continue;
            }
            if (toActivity != null) continue;
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.TRANSITION_ERROR, transition.getTransitionUIID()));
        }
    }

    private void checkActivityForTransition(Activity activity, int numOfActivities) {
        Transition inputTransition = activity.getTransitionTo();
        Transition outputTransition = activity.getTransitionFrom();
        if (numOfActivities > 1 && inputTransition == null && outputTransition == null) {
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.ACTIVITY_TRANSITION_ERROR, activity.getActivityUIID()));
        }
        if (numOfActivities == 1 && (inputTransition != null || outputTransition != null)) {
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.ACTIVITY_TRANSITION_ERROR, activity.getActivityUIID()));
        }
    }

    private void validateGeneral(Set activities) {
        for (Activity activity : activities) {
            this.checkIfGroupingRequired(activity);
            this.validateGroupingIfGroupingIsApplied(activity);
            this.validateOptionalActivity(activity);
            this.validateOptionsActivityOrderId(activity);
        }
    }

    private void checkIfGroupingRequired(Activity activity) {
        Grouping grouping;
        Integer groupingSupportType = activity.getGroupingSupportType();
        if (groupingSupportType == 3) {
            Grouping grouping2 = activity.getGrouping();
            if (grouping2 == null) {
                this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.GROUPING_REQUIRED_ERROR, activity.getActivityUIID()));
            }
        } else if (groupingSupportType == 1 && (grouping = activity.getGrouping()) != null) {
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.GROUPING_NOT_REQUIRED_ERROR, activity.getActivityUIID()));
        }
    }

    private void validateOptionalActivity(Activity parentActivity) {
        OptionsActivity optionsActivity;
        Set childActivities;
        int numOfChildActivities;
        if (parentActivity.isOptionsActivity() && (numOfChildActivities = (childActivities = (optionsActivity = (OptionsActivity)parentActivity).getActivities()).size()) == 0) {
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.OPTIONAL_ACTIVITY_ERROR, optionsActivity.getActivityUIID()));
        }
    }

    private void validateOptionsActivityOrderId(Activity parentActivity) {
        Long thisActivityId = null;
        Long previousActivityId = null;
        boolean validOrderId = true;
        if (parentActivity.isOptionsActivity()) {
            OptionsActivity optionsActivity = (OptionsActivity)parentActivity;
            Set childActivities = optionsActivity.getActivities();
            for (Activity childActivity : childActivities) {
                thisActivityId = childActivity.getActivityId();
                if (previousActivityId != null) {
                    if (thisActivityId != previousActivityId + 1L) {
                        if (validOrderId) {
                            // empty if block
                        }
                        validOrderId = false;
                    }
                } else if (thisActivityId != 1L) {
                    if (validOrderId) {
                        // empty if block
                    }
                    validOrderId = false;
                }
                previousActivityId = thisActivityId;
            }
            if (!validOrderId) {
                this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.OPTIONAL_ACTIVITY_ORDER_ID_INVALID_ERROR, optionsActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingIfGroupingIsApplied(Activity activity) {
        if (activity.getApplyGrouping().booleanValue() && activity.getGrouping() == null) {
            this.listOfValidationErrorDTOs.add(new ValidationErrorDTO(ValidationErrorDTO.GROUPING_SELECTED_ERROR, activity.getActivityUIID()));
        }
    }
}

