/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

public class ObjectExtractor {
    protected UserDAO userDAO = null;
    protected LearningDesignDAO learningDesignDAO = null;
    protected ActivityDAO activityDAO = null;
    protected TransitionDAO transitionDAO = null;
    protected WorkspaceFolderDAO workspaceFolderDAO = null;
    protected LearningLibraryDAO learningLibraryDAO = null;
    protected LicenseDAO licenseDAO = null;
    protected GroupingDAO groupingDAO = null;
    protected ToolDAO toolDAO = null;
    protected GroupDAO groupDAO = null;
    protected Logger log = Logger.getLogger(ObjectExtractor.class);

    public ObjectExtractor(UserDAO userDAO, LearningDesignDAO learningDesignDAO, ActivityDAO activityDAO, WorkspaceFolderDAO workspaceFolderDAO, LearningLibraryDAO learningLibraryDAO, LicenseDAO licenseDAO, GroupingDAO groupingDAO, ToolDAO toolDAO, GroupDAO groupDAO, TransitionDAO transitionDAO) {
        this.userDAO = userDAO;
        this.learningDesignDAO = learningDesignDAO;
        this.activityDAO = activityDAO;
        this.workspaceFolderDAO = workspaceFolderDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.licenseDAO = licenseDAO;
        this.groupingDAO = groupingDAO;
        this.toolDAO = toolDAO;
        this.groupDAO = groupDAO;
        this.transitionDAO = transitionDAO;
    }

    public LearningDesign extractLearningDesign(Hashtable table) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer userId;
        LearningDesign learningDesign = null;
        Long learningDesignId = WDDXProcessor.convertToLong((Hashtable)table, (String)"learningDesignID");
        LearningDesign learningDesign2 = learningDesign = learningDesignId != null ? this.learningDesignDAO.getLearningDesignById(learningDesignId) : new LearningDesign();
        if (this.keyExists(table, "learningDesignUIID")) {
            learningDesign.setLearningDesignUIID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"learningDesignUIID"));
        }
        if (this.keyExists(table, "description")) {
            learningDesign.setDescription(WDDXProcessor.convertToString((Hashtable)table, (String)"description"));
        }
        if (this.keyExists(table, "title")) {
            learningDesign.setTitle(WDDXProcessor.convertToString((Hashtable)table, (String)"title"));
        }
        if (this.keyExists(table, "maxID")) {
            learningDesign.setMaxID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"maxID"));
        }
        if (this.keyExists(table, "validDesign")) {
            learningDesign.setValidDesign(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"validDesign"));
        }
        if (this.keyExists(table, "readOnly")) {
            learningDesign.setReadOnly(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"readOnly"));
        }
        if (this.keyExists(table, "dateReadOnly")) {
            learningDesign.setDateReadOnly(WDDXProcessor.convertToDate((Hashtable)table, (String)"dateReadOnly"));
        }
        if (this.keyExists(table, "offlineInstructions")) {
            learningDesign.setOfflineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"offlineInstructions"));
        }
        if (this.keyExists(table, "onlineInstructions")) {
            learningDesign.setOnlineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"onlineInstructions"));
        }
        if (this.keyExists(table, "helpText")) {
            learningDesign.setHelpText(WDDXProcessor.convertToString((Hashtable)table, (String)"helpText"));
        }
        if (this.keyExists(table, "copyTypeID")) {
            learningDesign.setCopyTypeID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"copyTypeID"));
        }
        if (this.keyExists(table, "createDateTime")) {
            learningDesign.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)table, (String)"createDateTime"));
        }
        if (this.keyExists(table, "version")) {
            learningDesign.setVersion(WDDXProcessor.convertToString((Hashtable)table, (String)"version"));
        }
        if (this.keyExists(table, "duration")) {
            learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "lastModifiedDateTime")) {
            learningDesign.setLastModifiedDateTime(WDDXProcessor.convertToDate((Hashtable)table, (String)"lastModifiedDateTime"));
        }
        if (this.keyExists(table, "lessonOrgName")) {
            learningDesign.setLessonOrgName(WDDXProcessor.convertToString((Hashtable)table, (String)"lessonOrgName"));
        }
        if (this.keyExists(table, "lessonName")) {
            learningDesign.setLessonName(WDDXProcessor.convertToString((Hashtable)table, (String)"lessonName"));
        }
        if (this.keyExists(table, "lessonStartDateTime")) {
            learningDesign.setLessonStartDateTime(WDDXProcessor.convertToDate((Hashtable)table, (String)"lessonStartDateTime"));
        }
        if (this.keyExists(table, "lessonID")) {
            learningDesign.setLessonID(WDDXProcessor.convertToLong((Hashtable)table, (String)"lessonID"));
        }
        if (this.keyExists(table, "lessonOrgID")) {
            learningDesign.setLessonOrgID(WDDXProcessor.convertToLong((Hashtable)table, (String)"lessonOrgID"));
        }
        if (this.keyExists(table, "duration")) {
            learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "userID") && (userId = WDDXProcessor.convertToInteger((Hashtable)table, (String)"userID")) != null) {
            User user = this.userDAO.getUserById(userId);
            if (user != null) {
                learningDesign.setUser(user);
            } else {
                throw new ObjectExtractorException("userID missing");
            }
        }
        if (this.keyExists(table, "licenseID")) {
            Long licenseID = WDDXProcessor.convertToLong((Hashtable)table, (String)"licenseID");
            if (licenseID != null) {
                License license = this.licenseDAO.getLicenseByID(licenseID);
                learningDesign.setLicense(license);
            } else {
                learningDesign.setLicense(null);
            }
        }
        if (this.keyExists(table, "licenseText")) {
            learningDesign.setLicenseText(WDDXProcessor.convertToString((Hashtable)table, (String)"licenseText"));
        }
        if (this.keyExists(table, "workspaceFolderID")) {
            Integer workspaceFolderID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"workspaceFolderID");
            if (workspaceFolderID != null) {
                WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
                learningDesign.setWorkspaceFolder(workspaceFolder);
            } else {
                learningDesign.setWorkspaceFolder(null);
            }
        }
        if (this.keyExists(table, "parentLearningDesignID")) {
            Long parentLearningDesignID = WDDXProcessor.convertToLong((Hashtable)table, (String)"parentLearningDesignID");
            if (parentLearningDesignID != null) {
                LearningDesign parent = this.learningDesignDAO.getLearningDesignById(parentLearningDesignID);
                learningDesign.setParentLearningDesign(parent);
            } else {
                learningDesign.setParentLearningDesign(null);
            }
        }
        this.learningDesignDAO.insert((Object)learningDesign);
        this.parseGroupings((Vector)table.get("groupings"), learningDesign);
        this.parseActivities((Vector)table.get("activities"), learningDesign);
        this.parseActivitiesToMatchUpParentActivityByParentUIID((Vector)table.get("activities"), learningDesign);
        this.parseTransitions((Vector)table.get("transitions"), learningDesign);
        learningDesign.setFirstActivity(learningDesign.calculateFirstActivity());
        this.learningDesignDAO.update((Object)learningDesign);
        return learningDesign;
    }

    private void parseGroupings(List groupingsList, LearningDesign learningDesign) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (groupingsList != null) {
            for (Hashtable groupingDetails : groupingsList) {
                if (groupingDetails == null) continue;
                Grouping grouping = this.extractGroupingObject(groupingDetails);
                this.groupingDAO.insert((Object)grouping);
            }
        }
    }

    private void parseActivities(List activitiesList, LearningDesign learningDesign) throws WDDXProcessorConversionException, ObjectExtractorException {
        HashSet<Activity> updatedSet = new HashSet<Activity>();
        Set currentActivities = learningDesign.getActivities();
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Activity activity = this.extractActivityObject(activityDetails, learningDesign);
                this.activityDAO.insert((Object)activity);
                currentActivities.add(activity);
                updatedSet.add(activity);
            }
        }
        Iterator itr = currentActivities.iterator();
        while (itr.hasNext()) {
            Activity activity = (Activity)itr.next();
            if (updatedSet.contains(activity)) continue;
            itr.remove();
            this.deleteActivity(activity, learningDesign);
        }
        learningDesign.setActivities(currentActivities);
        this.learningDesignDAO.update((Object)learningDesign);
    }

    private void parseActivitiesToMatchUpParentActivityByParentUIID(List activitiesList, LearningDesign learningDesign) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
                Activity existingActivity = this.activityDAO.getActivityByUIID(activityUUID, learningDesign);
                if (this.keyExists(activityDetails, "parentUIID")) {
                    Integer parentUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"parentUIID");
                    if (parentUIID != null) {
                        Activity parentActivity = this.activityDAO.getActivityByUIID(parentUIID, learningDesign);
                        existingActivity.setParentActivity(parentActivity);
                        existingActivity.setParentUIID(parentUIID);
                    } else {
                        existingActivity.setParentActivity(null);
                        existingActivity.setParentUIID(null);
                    }
                }
                this.activityDAO.update((Object)existingActivity);
            }
        }
    }

    private void parseTransitions(List transitionsList, LearningDesign learningDesign) throws WDDXProcessorConversionException {
        HashSet<Transition> updatedSet = new HashSet<Transition>();
        HashSet<Transition> currentTransitions = learningDesign.getTransitions();
        if (currentTransitions == null) {
            currentTransitions = new HashSet<Transition>();
        }
        if (transitionsList != null) {
            for (Hashtable transitionDetails : transitionsList) {
                Transition transition = this.extractTransitionObject(transitionDetails, learningDesign);
                this.transitionDAO.insert((Object)transition);
                currentTransitions.add(transition);
                updatedSet.add(transition);
            }
        }
        Iterator itr = currentTransitions.iterator();
        while (itr.hasNext()) {
            Transition transition = (Transition)itr.next();
            if (updatedSet.contains(transition)) continue;
            itr.remove();
            this.transitionDAO.delete((Object)transition);
        }
        learningDesign.setTransitions(currentTransitions);
        this.learningDesignDAO.update((Object)learningDesign);
    }

    public Activity extractActivityObject(Hashtable activityDetails, LearningDesign design) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
        Activity activity = null;
        Activity existingActivity = this.activityDAO.getActivityByUIID(activityUUID, design);
        if (existingActivity == null) {
            Activity activityObject;
            Integer activityTypeID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID");
            if (activityTypeID == null) {
                throw new ObjectExtractorException("activityTypeID missing");
            }
            activity = activityObject = Activity.getActivityInstance((int)activityTypeID);
        } else {
            activity = existingActivity;
        }
        this.processActivityType(activity, activityDetails);
        if (this.keyExists(activityDetails, "activityTypeID")) {
            activity.setActivityTypeId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID"));
        }
        if (this.keyExists(activityDetails, "activityUIID")) {
            activity.setActivityUIID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID"));
        }
        if (this.keyExists(activityDetails, "description")) {
            activity.setDescription(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"description"));
        }
        if (this.keyExists(activityDetails, "title")) {
            activity.setTitle(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"title"));
        }
        if (this.keyExists(activityDetails, "helpText")) {
            activity.setHelpText(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"helpText"));
        }
        if (this.keyExists(activityDetails, "xCoord")) {
            activity.setXcoord(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"xCoord"));
        }
        if (this.keyExists(activityDetails, "yCoord")) {
            activity.setYcoord(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"yCoord"));
        }
        if (this.keyExists(activityDetails, "parentUIID")) {
            Integer parentUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"parentUIID");
            if (parentUIID != null) {
                Activity parentActivity = this.activityDAO.getActivityByUIID(parentUIID, design);
                activity.setParentActivity(parentActivity);
                activity.setParentUIID(parentUIID);
            } else {
                activity.setParentActivity(null);
                activity.setParentUIID(null);
            }
        }
        if (this.keyExists(activityDetails, "groupingID")) {
            Long groupingID = WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"groupingID");
            Integer groupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingUIID");
            if (groupingID != null) {
                Grouping grouping = this.groupingDAO.getGroupingById(groupingID);
                activity.setGrouping(grouping);
                activity.setGroupingUIID(groupingUIID);
            } else {
                activity.setGrouping(null);
                activity.setGroupingUIID(null);
            }
        }
        if (this.keyExists(activityDetails, "orderID")) {
            activity.setOrderId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"orderID"));
        }
        if (this.keyExists(activityDetails, "defineLater")) {
            activity.setDefineLater(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"defineLater"));
        }
        activity.setLearningDesign(design);
        if (this.keyExists(activityDetails, "learningLibraryID")) {
            Long learningLibraryID = WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"learningLibraryID");
            if (learningLibraryID != null) {
                LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryID);
                activity.setLearningLibrary(library);
            } else {
                activity.setLearningLibrary(null);
            }
        }
        if (this.keyExists(activityDetails, "createDateTime")) {
            activity.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)activityDetails, (String)"createDateTime"));
        }
        if (this.keyExists(activityDetails, "runOffline")) {
            activity.setRunOffline(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"runOffline"));
        }
        if (this.keyExists(activityDetails, "activityCategoryID")) {
            activity.setActivityCategoryID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityCategoryID"));
        }
        if (this.keyExists(activityDetails, "libraryActivityUIImage")) {
            activity.setLibraryActivityUiImage(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"libraryActivityUIImage"));
        }
        if (this.keyExists(activityDetails, "libraryActivityID")) {
            Long libraryActivityID = WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"libraryActivityID");
            if (libraryActivityID != null) {
                Activity libraryActivity = this.activityDAO.getActivityByActivityId(libraryActivityID);
                activity.setLibraryActivity(libraryActivity);
            } else {
                activity.setLibraryActivity(null);
            }
        }
        if (this.keyExists(activityDetails, "applyGrouping")) {
            activity.setApplyGrouping(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"applyGrouping"));
        }
        if (this.keyExists(activityDetails, "groupingSupportType")) {
            activity.setGroupingSupportType(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingSupportType"));
        }
        return activity;
    }

    private void processActivityType(Activity activity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activity.isGroupingActivity()) {
            this.buildGroupingActivity((GroupingActivity)activity, activityDetails);
        } else if (activity.isToolActivity()) {
            this.buildToolActivity((ToolActivity)activity, activityDetails);
        } else if (activity.isGateActivity()) {
            this.buildGateActivity(activity, activityDetails);
        } else {
            this.buildComplexActivity(activity, activityDetails);
        }
    }

    private void buildComplexActivity(Object activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (activity instanceof OptionsActivity) {
            this.buildOptionsActivity((OptionsActivity)activity, activityDetails);
        } else if (activity instanceof ParallelActivity) {
            this.buildParallelActivity((ParallelActivity)activity, activityDetails);
        } else {
            this.buildSequenceActivity((SequenceActivity)activity, activityDetails);
        }
    }

    private void buildGroupingActivity(GroupingActivity groupingActivity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer createGroupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"createGroupingUIID");
        Grouping grouping = this.groupingDAO.getGroupingByUIID(createGroupingUIID);
        if (grouping != null) {
            groupingActivity.setCreateGrouping(grouping);
            groupingActivity.setCreateGroupingUIID(createGroupingUIID);
        }
    }

    private void buildOptionsActivity(OptionsActivity optionsActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(activityDetails, "maxOptions")) {
            optionsActivity.setMaxNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"maxOptions"));
        }
        if (this.keyExists(activityDetails, "minOptions")) {
            optionsActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"minOptions"));
        }
        if (this.keyExists(activityDetails, "optionsInstructions")) {
            optionsActivity.setOptionsInstructions(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"optionsInstructions"));
        }
    }

    private void buildParallelActivity(ParallelActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildSequenceActivity(SequenceActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildToolActivity(ToolActivity toolActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(activityDetails, "toolContentID")) {
            toolActivity.setToolContentId(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolContentID"));
        }
        if (this.keyExists(activityDetails, "toolID")) {
            Tool tool = this.toolDAO.getToolByID(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolID"));
            toolActivity.setTool(tool);
        }
    }

    private void buildGateActivity(Object activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivity((SynchGateActivity)activity, activityDetails);
        } else if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivity((PermissionGateActivity)activity, activityDetails);
        } else {
            ObjectExtractor.buildScheduleGateActivity((ScheduleGateActivity)activity, activityDetails);
        }
        GateActivity gateActivity = (GateActivity)activity;
        gateActivity.setGateActivityLevelId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"gateActivityLevelID"));
        gateActivity.setGateOpen(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"gateOpen"));
    }

    private void buildSynchGateActivity(SynchGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildPermissionGateActivity(PermissionGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private static void buildScheduleGateActivity(ScheduleGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setGateStartDateTime(WDDXProcessor.convertToDate((Hashtable)activityDetails, (String)"gateStartDateTime"));
        activity.setGateEndDateTime(WDDXProcessor.convertToDate((Hashtable)activityDetails, (String)"gateEndDateTime"));
        activity.setGateStartTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateStartTimeOffset"));
        activity.setGateEndTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateEndTimeOffset"));
    }

    public Grouping extractGroupingObject(Hashtable groupingDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Grouping grouping;
        Integer groupingUUID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID");
        Integer groupingTypeID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingTypeID");
        if (groupingTypeID == null) {
            throw new ObjectExtractorException("groupingTypeID is missing");
        }
        Grouping existingGrouping = this.groupingDAO.getGroupingByUIID(groupingUUID);
        if (existingGrouping != null) {
            grouping = existingGrouping;
        } else {
            Object object = Grouping.getGroupingInstance((Integer)groupingTypeID);
            grouping = (Grouping)object;
            if (this.keyExists(groupingDetails, "groupingID")) {
                grouping.setGroupingId(WDDXProcessor.convertToLong((Hashtable)groupingDetails, (String)"groupingID"));
            }
            if (this.keyExists(groupingDetails, "groupingUIID")) {
                grouping.setGroupingUIID(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID"));
            }
        }
        if (grouping.isRandomGrouping()) {
            this.createRandomGrouping((RandomGrouping)grouping, groupingDetails);
        } else if (grouping.isChosenGrouping()) {
            this.createChosenGrouping((ChosenGrouping)grouping, groupingDetails);
        } else {
            this.createLessonClass((LessonClass)grouping, groupingDetails);
        }
        if (this.keyExists(groupingDetails, "maxNumberOfGroups")) {
            grouping.setMaxNumberOfGroups(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"maxNumberOfGroups"));
        }
        return grouping;
    }

    private void createRandomGrouping(RandomGrouping randomGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(groupingDetails, "learnersPerGroup")) {
            randomGrouping.setLearnersPerGroup(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"learnersPerGroup"));
        }
        if (this.keyExists(groupingDetails, "numberOfGroups")) {
            randomGrouping.setNumberOfGroups(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"numberOfGroups"));
        }
    }

    private void createChosenGrouping(ChosenGrouping chosenGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
    }

    private void createLessonClass(LessonClass lessonClass, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Group group;
        if (this.keyExists(groupingDetails, "staffGroupID") && (group = this.groupDAO.getGroupById(WDDXProcessor.convertToLong((Hashtable)groupingDetails, (String)"staffGroupID"))) != null) {
            lessonClass.setStaffGroup(group);
        }
    }

    private Transition extractTransitionObject(Hashtable transitionDetails, LearningDesign learningDesign) throws WDDXProcessorConversionException {
        Integer fromUIID;
        Integer toUIID;
        Long transitionID;
        Integer transitionUUID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"transitionUIID");
        Transition transition = null;
        Transition existingTransition = this.transitionDAO.getTransitionByUUID(transitionUUID, learningDesign);
        transition = existingTransition == null ? new Transition() : existingTransition;
        transition.setTransitionUIID(transitionUUID);
        if (this.keyExists(transitionDetails, "transitionID") && (transitionID = WDDXProcessor.convertToLong((Hashtable)transitionDetails, (String)"transitionID")) != null) {
            transition.setTransitionId(transitionID);
        }
        if (this.keyExists(transitionDetails, "toUIID") && (toUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"toUIID")) != null) {
            Activity toActivity = this.activityDAO.getActivityByUIID(toUIID, learningDesign);
            transition.setToActivity(toActivity);
            transition.setToUIID(toUIID);
            toActivity.setTransitionTo(transition);
            this.activityDAO.update((Object)toActivity);
        }
        if (this.keyExists(transitionDetails, "fromUIID") && (fromUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"fromUIID")) != null) {
            Activity fromActivity = this.activityDAO.getActivityByUIID(fromUIID, learningDesign);
            transition.setFromActivity(fromActivity);
            transition.setFromUIID(fromUIID);
            fromActivity.setTransitionFrom(transition);
            this.activityDAO.update((Object)fromActivity);
        }
        if (this.keyExists(transitionDetails, "description")) {
            transition.setDescription(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"description"));
        }
        if (this.keyExists(transitionDetails, "title")) {
            transition.setTitle(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"title"));
        }
        if (this.keyExists(transitionDetails, "createDateTime")) {
            transition.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)transitionDetails, (String)"createDateTime"));
        }
        transition.setLearningDesign(learningDesign);
        return transition;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }

    private void deleteActivity(Activity activityToDelete, LearningDesign design) {
        Transition transitionTo;
        Transition transitionFrom = activityToDelete.getTransitionFrom();
        if (transitionFrom != null) {
            this.deleteTransition(transitionFrom, design);
        }
        if ((transitionTo = activityToDelete.getTransitionTo()) != null) {
            this.deleteTransition(transitionTo, design);
        }
        this.activityDAO.delete((Object)activityToDelete);
    }

    private void deleteTransition(Transition transition, LearningDesign design) {
        Activity fromActivity = transition.getFromActivity();
        fromActivity.setTransitionFrom(null);
        this.activityDAO.update((Object)fromActivity);
        Activity toActivity = transition.getToActivity();
        toActivity.setTransitionTo(null);
        this.activityDAO.update((Object)toActivity);
        design.getTransitions().remove(transition);
        this.transitionDAO.delete((Object)transition);
    }
}

