/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.LearningDesignValidator;
import org.lamsfoundation.lams.authoring.ObjectExtractor;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.DesignDetailDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LicenseDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dao.ICSSThemeDAO;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.themes.dto.CSSThemeDTO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class AuthoringService
implements IAuthoringService {
    protected Logger log = Logger.getLogger(AuthoringService.class);
    protected LearningDesignDAO learningDesignDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ActivityDAO activityDAO;
    protected UserDAO userDAO;
    protected WorkspaceFolderDAO workspaceFolderDAO;
    protected TransitionDAO transitionDAO;
    protected ToolDAO toolDAO;
    protected LicenseDAO licenseDAO;
    protected GroupingDAO groupingDAO;
    protected GroupDAO groupDAO;
    protected ICSSThemeDAO themeDAO;
    protected ToolContentIDGenerator contentIDGenerator;
    private FlashMessage flashMessage;

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setWorkspaceFolderDAO(WorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public ICSSThemeDAO getThemeDAO() {
        return this.themeDAO;
    }

    public void setThemeDAO(ICSSThemeDAO themeDAO) {
        this.themeDAO = themeDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    public LearningDesign getLearningDesign(Long learningDesignID) {
        return this.learningDesignDAO.getLearningDesignById(learningDesignID);
    }

    public void saveLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.insert((Object)learningDesign);
    }

    public List getAllLearningDesigns() {
        return this.learningDesignDAO.getAllLearningDesigns();
    }

    public void updateLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.update((Object)learningDesign);
    }

    public List getAllLearningLibraries() {
        return this.learningLibraryDAO.getAllLearningLibraries();
    }

    public String getLearningDesignDetails(Long learningDesignID) throws IOException {
        Object wddxPacket = null;
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (design == null) {
            this.flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"getLearningDesignDetails", (Long)learningDesignID);
        } else {
            LearningDesignDTO learningDesignDTO = design.getLearningDesignDTO();
            this.flashMessage = new FlashMessage("getLearningDesignDetails", (Object)learningDesignDTO);
        }
        return this.flashMessage.serializeMessage();
    }

    public String copyLearningDesign(Long originalDesignID, Integer copyType, Integer userID, Integer workspaceFolderID) throws UserException, LearningDesignException, WorkspaceFolderException, IOException {
        LearningDesign originalDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (originalDesign == null) {
            throw new LearningDesignException("No Learning Design with learning_design_id of:" + originalDesignID + " exists");
        }
        User user = this.userDAO.getUserById(userID);
        if (user == null) {
            throw new UserException("No such User with a user_id of:" + userID + " exists");
        }
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
        if (workspaceFolder == null) {
            throw new WorkspaceFolderException("No such WorkspaceFolder with workspace_folder_id of:" + workspaceFolderID + " exists");
        }
        LearningDesign designCopy = this.copyLearningDesign(originalDesign, copyType, user, workspaceFolder);
        this.flashMessage = new FlashMessage("copyLearningDesign", (Object)designCopy.getLearningDesignId());
        return this.flashMessage.serializeMessage();
    }

    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user) {
        Integer userId = user.getUserId();
        WorkspaceFolder runSequencesFolder = this.workspaceFolderDAO.getRunSequencesFolderForUser(userId);
        return this.copyLearningDesign(originalLearningDesign, copyType, user, runSequencesFolder);
    }

    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user, WorkspaceFolder workspaceFolder) {
        LearningDesign newLearningDesign = LearningDesign.createLearningDesignCopy((LearningDesign)originalLearningDesign, (Integer)copyType);
        newLearningDesign.setUser(user);
        newLearningDesign.setWorkspaceFolder(workspaceFolder);
        this.learningDesignDAO.insert((Object)newLearningDesign);
        this.updateDesignActivities(originalLearningDesign, newLearningDesign);
        this.calculateFirstActivity(originalLearningDesign, newLearningDesign);
        this.updateDesignTransitions(originalLearningDesign, newLearningDesign);
        return newLearningDesign;
    }

    private void calculateFirstActivity(LearningDesign oldDesign, LearningDesign newDesign) {
        Integer oldUIID = oldDesign.getFirstActivity().getActivityUIID();
        Activity firstActivity = this.activityDAO.getActivityByUIID(oldUIID, newDesign);
        newDesign.setFirstActivity(firstActivity);
        Integer learning_design_ui_id = new Integer(newDesign.getLearningDesignId().intValue());
        newDesign.setLearningDesignUIID(learning_design_ui_id);
    }

    private void updateDesignActivities(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        HashSet<Activity> newActivities = new HashSet<Activity>();
        TreeSet oldParentActivities = new TreeSet(new ActivityOrderComparator());
        oldParentActivities.addAll(originalLearningDesign.getParentActivities());
        for (Activity parentActivity : oldParentActivities) {
            Activity newParentActivity = this.getActivityCopy(parentActivity);
            newParentActivity.setLearningDesign(newLearningDesign);
            this.activityDAO.insert((Object)newParentActivity);
            newActivities.add(newParentActivity);
            TreeSet oldChildActivities = new TreeSet(new ActivityOrderComparator());
            oldChildActivities.addAll(this.getChildActivities(parentActivity));
            for (Activity childActivity : oldChildActivities) {
                Activity newChildActivity = this.getActivityCopy(childActivity);
                newChildActivity.setParentActivity(newParentActivity);
                newChildActivity.setParentUIID(newParentActivity.getActivityUIID());
                newChildActivity.setLearningDesign(newLearningDesign);
                this.activityDAO.insert((Object)newChildActivity);
                newActivities.add(newChildActivity);
            }
        }
        newLearningDesign.setActivities(newActivities);
    }

    public void updateDesignTransitions(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        Set oldTransitions = originalLearningDesign.getTransitions();
        for (Transition transition : oldTransitions) {
            Transition newTransition = Transition.createCopy((Transition)transition);
            Activity toActivity = null;
            Activity fromActivity = null;
            if (newTransition.getToUIID() != null) {
                toActivity = this.activityDAO.getActivityByUIID(newTransition.getToUIID(), newLearningDesign);
            }
            if (newTransition.getFromUIID() != null) {
                fromActivity = this.activityDAO.getActivityByUIID(newTransition.getFromUIID(), newLearningDesign);
            }
            newTransition.setToActivity(toActivity);
            newTransition.setFromActivity(fromActivity);
            newTransition.setLearningDesign(newLearningDesign);
            this.transitionDAO.insert((Object)newTransition);
            newTransitions.add(newTransition);
        }
        newLearningDesign.setTransitions(newTransitions);
    }

    private Activity getActivityCopy(Activity activity) {
        if (2 == activity.getActivityTypeId()) {
            GroupingActivity newGroupingActivity = (GroupingActivity)activity.createCopy();
            Grouping grouping = newGroupingActivity.getCreateGrouping();
            if (grouping != null) {
                this.groupingDAO.insert((Object)grouping);
            }
            return newGroupingActivity;
        }
        return activity.createCopy();
    }

    private HashSet getChildActivities(Activity parentActivity) {
        HashSet childActivities = new HashSet();
        List list = this.activityDAO.getActivitiesByParentActivityId(parentActivity.getActivityId());
        if (list != null) {
            childActivities.addAll(list);
        }
        return childActivities;
    }

    public String storeLearningDesignDetails(String wddxPacket) throws Exception {
        Object learningDesignDTO = null;
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        ObjectExtractor extractor = new ObjectExtractor(this.userDAO, this.learningDesignDAO, this.activityDAO, this.workspaceFolderDAO, this.learningLibraryDAO, this.licenseDAO, this.groupingDAO, this.toolDAO, this.groupDAO, this.transitionDAO);
        try {
            LearningDesign design = extractor.extractLearningDesign(table);
            LearningDesignValidator validator = new LearningDesignValidator(this.learningDesignDAO);
            this.flashMessage = validator.validateLearningDesign(design);
        }
        catch (ObjectExtractorException e) {
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)("Invalid Object in WDDX packet. Error was " + e.getMessage()), 1);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getAllLearningDesignDetails() throws IOException {
        Iterator iterator = this.getAllLearningDesigns().iterator();
        ArrayList arrayList = this.createDesignDetailsPacket(iterator);
        this.flashMessage = new FlashMessage("getAllLearningDesignDetails", (Object)arrayList);
        return this.flashMessage.serializeMessage();
    }

    private ArrayList createDesignDetailsPacket(Iterator iterator) {
        ArrayList<DesignDetailDTO> arrayList = new ArrayList<DesignDetailDTO>();
        while (iterator.hasNext()) {
            LearningDesign learningDesign = (LearningDesign)iterator.next();
            DesignDetailDTO designDetailDTO = learningDesign.getDesignDetailDTO();
            arrayList.add(designDetailDTO);
        }
        return arrayList;
    }

    public String getLearningDesignsForUser(Long userID) throws IOException {
        List list = this.learningDesignDAO.getLearningDesignByUserId(userID);
        ArrayList arrayList = this.createDesignDetailsPacket(list.iterator());
        this.flashMessage = new FlashMessage("getLearningDesignsForUser", (Object)arrayList);
        return this.flashMessage.serializeMessage();
    }

    public String getAllLearningLibraryDetails() throws IOException {
        Iterator iterator = this.getAllLearningLibraries().iterator();
        ArrayList<LearningLibraryDTO> libraries = new ArrayList<LearningLibraryDTO>();
        while (iterator.hasNext()) {
            LearningLibrary learningLibrary = (LearningLibrary)iterator.next();
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            if (templateActivities != null & templateActivities.size() == 0) {
                this.log.error((Object)("Learning Library with ID " + learningLibrary.getLearningLibraryId() + " does not have a template activity"));
            }
            libraries.add(learningLibrary.getLearningLibraryDTO(templateActivities));
        }
        this.flashMessage = new FlashMessage("getAllLearningLibraryDetails", libraries);
        return this.flashMessage.serializeMessage();
    }

    public String storeTheme(String wddxPacket) throws Exception {
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        CSSThemeDTO themeDTO = new CSSThemeDTO(table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converted Theme packet. Packet was \n" + wddxPacket + "\nDTO is\n" + themeDTO));
        }
        CSSThemeVisualElement dbTheme = null;
        CSSThemeVisualElement storedTheme = null;
        if (themeDTO.getId() != null) {
            dbTheme = this.themeDAO.getThemeById(themeDTO.getId());
        }
        storedTheme = dbTheme == null ? themeDTO.createCSSThemeVisualElement() : themeDTO.updateCSSTheme(dbTheme);
        this.themeDAO.saveOrUpdateTheme(storedTheme);
        this.flashMessage = new FlashMessage("storeTheme", (Object)storedTheme.getId());
        return this.flashMessage.serializeMessage();
    }

    public String getTheme(Long themeId) throws IOException {
        CSSThemeVisualElement theme = this.themeDAO.getThemeById(themeId);
        if (theme == null) {
            this.flashMessage = FlashMessage.getNoSuchTheme((String)"wddxPacket", (Long)themeId);
        } else {
            CSSThemeDTO dto = new CSSThemeDTO(theme);
            this.flashMessage = new FlashMessage("getTheme", (Object)dto);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getThemes() throws IOException {
        List themes = this.themeDAO.getAllThemes();
        ArrayList<CSSThemeBriefDTO> themeList = new ArrayList<CSSThemeBriefDTO>();
        Iterator iterator = themes.iterator();
        while (iterator.hasNext()) {
            CSSThemeBriefDTO dto = new CSSThemeBriefDTO((CSSThemeVisualElement)iterator.next());
            themeList.add(dto);
        }
        this.flashMessage = new FlashMessage("getThemes", themeList);
        return this.flashMessage.serializeMessage();
    }

    public String getToolContentID(Long toolID) throws IOException {
        Tool tool = this.toolDAO.getToolByID(toolID);
        if (tool == null) {
            this.log.error((Object)("The toolID " + toolID + " is not valid. A Tool with tool id " + toolID + " does not exist on the database."));
            return FlashMessage.getNoSuchTool((String)"getToolContentID", (Long)toolID).serializeMessage();
        }
        Long newContentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        this.flashMessage = new FlashMessage("getToolContentID", (Object)newContentID);
        return this.flashMessage.serializeMessage();
    }

    public Vector getAvailableLicenses() {
        List licenses = this.licenseDAO.findAll(License.class);
        Vector<LicenseDTO> licenseDTOList = new Vector<LicenseDTO>(licenses.size());
        for (License element : licenses) {
            licenseDTOList.add(element.getLicenseDTO(Configuration.get((String)ConfigurationKeys.SERVER_URL)));
        }
        return licenseDTOList;
    }
}

