/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethodParameter;
import org.lamsfoundation.lams.util.XmlFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AuthenticationMethodConfigurer {
    private static Document authConfigureDoc = null;
    private static String configFilePath;

    public static String getConfigFilePath() {
        return configFilePath;
    }

    public static void setConfigFilePath(String configFilePath) {
        AuthenticationMethodConfigurer.configFilePath = configFilePath;
    }

    private static void loadConfiguration() throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        if (authConfigureDoc == null) {
            authConfigureDoc = XmlFileLoader.getDocumentFromFilePath((String)configFilePath);
        }
    }

    private static Element findMethodElement(String methodName) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        NodeList nodeList = authConfigureDoc.getElementsByTagName("Method");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element ele;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(ele = (Element)node).getAttribute("Name").equals(methodName)) continue;
            return ele;
        }
        return null;
    }

    private static boolean isEnabled(String methodName) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        String enabled = AuthenticationMethodConfigurer.findMethodElement(methodName).getAttribute("Enabled");
        return enabled.equals("true");
    }

    private static List getMethodParameters(String methodName) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        ArrayList<AuthenticationMethodParameter> list = new ArrayList<AuthenticationMethodParameter>();
        NodeList nodeList = AuthenticationMethodConfigurer.findMethodElement(methodName).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element ele;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(ele = (Element)node).getTagName().equals("Param")) continue;
            AuthenticationMethodParameter parameter = new AuthenticationMethodParameter(ele.getAttribute("Name"), ele.getLastChild().getNodeValue());
            list.add(parameter);
        }
        return list;
    }

    public static void configure(AuthenticationMethod method) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        AuthenticationMethodConfigurer.loadConfiguration();
        method.setEnabled(AuthenticationMethodConfigurer.isEnabled(method.getAuthenticationMethodName()));
        method.setAuthenticationMethodParameters(AuthenticationMethodConfigurer.getMethodParameters(method.getAuthenticationMethodName()));
    }
}

