/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class JspRedirectStrategy {
    public static final String AUTH_OBJECT_NAME = "authorizationObjectName";
    public static final String SECURITY_CHECK_NOT_PASSED = "SecurityCheckNotPassed";
    public static final String SECURITY_CHECK_PASSED = "securityCheckPassed";
    public static final String WELCOME_PAGE = "index.jsp ";
    private static Logger log = Logger.getLogger(JspRedirectStrategy.class);

    public static boolean loginPageRedirected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>LOGIN PAGE: session not found, simply stop here.");
            return true;
        }
        String checkStatus = (String)session.getAttribute(AUTH_OBJECT_NAME);
        String id = session.getId();
        if (checkStatus == null) {
            log.debug((Object)("===>LOGIN PAGE: there is no auth obj in session, auth obj created. session id: " + id));
            session.setAttribute(AUTH_OBJECT_NAME, (Object)SECURITY_CHECK_NOT_PASSED);
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        if (checkStatus.equals(SECURITY_CHECK_NOT_PASSED)) {
            log.debug((Object)("===>LOGIN PAGE: accessing login page before login succeed, display login page. session id: " + id));
            return false;
        }
        if (checkStatus.equals(SECURITY_CHECK_PASSED)) {
            log.debug((Object)("===>LOGIN PAGE: accessing login after login succeed. Invalidate the session: " + id + " and redirect to " + WELCOME_PAGE));
            session.invalidate();
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        log.debug((Object)("===>LOGIN PAGE: logically impossible to be here, no valid status found : " + id));
        session.invalidate();
        response.sendRedirect(WELCOME_PAGE);
        return true;
    }

    public static void welcomePageStatusUpdate(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>INDEX PAGE: session not found, simply stop here.");
            return;
        }
        if (!session.getAttribute(AUTH_OBJECT_NAME).equals(SECURITY_CHECK_PASSED)) {
            session.setAttribute(AUTH_OBJECT_NAME, (Object)new String(SECURITY_CHECK_PASSED));
        }
    }
}

