/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;

public class LDAPAuthenticator {
    private static Logger log = Logger.getLogger(LDAPAuthenticator.class);
    private static final String USE_OBJECT_CREDENTIAL_OPT = "useObjectCredential";
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private AuthenticationMethod method;

    public LDAPAuthenticator(AuthenticationMethod method) {
        this.method = method;
    }

    public boolean authenticate(String username, String inputPassword) {
        return this.authentication(username, inputPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authentication(String username, Object credential) {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.method.getParameterByName("java.naming.factory.initial").getValue());
        env.setProperty("java.naming.security.authentication", this.method.getParameterByName("java.naming.security.authentication").getValue());
        env.setProperty("java.naming.security.protocol", this.method.getParameterByName("java.naming.security.protocol").getValue());
        String principalDNPrefix = this.method.getParameterByName(PRINCIPAL_DN_PREFIX_OPT).getValue();
        String principalDNSuffix = this.method.getParameterByName(PRINCIPAL_DN_SUFFIX_OPT).getValue();
        String userDN = principalDNPrefix + username + principalDNSuffix;
        env.setProperty("java.naming.security.principal", userDN);
        env.setProperty("java.naming.provider.url", this.method.getParameterByName("java.naming.provider.url").getValue());
        env.put("java.naming.security.credentials", credential);
        String originalTrustStore = System.getProperty("javax.net.ssl.trustStore");
        String originalTrustPass = System.getProperty("javax.net.ssl.trustStorePassword");
        System.setProperty("javax.net.ssl.trustStore", this.method.getParameterByName("truststore.path").getValue());
        System.setProperty("javax.net.ssl.trustStorePassword", this.method.getParameterByName("truststore.password").getValue());
        log.debug((Object)("===> LDAP authenticator: " + env));
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            log.debug((Object)("===> ldap context created: " + ctx));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)("===> Ldap exception: " + e));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("===> gettting problem when closing context. Excetion: " + e));
            }
        }
    }
}

