/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.web.PasswordChangeActionForm;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PasswordChangeAction
extends Action {
    private static Logger log = Logger.getLogger(PasswordChangeAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            request.getSession().removeAttribute("PasswordChangeActionForm");
            return mapping.findForward("cancelled");
        }
        ActionErrors errors = new ActionErrors();
        PasswordChangeActionForm passwordChangeForm = (PasswordChangeActionForm)form;
        if (errors.isEmpty()) {
            try {
                String loggedInUser = request.getRemoteUser();
                String login = passwordChangeForm.getLogin();
                String oldPassword = passwordChangeForm.getOldPassword();
                String password = passwordChangeForm.getPassword();
                if (loggedInUser == null || !loggedInUser.equals(login)) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.authorisation"));
                } else {
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession(true).getServletContext());
                    UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
                    if (!service.getUserByLogin(login).getPassword().equals(oldPassword)) {
                        errors.add("oldPassword", new ActionMessage("error.oldpassword.mismatch"));
                    } else {
                        service.updatePassword(login, password);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            if (mapping.getInput() != null) {
                passwordChangeForm.reset(mapping, request);
                return new ActionForward(mapping.getInput());
            }
            return mapping.findForward("error");
        }
        return mapping.findForward("okay");
    }
}

