/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.development;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.web.development.WDDXPostActionForm;

public class WDDXPostAction
extends Action {
    private static Logger log = Logger.getLogger(WDDXPostAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String packetStart;
        WDDXPostActionForm postForm = (WDDXPostActionForm)form;
        String action = postForm.getUrlAction();
        if (action == null) {
            RuntimeException e = new RuntimeException("Unable to process WDDX file, action is missing. Should be a URL");
            log.error((Object)e);
            throw e;
        }
        FormFile file = postForm.getWddxFile();
        if (file == null) {
            RuntimeException e = new RuntimeException("Unable to process WDDX file, file is missing.");
            log.error((Object)e);
            throw e;
        }
        Cookie[] cookies = req.getCookies();
        URL url = new URL(action);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setRequestMethod("POST");
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setAllowUserInteraction(false);
        urlConn.setInstanceFollowRedirects(true);
        urlConn.setRequestProperty("Cookie", WDDXPostAction.getCookieString(cookies));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
        PrintWriter urlStreamWriter = new PrintWriter(byteStream, true);
        BufferedReader wddxPacketStream = new BufferedReader(new InputStreamReader(file.getInputStream()));
        String line = null;
        while ((line = wddxPacketStream.readLine()) != null) {
            urlStreamWriter.print(line);
        }
        urlStreamWriter.flush();
        wddxPacketStream.close();
        String packet = byteStream.toString();
        String string = packetStart = packet != null ? packet.substring(0, 11) : "";
        if (!packetStart.equalsIgnoreCase("<wddxPacket")) {
            throw new ServletException("Input file did not start with <wddxPacket> tag. Invalid format.");
        }
        log.debug((Object)("Sending packet " + packet));
        String lengthString = String.valueOf(byteStream.size());
        urlConn.setRequestProperty("Content-Length", lengthString);
        byteStream.writeTo(urlConn.getOutputStream());
        urlConn.getOutputStream().flush();
        urlConn.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        PrintWriter writer = res.getWriter();
        while ((line = in.readLine()) != null) {
            ((Writer)writer).write(line);
        }
        in.close();
        urlConn.disconnect();
        return null;
    }

    private static String getCookieString(Cookie[] cookies) {
        StringBuffer cookieString = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            cookieString.append(cookies[i].getName()).append("=").append(cookies[i].getValue());
            if (i == cookies.length - 1) continue;
            cookieString.append(";");
        }
        return cookieString.toString();
    }
}

