/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class CssTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(CssTag.class);
    private boolean generateLocalLink = false;

    public int doStartTag() throws JspException {
        String customStylesheetLink = null;
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        List themeList = CSSThemeUtil.getAllUserThemes();
        for (String theme : themeList) {
            if (theme != null) {
                customStylesheetLink = this.generateLocalLink ? this.generateLocalLink(theme, serverURL) : this.generateLink(theme, serverURL);
            }
            try {
                JspWriter writer = this.pageContext.getOut();
                if (customStylesheetLink == null) continue;
                writer.print(customStylesheetLink);
            }
            catch (IOException e) {
                log.error((Object)"CssTag unable to write out CSS details due to IOException.", (Throwable)e);
            }
        }
        return 0;
    }

    private String generateLocalLink(String stylesheetName, String serverURL) {
        return "<link href=\"../" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
    }

    private String generateLink(String stylesheetName, String serverURL) {
        if (serverURL.endsWith("/")) {
            return "<link href=\"" + serverURL + "css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return "<link href=\"" + serverURL + "/css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
    }

    public int doEndTag() {
        return 6;
    }

    public void setLocalLink(String localLink) {
        this.generateLocalLink = localLink.equalsIgnoreCase("true");
    }
}

